/*
 * Decompiled with CFR 0.152.
 */
package es.weso.shex.validator;

import cats.implicits$;
import cats.syntax.EitherIdOps$;
import es.weso.rdf.RDFReader;
import es.weso.rdf.operations.Comparisons;
import es.weso.rdf.operations.Comparisons$;
import es.weso.shex.AbstractSchema;
import es.weso.shex.FractionDigits;
import es.weso.shex.Length;
import es.weso.shex.MaxExclusive;
import es.weso.shex.MaxInclusive;
import es.weso.shex.MaxLength;
import es.weso.shex.MinExclusive;
import es.weso.shex.MinInclusive;
import es.weso.shex.MinLength;
import es.weso.shex.NumericFacet;
import es.weso.shex.Pattern;
import es.weso.shex.StringFacet;
import es.weso.shex.TotalDigits;
import es.weso.shex.validator.FacetChecker;
import es.weso.utils.RegEx;
import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class FacetChecker$
implements Serializable {
    public static final FacetChecker$ MODULE$ = new FacetChecker$();

    public Either<FacetChecker.StringFacetError, BoxedUnit> stringFacetChecker(String str, StringFacet facet) {
        StringFacet stringFacet = facet;
        if (stringFacet instanceof Pattern) {
            Option<String> flags;
            Pattern pattern = (Pattern)stringFacet;
            String p = pattern.p();
            Either either = new RegEx(p, flags = pattern.flags()).matches(str);
            if (either instanceof Right) {
                Right right = (Right)either;
                boolean b = BoxesRunTime.unboxToBoolean((Object)right.value());
                if (b) {
                    return this.ok();
                }
                return EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new FacetChecker.StringFacetError.PatternMatchFalse(str, p, flags)));
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                String msg = (String)left.value();
                return EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new FacetChecker.StringFacetError.PatternMatchError(str, p, flags, msg)));
            }
            throw new MatchError((Object)either);
        }
        if (stringFacet instanceof MinLength) {
            MinLength minLength = (MinLength)stringFacet;
            int n = minLength.v();
            if (str.length() >= n) {
                return this.ok();
            }
            return EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new FacetChecker.StringFacetError.MinLengthFails(str, n)));
        }
        if (stringFacet instanceof MaxLength) {
            MaxLength maxLength = (MaxLength)stringFacet;
            int n = maxLength.v();
            if (str.length() <= n) {
                return this.ok();
            }
            return EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new FacetChecker.StringFacetError.MaxLengthFails(str, n)));
        }
        if (stringFacet instanceof Length) {
            Length length = (Length)stringFacet;
            int n = length.v();
            if (str.length() == n) {
                return this.ok();
            }
            return EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new FacetChecker.StringFacetError.LengthFails(str, n)));
        }
        throw new MatchError((Object)stringFacet);
    }

    public Either<Nothing$, BoxedUnit> ok() {
        return EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)BoxedUnit.UNIT));
    }

    public Either<FacetChecker.NumericFacetError, BoxedUnit> numericFacetChecker(Comparisons.NumericLiteral nl, NumericFacet facet) {
        NumericFacet numericFacet = facet;
        if (numericFacet instanceof MinInclusive) {
            MinInclusive minInclusive = (MinInclusive)numericFacet;
            Comparisons.NumericLiteral n = minInclusive.n();
            if (Comparisons$.MODULE$.lessThanOrEquals(n, nl)) {
                return this.ok();
            }
            return EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new FacetChecker.NumericFacetError.MinInclusiveFails(nl, n)));
        }
        if (numericFacet instanceof MaxInclusive) {
            MaxInclusive maxInclusive = (MaxInclusive)numericFacet;
            Comparisons.NumericLiteral n = maxInclusive.n();
            if (Comparisons$.MODULE$.lessThanOrEquals(nl, n)) {
                return this.ok();
            }
            return EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new FacetChecker.NumericFacetError.MaxInclusiveFails(nl, n)));
        }
        if (numericFacet instanceof MinExclusive) {
            MinExclusive minExclusive = (MinExclusive)numericFacet;
            Comparisons.NumericLiteral n = minExclusive.n();
            if (Comparisons$.MODULE$.lessThan(n, nl)) {
                return this.ok();
            }
            return EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new FacetChecker.NumericFacetError.MinExclusiveFails(nl, n)));
        }
        if (numericFacet instanceof MaxExclusive) {
            MaxExclusive maxExclusive = (MaxExclusive)numericFacet;
            Comparisons.NumericLiteral n = maxExclusive.n();
            if (Comparisons$.MODULE$.lessThan(nl, n)) {
                return this.ok();
            }
            return EitherIdOps$.MODULE$.asLeft$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)new FacetChecker.NumericFacetError.MaxExclusiveFails(nl, n)));
        }
        if (numericFacet instanceof TotalDigits) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        if (numericFacet instanceof FractionDigits) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        throw new MatchError((Object)numericFacet);
    }

    public FacetChecker apply(AbstractSchema schema, RDFReader rdf) {
        return new FacetChecker(schema, rdf);
    }

    public Option<Tuple2<AbstractSchema, RDFReader>> unapply(FacetChecker x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.schema(), (Object)x$0.rdf()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FacetChecker$.class);
    }

    private FacetChecker$() {
    }
}

