/*
 * Decompiled with CFR 0.152.
 */
package es.weso.shex.validator.validatorref;

import cats.Applicative;
import cats.Foldable;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.implicits$;
import cats.kernel.Semigroup;
import cats.syntax.OptionIdOps$;
import cats.syntax.ValidatedIdSyntax$;
import es.weso.rdf.nodes.IRI;
import es.weso.rdf.nodes.Literal;
import es.weso.rdf.nodes.RDFNode;
import es.weso.shex.BNodeKind$;
import es.weso.shex.IRIKind$;
import es.weso.shex.LiteralKind$;
import es.weso.shex.NodeConstraint;
import es.weso.shex.NodeKind;
import es.weso.shex.NonLiteralKind$;
import es.weso.shex.ValueSetValue;
import es.weso.shex.XsFacet;
import es.weso.shex.validator.validatorref.BNodeKindError;
import es.weso.shex.validator.validatorref.BNodeKindEvidence;
import es.weso.shex.validator.validatorref.DatatypeErrorNonLiteral;
import es.weso.shex.validator.validatorref.DatatypeEvidence;
import es.weso.shex.validator.validatorref.IRIKindError;
import es.weso.shex.validator.validatorref.IRIKindEvidence;
import es.weso.shex.validator.validatorref.LiteralKindError;
import es.weso.shex.validator.validatorref.LiteralKindEvidence;
import es.weso.shex.validator.validatorref.LiteralNonDatatypeError;
import es.weso.shex.validator.validatorref.NodeConstraintError;
import es.weso.shex.validator.validatorref.NodeConstraintEvidence;
import es.weso.shex.validator.validatorref.NonLiteralKindError;
import es.weso.shex.validator.validatorref.NonLiteralKindEvidence;
import es.weso.shex.validator.validatorref.NotImplementedNodeConstraintError;
import es.weso.shex.validator.validatorref.ValueChecker$;
import es.weso.shex.validator.validatorref.ValueSet;
import es.weso.shex.validator.validatorref.ValueSetError;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class NodeConstraintValidator$ {
    public static final NodeConstraintValidator$ MODULE$ = new NodeConstraintValidator$();

    public IO<Validated<NonEmptyList<NodeConstraintError>, List<NodeConstraintEvidence>>> validateNodeConstraint(RDFNode node, NodeConstraint nc) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.combineVs((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Validated[]{MODULE$.optValidate(nc.nodeKind(), node, (Function2 & Serializable)(nk, node) -> MODULE$.nodeKind((NodeKind)nk, (RDFNode)node)), MODULE$.optValidate(nc.datatype(), node, (Function2 & Serializable)(dt, node) -> MODULE$.datatype((IRI)dt, (RDFNode)node)), MODULE$.optValidate(nc.values(), node, (Function2 & Serializable)(vs, node) -> MODULE$.values((List<ValueSetValue>)vs, (RDFNode)node))})).combine(MODULE$.validateList(nc.xsFacets(), node, (Function2 & Serializable)(f, node) -> MODULE$.facet((XsFacet)f, (RDFNode)node)), NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList(), (Semigroup)implicits$.MODULE$.catsKernelStdMonoidForList()));
    }

    private Validated<NonEmptyList<NodeConstraintError>, NodeConstraintEvidence> nodeKind(NodeKind nk, RDFNode node) {
        NodeKind nodeKind = nk;
        if (IRIKind$.MODULE$.equals(nodeKind)) {
            if (node.isIRI()) {
                return ValidatedIdSyntax$.MODULE$.valid$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new IRIKindEvidence(node)));
            }
            return ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new IRIKindError(node)));
        }
        if (BNodeKind$.MODULE$.equals(nodeKind)) {
            if (node.isBNode()) {
                return ValidatedIdSyntax$.MODULE$.valid$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new BNodeKindEvidence(node)));
            }
            return ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new BNodeKindError(node)));
        }
        if (NonLiteralKind$.MODULE$.equals(nodeKind)) {
            if (!node.isLiteral()) {
                return ValidatedIdSyntax$.MODULE$.valid$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new NonLiteralKindEvidence(node)));
            }
            return ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new NonLiteralKindError(node)));
        }
        if (LiteralKind$.MODULE$.equals(nodeKind)) {
            if (node.isLiteral()) {
                return ValidatedIdSyntax$.MODULE$.valid$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new LiteralKindEvidence(node)));
            }
            return ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new LiteralKindError(node)));
        }
        throw new MatchError((Object)nodeKind);
    }

    private Validated<NonEmptyList<NodeConstraintError>, NodeConstraintEvidence> datatype(IRI dt, RDFNode node) {
        RDFNode rDFNode = node;
        if (rDFNode instanceof Literal) {
            Literal literal = (Literal)rDFNode;
            IRI iRI = literal.dataType();
            IRI iRI2 = dt;
            if (!(iRI != null ? !iRI.equals(iRI2) : iRI2 != null)) {
                return ValidatedIdSyntax$.MODULE$.valid$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new DatatypeEvidence(node, dt)));
            }
            return ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new LiteralNonDatatypeError(node, literal.dataType(), dt)));
        }
        return ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new DatatypeErrorNonLiteral(node, dt)));
    }

    private Validated<NonEmptyList<NodeConstraintError>, NodeConstraintEvidence> values(List<ValueSetValue> vs, RDFNode node) {
        List conforms = vs.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NodeConstraintValidator$.$anonfun$values$1(node, x$1)));
        if (conforms.nonEmpty()) {
            return ValidatedIdSyntax$.MODULE$.valid$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new ValueSet(node, (List<ValueSetValue>)conforms, vs)));
        }
        return ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new ValueSetError(node, vs)));
    }

    private Validated<NonEmptyList<NodeConstraintError>, NodeConstraintEvidence> facet(XsFacet f, RDFNode node) {
        return ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new NotImplementedNodeConstraintError(node, new StringBuilder(6).append("facet ").append(f).toString())));
    }

    private <A, B, V, E> Validated<NonEmptyList<E>, Option<B>> optValidate(Option<A> optValue, V value, Function2<A, V, Validated<NonEmptyList<E>, B>> validator) {
        return (Validated)optValue.fold((Function0 & Serializable)() -> ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)implicits$.MODULE$.none())), (Function1 & Serializable)c -> ((Validated)validator.apply(c, value)).map((Function1 & Serializable)x$2 -> OptionIdOps$.MODULE$.some$extension(implicits$.MODULE$.catsSyntaxOptionId(x$2))));
    }

    private <A, B, E, V> Validated<NonEmptyList<E>, List<B>> validateList(List<A> vs, V value, Function2<A, V, Validated<NonEmptyList<E>, B>> validator) {
        return (Validated)implicits$.MODULE$.toTraverseOps((Object)vs.map((Function1 & Serializable)x$3 -> (Validated)validator.apply(x$3, value)), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()));
    }

    private <E, A> Validated<NonEmptyList<E>, List<A>> combineVs(Seq<Validated<NonEmptyList<E>, Option<A>>> vs) {
        return (Validated)implicits$.MODULE$.toFoldableOps((Object)vs.toList().map((Function1 & Serializable)x$4 -> x$4.map((Function1 & Serializable)x$5 -> x$5.toList())), (Foldable)implicits$.MODULE$.catsStdInstancesForList()).combineAll(Validated$.MODULE$.catsDataMonoidForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList(), implicits$.MODULE$.catsKernelStdMonoidForList()));
    }

    public static final /* synthetic */ boolean $anonfun$values$1(RDFNode node$2, ValueSetValue x$1) {
        return ValueChecker$.MODULE$.valueChecker(node$2, x$1).isRight();
    }

    private NodeConstraintValidator$() {
    }
}

