/*
 * Decompiled with CFR 0.152.
 */
package es.weso.shex.validator.validatorref;

import cats.implicits$;
import cats.kernel.Eq;
import es.weso.rdf.PREFIXES$;
import es.weso.rdf.nodes.IRI;
import es.weso.rdf.nodes.IRI$;
import es.weso.rdf.nodes.Lang;
import es.weso.rdf.nodes.LangLiteral;
import es.weso.rdf.nodes.Literal;
import es.weso.rdf.nodes.RDFNode;
import es.weso.rdf.nodes.RDFNode$;
import es.weso.shex.DatatypeString;
import es.weso.shex.IRIExclusion;
import es.weso.shex.IRIRefExclusion;
import es.weso.shex.IRIStem;
import es.weso.shex.IRIStemExclusion;
import es.weso.shex.IRIStemRange;
import es.weso.shex.IRIStemRangeValue;
import es.weso.shex.IRIStemValueIRI;
import es.weso.shex.IRIStemWildcard;
import es.weso.shex.IRIValue;
import es.weso.shex.LangString;
import es.weso.shex.Language;
import es.weso.shex.LanguageExclusion;
import es.weso.shex.LanguageStem;
import es.weso.shex.LanguageStemExclusion;
import es.weso.shex.LanguageStemRange;
import es.weso.shex.LanguageStemRangeLang;
import es.weso.shex.LanguageStemRangeValue;
import es.weso.shex.LanguageStemRangeWildcard;
import es.weso.shex.LanguageTagExclusion;
import es.weso.shex.LiteralExclusion;
import es.weso.shex.LiteralStem;
import es.weso.shex.LiteralStemExclusion;
import es.weso.shex.LiteralStemRange;
import es.weso.shex.LiteralStemRangeString;
import es.weso.shex.LiteralStemRangeValue;
import es.weso.shex.LiteralStemRangeWildcard;
import es.weso.shex.LiteralStringExclusion;
import es.weso.shex.StringValue;
import es.weso.shex.ValueSetValue;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class ValueChecker$ {
    public static final ValueChecker$ MODULE$ = new ValueChecker$();

    public Either<String, String> valueChecker(RDFNode node, ValueSetValue value) {
        ValueSetValue valueSetValue = value;
        if (valueSetValue instanceof IRIValue) {
            IRIValue iRIValue = (IRIValue)valueSetValue;
            IRI iri = iRIValue.i();
            RDFNode rDFNode = node;
            if (rDFNode instanceof IRI) {
                IRI iRI = (IRI)rDFNode;
                IRI iRI2 = iri;
                IRI iRI3 = iRI;
                if (!(iRI2 != null ? !iRI2.equals(iRI3) : iRI3 != null)) {
                    return package$.MODULE$.Right().apply((Object)new StringBuilder(13).append(implicits$.MODULE$.toShow((Object)iri, IRI$.MODULE$.iriShow()).show()).append(" is equal to ").append(implicits$.MODULE$.toShow((Object)iRI, IRI$.MODULE$.iriShow()).show()).toString());
                }
                return package$.MODULE$.Left().apply((Object)new StringBuilder(4).append(implicits$.MODULE$.toShow((Object)iri, IRI$.MODULE$.iriShow()).show()).append(" != ").append(implicits$.MODULE$.toShow((Object)iRI, IRI$.MODULE$.iriShow()).show()).toString());
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(4).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" != ").append(implicits$.MODULE$.toShow((Object)iri, IRI$.MODULE$.iriShow()).show()).toString());
        }
        if (valueSetValue instanceof StringValue) {
            StringValue stringValue = (StringValue)valueSetValue;
            String s = stringValue.s();
            RDFNode rDFNode = node;
            if (rDFNode instanceof Literal) {
                Literal literal = (Literal)rDFNode;
                String string = s;
                String string2 = literal.getLexicalForm();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    IRI iRI = literal.dataType();
                    IRI iRI4 = PREFIXES$.MODULE$.xsd$colonstring();
                    if (!(iRI != null ? !iRI.equals(iRI4) : iRI4 != null)) {
                        return package$.MODULE$.Right().apply((Object)new StringBuilder(4).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" == ").append(literal).toString());
                    }
                }
                return package$.MODULE$.Left().apply((Object)new StringBuilder(4).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" != ").append(literal).toString());
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(4).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" != ").append(value).toString());
        }
        if (valueSetValue instanceof DatatypeString) {
            DatatypeString datatypeString = (DatatypeString)valueSetValue;
            String s = datatypeString.s();
            IRI iri = datatypeString.iri();
            RDFNode rDFNode = node;
            if (rDFNode instanceof Literal) {
                Literal literal = (Literal)rDFNode;
                String string = s;
                String string3 = literal.getLexicalForm();
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    IRI iRI = iri;
                    IRI iRI5 = literal.dataType();
                    if (!(iRI != null ? !iRI.equals(iRI5) : iRI5 != null)) {
                        return package$.MODULE$.Right().apply((Object)new StringBuilder(4).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" == ").append(literal).toString());
                    }
                }
                return package$.MODULE$.Left().apply((Object)new StringBuilder(4).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" != ").append(literal).toString());
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(4).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" != ").append(value).toString());
        }
        if (valueSetValue instanceof LangString) {
            LangString langString = (LangString)valueSetValue;
            String s = langString.s();
            Lang lang = langString.lang();
            RDFNode rDFNode = node;
            if (rDFNode instanceof LangLiteral) {
                LangLiteral langLiteral = (LangLiteral)rDFNode;
                String str = langLiteral.lexicalForm();
                Lang l = langLiteral.lang();
                String string = s;
                String string4 = str;
                if (!(string != null ? !string.equals(string4) : string4 != null)) {
                    Lang lang2 = lang;
                    Lang lang3 = l;
                    if (!(lang2 != null ? !lang2.equals(lang3) : lang3 != null)) {
                        return package$.MODULE$.Right().apply((Object)new StringBuilder(4).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" == ").append(value).toString());
                    }
                }
                return package$.MODULE$.Left().apply((Object)new StringBuilder(4).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" != ").append(value).toString());
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(4).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" != ").append(value).toString());
        }
        if (valueSetValue instanceof LanguageStem) {
            LanguageStem languageStem = (LanguageStem)valueSetValue;
            Lang stem = languageStem.stem();
            RDFNode rDFNode = node;
            if (rDFNode instanceof LangLiteral) {
                LangLiteral langLiteral = (LangLiteral)rDFNode;
                if (this.checkLanguageStem(langLiteral.lang(), stem)) {
                    return package$.MODULE$.Right().apply((Object)new StringBuilder(16).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" lang(").append(langLiteral.lang()).append(") matches ").append(stem).toString());
                }
                return package$.MODULE$.Left().apply((Object)new StringBuilder(23).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" lang(").append(langLiteral.lang()).append(") does not match ").append(stem).toString());
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(33).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" is not a language tagged literal").toString());
        }
        if (valueSetValue instanceof LanguageStemRange) {
            LanguageStemRange languageStemRange = (LanguageStemRange)valueSetValue;
            LanguageStemRangeValue stem = languageStemRange.stem();
            Option<List<LanguageExclusion>> excls = languageStemRange.exclusions();
            RDFNode rDFNode = node;
            if (rDFNode instanceof LangLiteral) {
                LangLiteral langLiteral = (LangLiteral)rDFNode;
                Lang lang = langLiteral.lang();
                if (this.checkLangStemRange(lang, stem, excls)) {
                    return package$.MODULE$.Right().apply((Object)new StringBuilder(16).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" lang(").append(lang).append(") matches ").append(languageStemRange).toString());
                }
                return package$.MODULE$.Left().apply((Object)new StringBuilder(23).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" lang(").append(lang).append(") does not match ").append(languageStemRange).toString());
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(33).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" is not a language tagged literal").toString());
        }
        if (valueSetValue instanceof Language) {
            LangLiteral langLiteral;
            Lang lang;
            Language language = (Language)valueSetValue;
            Lang langTag = language.languageTag();
            RDFNode rDFNode = node;
            if (rDFNode instanceof LangLiteral && (lang = (langLiteral = (LangLiteral)rDFNode).lang()) != null) {
                String lang4 = lang.lang();
                if (langTag.lang().equalsIgnoreCase(lang4)) {
                    return package$.MODULE$.Right().apply((Object)new StringBuilder(16).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" lang(").append(lang4).append(") matches ").append(langTag).toString());
                }
                return package$.MODULE$.Left().apply((Object)new StringBuilder(23).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" lang(").append(lang4).append(") does not match ").append(langTag).toString());
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(33).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" is not a language tagged literal").toString());
        }
        if (valueSetValue instanceof IRIStem) {
            IRIStem iRIStem = (IRIStem)valueSetValue;
            IRI stem = iRIStem.stem();
            RDFNode rDFNode = node;
            if (rDFNode instanceof IRI) {
                IRI iRI = (IRI)rDFNode;
                if (iRI.getLexicalForm().startsWith(stem.getLexicalForm())) {
                    return package$.MODULE$.Right().apply((Object)new StringBuilder(19).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" matches with stem ").append(implicits$.MODULE$.toShow((Object)stem, IRI$.MODULE$.iriShow()).show()).toString());
                }
                return package$.MODULE$.Left().apply((Object)new StringBuilder(21).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" does not match stem ").append(implicits$.MODULE$.toShow((Object)stem, IRI$.MODULE$.iriShow()).show()).toString());
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(39).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" must be an IRI to match with IRI stem ").append(implicits$.MODULE$.toShow((Object)stem, IRI$.MODULE$.iriShow()).show()).toString());
        }
        if (valueSetValue instanceof IRIStemRange) {
            IRIStemRange iRIStemRange = (IRIStemRange)valueSetValue;
            IRIStemRangeValue stem = iRIStemRange.stem();
            Option<List<IRIExclusion>> excls = iRIStemRange.exclusions();
            RDFNode rDFNode = node;
            if (rDFNode instanceof IRI) {
                IRI iRI = (IRI)rDFNode;
                if (this.checkIRIStemRange(iRI, stem, excls)) {
                    return package$.MODULE$.Right().apply((Object)new StringBuilder(24).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" matches IRI stem range ").append(iRIStemRange).toString());
                }
                return package$.MODULE$.Left().apply((Object)new StringBuilder(31).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" does not match IRI stem range ").append(iRIStemRange).toString());
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(14).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" is not an IRI").toString());
        }
        if (valueSetValue instanceof LiteralStem) {
            LiteralStem literalStem = (LiteralStem)valueSetValue;
            String stem = literalStem.stem();
            RDFNode rDFNode = node;
            if (rDFNode instanceof Literal) {
                Literal literal = (Literal)rDFNode;
                if (literal.getLexicalForm().startsWith(stem)) {
                    return package$.MODULE$.Right().apply((Object)new StringBuilder(19).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" matches with stem ").append(implicits$.MODULE$.toShow((Object)stem, implicits$.MODULE$.catsStdShowForString()).show()).toString());
                }
                return package$.MODULE$.Left().apply((Object)new StringBuilder(21).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" does not match stem ").append(implicits$.MODULE$.toShow((Object)stem, implicits$.MODULE$.catsStdShowForString()).show()).toString());
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(46).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" must be a Literal to match with Literal stem ").append(implicits$.MODULE$.toShow((Object)stem, implicits$.MODULE$.catsStdShowForString()).show()).toString());
        }
        if (valueSetValue instanceof LiteralStemRange) {
            LiteralStemRange literalStemRange = (LiteralStemRange)valueSetValue;
            LiteralStemRangeValue stem = literalStemRange.stem();
            Option<List<LiteralExclusion>> excls = literalStemRange.exclusions();
            RDFNode rDFNode = node;
            if (rDFNode instanceof Literal) {
                Literal literal = (Literal)rDFNode;
                if (this.checkLiteralStemRange(literal, stem, excls)) {
                    return package$.MODULE$.Right().apply((Object)new StringBuilder(28).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" matches Literal stem range ").append(literalStemRange).toString());
                }
                return package$.MODULE$.Left().apply((Object)new StringBuilder(35).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" does not match Literal stem range ").append(literalStemRange).toString());
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(17).append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" is not a Literal").toString());
        }
        throw new MatchError((Object)valueSetValue);
    }

    private boolean checkLanguageStem(Lang l, Lang stem) {
        String strL = l.lang().toLowerCase();
        String strStem = stem.lang().toLowerCase();
        if (strStem.isEmpty()) {
            return true;
        }
        return implicits$.MODULE$.catsSyntaxEq((Object)strL, (Eq)implicits$.MODULE$.catsKernelStdOrderForString()).$eq$eq$eq((Object)strStem) || strL.startsWith(new StringBuilder(1).append(strStem).append("-").toString());
    }

    private boolean checkIRIStemRange(IRI iri, IRIStemRangeValue stemRange, Option<List<IRIExclusion>> excls) {
        boolean bl;
        boolean bl2;
        IRIStemRangeValue iRIStemRangeValue = stemRange;
        if (iRIStemRangeValue instanceof IRIStemWildcard) {
            bl2 = true;
        } else if (iRIStemRangeValue instanceof IRIStemValueIRI) {
            IRIStemValueIRI iRIStemValueIRI = (IRIStemValueIRI)iRIStemRangeValue;
            IRI iriStem = iRIStemValueIRI.iri();
            bl2 = iri.getLexicalForm().startsWith(iriStem.getLexicalForm());
        } else {
            throw new MatchError((Object)iRIStemRangeValue);
        }
        boolean cond1 = bl2;
        Option<List<IRIExclusion>> option = excls;
        if (None$.MODULE$.equals(option)) {
            bl = true;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            List es = (List)some.value();
            bl = es.forall((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ValueChecker$.MODULE$.checkIRIExclusion(iri, e)));
        } else {
            throw new MatchError(option);
        }
        boolean cond2 = bl;
        return cond1 && cond2;
    }

    private boolean checkLiteralStemRange(Literal lit, LiteralStemRangeValue stemRange, Option<List<LiteralExclusion>> excls) {
        boolean bl;
        boolean bl2;
        LiteralStemRangeValue literalStemRangeValue = stemRange;
        if (literalStemRangeValue instanceof LiteralStemRangeWildcard) {
            bl2 = true;
        } else if (literalStemRangeValue instanceof LiteralStemRangeString) {
            LiteralStemRangeString literalStemRangeString = (LiteralStemRangeString)literalStemRangeValue;
            String litStem = literalStemRangeString.str();
            bl2 = lit.getLexicalForm().startsWith(litStem);
        } else {
            throw new MatchError((Object)literalStemRangeValue);
        }
        boolean cond1 = bl2;
        Option<List<LiteralExclusion>> option = excls;
        if (None$.MODULE$.equals(option)) {
            bl = true;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            List es = (List)some.value();
            bl = es.forall((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ValueChecker$.MODULE$.checkLiteralExclusion(lit, e)));
        } else {
            throw new MatchError(option);
        }
        boolean cond2 = bl;
        return cond1 && cond2;
    }

    private boolean checkLangStemRange(Lang lang, LanguageStemRangeValue stemRange, Option<List<LanguageExclusion>> excls) {
        boolean bl;
        boolean bl2;
        LanguageStemRangeValue languageStemRangeValue = stemRange;
        if (languageStemRangeValue instanceof LanguageStemRangeWildcard) {
            bl2 = true;
        } else if (languageStemRangeValue instanceof LanguageStemRangeLang) {
            LanguageStemRangeLang languageStemRangeLang = (LanguageStemRangeLang)languageStemRangeValue;
            Lang stem = languageStemRangeLang.stem();
            bl2 = this.checkLanguageStem(lang, stem);
        } else {
            throw new MatchError((Object)languageStemRangeValue);
        }
        boolean cond1 = bl2;
        Option<List<LanguageExclusion>> option = excls;
        if (None$.MODULE$.equals(option)) {
            bl = true;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            List es = (List)some.value();
            bl = es.forall((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ValueChecker$.MODULE$.checkLanguageExclusion(lang, e)));
        } else {
            throw new MatchError(option);
        }
        boolean cond2 = bl;
        return cond1 && cond2;
    }

    private boolean checkIRIExclusion(IRI iri, IRIExclusion exclusion) {
        IRIExclusion iRIExclusion = exclusion;
        if (iRIExclusion instanceof IRIRefExclusion) {
            IRIRefExclusion iRIRefExclusion = (IRIRefExclusion)iRIExclusion;
            IRI r = iRIRefExclusion.iri();
            String string = iri.getLexicalForm();
            String string2 = r.getLexicalForm();
            return string == null ? string2 != null : !string.equals(string2);
        }
        if (iRIExclusion instanceof IRIStemExclusion) {
            IRIStemExclusion iRIStemExclusion = (IRIStemExclusion)iRIExclusion;
            IRIStem iriStem = iRIStemExclusion.iriStem();
            return !iri.getLexicalForm().startsWith(iriStem.stem().getLexicalForm());
        }
        throw new MatchError((Object)iRIExclusion);
    }

    private boolean checkLiteralExclusion(Literal lit, LiteralExclusion exclusion) {
        LiteralExclusion literalExclusion = exclusion;
        if (literalExclusion instanceof LiteralStringExclusion) {
            LiteralStringExclusion literalStringExclusion = (LiteralStringExclusion)literalExclusion;
            String r = literalStringExclusion.str();
            String string = lit.getLexicalForm();
            String string2 = r;
            return string == null ? string2 != null : !string.equals(string2);
        }
        if (literalExclusion instanceof LiteralStemExclusion) {
            LiteralStemExclusion literalStemExclusion = (LiteralStemExclusion)literalExclusion;
            LiteralStem literalStem = literalStemExclusion.literalStem();
            return !lit.getLexicalForm().startsWith(literalStem.stem());
        }
        throw new MatchError((Object)literalExclusion);
    }

    private boolean checkLanguageExclusion(Lang lang, LanguageExclusion exclusion) {
        LanguageExclusion languageExclusion = exclusion;
        if (languageExclusion instanceof LanguageTagExclusion) {
            LanguageTagExclusion languageTagExclusion = (LanguageTagExclusion)languageExclusion;
            Lang stem = languageTagExclusion.lang();
            String string = lang.lang();
            String string2 = stem.lang();
            return string == null ? string2 != null : !string.equals(string2);
        }
        if (languageExclusion instanceof LanguageStemExclusion) {
            LanguageStemExclusion languageStemExclusion = (LanguageStemExclusion)languageExclusion;
            LanguageStem langStem = languageStemExclusion.languageStem();
            return !this.checkLanguageStem(lang, langStem.stem());
        }
        throw new MatchError((Object)languageExclusion);
    }

    private ValueChecker$() {
    }
}

