/*
 * Decompiled with CFR 0.152.
 */
package es.weso.slang;

import cats.Applicative;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.IndexedStateT;
import cats.data.IndexedStateT$;
import cats.data.package;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.implicits$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import es.weso.rdf.RDFReader;
import es.weso.rdf.nodes.IRI;
import es.weso.rdf.nodes.Literal;
import es.weso.rdf.nodes.RDFNode;
import es.weso.rdf.triples.RDFTriple;
import es.weso.slang.And;
import es.weso.slang.BNodeKind$;
import es.weso.slang.Card;
import es.weso.slang.Conforms$;
import es.weso.slang.Datatype;
import es.weso.slang.IRIKind$;
import es.weso.slang.Label;
import es.weso.slang.NoPreds;
import es.weso.slang.Not;
import es.weso.slang.NotConforms$;
import es.weso.slang.Pred;
import es.weso.slang.PropPath;
import es.weso.slang.QualifiedArc;
import es.weso.slang.Ref;
import es.weso.slang.SLang;
import es.weso.slang.STrue$;
import es.weso.slang.SchemaS;
import es.weso.slang.ShapesMap;
import es.weso.slang.ShapesMap$;
import es.weso.slang.Val;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class Validation$
implements LazyLogging {
    public static final Validation$ MODULE$ = new Validation$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        Validation$ validation$ = this;
        synchronized (validation$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    public <A> EitherT<IndexedStateT, String, A> ok(A x) {
        return EitherT.PurePartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.pure(), x, (Applicative)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
    }

    public EitherT<IndexedStateT, String, ShapesMap> getShapesMap() {
        return EitherT$.MODULE$.liftF((Object)package.StateT$.MODULE$.get((Applicative)IO$.MODULE$.asyncForIO()), (Functor)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
    }

    public EitherT<IndexedStateT, String, BoxedUnit> updateShapesMap(Function1<ShapesMap, ShapesMap> fn) {
        return EitherT$.MODULE$.liftF((Object)package.StateT$.MODULE$.modify(fn, (Applicative)IO$.MODULE$.asyncForIO()), (Functor)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
    }

    public <A> EitherT<IndexedStateT, String, A> fromEither(Either<String, A> e) {
        return EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), e, (Applicative)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
    }

    public <A> EitherT<IndexedStateT, String, A> fromIO(IO<A> io) {
        return EitherT$.MODULE$.liftF((Object)package.StateT$.MODULE$.liftF(io, (Applicative)IO$.MODULE$.asyncForIO()), (Functor)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
    }

    public <A> EitherT<IndexedStateT, String, List<A>> fromStreamIO(Stream<IO, A> io) {
        return this.fromIO((IO)io.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).toList());
    }

    public IO<Either<String, ShapesMap>> runValidation(RDFNode node, SLang shape, RDFReader rdf, SchemaS schema) {
        return ((IO)((IndexedStateT)this.validate(node, shape, rdf, schema).value()).run((Object)ShapesMap$.MODULE$.empty(), (FlatMap)IO$.MODULE$.asyncForIO())).map((Function1 & Serializable)pair -> {
            Tuple2 tuple2 = pair;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ShapesMap sm = (ShapesMap)tuple2._1();
            Either v = (Either)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)sm, (Object)v);
            Tuple2 tuple23 = tuple22;
            ShapesMap sm2 = (ShapesMap)tuple23._1();
            Either v2 = (Either)tuple23._2();
            return (Either)v2.fold((Function1 & Serializable)x$2 -> package$.MODULE$.Left().apply(x$2), (Function1 & Serializable)x$3 -> package$.MODULE$.Right().apply((Object)sm2));
        });
    }

    public EitherT<IndexedStateT, String, Val> validate(RDFNode node, SLang shape, RDFReader rdf, SchemaS schema) {
        EitherT eitherT;
        SLang sLang = shape;
        if (STrue$.MODULE$.equals(sLang)) {
            eitherT = this.cond(true, node, shape);
        } else if (sLang instanceof And) {
            And and = (And)sLang;
            SLang s1 = and.s1();
            SLang s2 = and.s2();
            eitherT = this.validate(node, s1, rdf, schema).flatMap((Function1 & Serializable)v1 -> MODULE$.validate(node, s2, rdf, schema).flatMap((Function1 & Serializable)v2 -> MODULE$.cond(v1.isConforming() && v2.isConforming(), node, shape).map((Function1 & Serializable)r -> r, (Functor)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO())), (Monad)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO())), (Monad)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
        } else if (BNodeKind$.MODULE$.equals(sLang)) {
            eitherT = this.cond(node.isBNode(), node, shape);
        } else if (IRIKind$.MODULE$.equals(sLang)) {
            eitherT = this.cond(node.isIRI(), node, shape);
        } else if (sLang instanceof Datatype) {
            Datatype datatype = (Datatype)sLang;
            IRI iri = datatype.iri();
            eitherT = this.cond(this.hasDatatype(node, iri), node, shape);
        } else if (sLang instanceof Not) {
            Not not = (Not)sLang;
            SLang s = not.s();
            eitherT = this.validate(node, s, rdf, schema).flatMap((Function1 & Serializable)v -> MODULE$.cond(!v.isConforming(), node, shape).map((Function1 & Serializable)r -> r, (Functor)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO())), (Monad)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
        } else if (sLang instanceof Ref) {
            Ref ref = (Ref)sLang;
            Label lbl = ref.ref();
            Option<SLang> option = schema.getLabel(lbl);
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new Exception(new StringBuilder(26).append("Label ").append(lbl).append(" not found in Schema").toString());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            SLang s = (SLang)some.value();
            EitherT eitherT2 = this.validate(node, s, rdf, schema).flatMap((Function1 & Serializable)v -> MODULE$.cond(v.isConforming(), node, shape).map((Function1 & Serializable)r -> r, (Functor)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO())), (Monad)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
            eitherT = eitherT2;
        } else if (sLang instanceof QualifiedArc) {
            BoxedUnit boxedUnit;
            QualifiedArc qualifiedArc = (QualifiedArc)sLang;
            PropPath pp = qualifiedArc.pp();
            SLang shape2 = qualifiedArc.s();
            Card card = qualifiedArc.card();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("QualifiedArc({},{},{})?", new Object[]{pp, shape2, card});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            eitherT = this.fromStreamIO(rdf.triplesWithSubject(node)).map((Function1 & Serializable)neighbourhood -> {
                Set set;
                PropPath propPath = pp;
                if (propPath instanceof Pred) {
                    Pred pred = (Pred)propPath;
                    IRI p = pred.p();
                    set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IRI[]{p}));
                } else if (propPath instanceof NoPreds) {
                    NoPreds noPreds = (NoPreds)propPath;
                    Set<IRI> ps = noPreds.preds();
                    set = (Set)neighbourhood.map((Function1 & Serializable)x$4 -> x$4.pred()).toSet().diff(ps);
                } else {
                    throw new MatchError((Object)propPath);
                }
                Set predicates = set;
                return new Tuple2(neighbourhood, (Object)predicates);
            }, (Functor)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)x$5 -> {
                Tuple2 tuple2 = x$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List neighbourhood = (List)tuple2._1();
                Set predicates = (Set)tuple2._2();
                EitherT eitherT = MODULE$.countArcsWithShape((Set<IRI>)predicates, (Set<RDFTriple>)neighbourhood.toSet(), shape2, rdf, schema).flatMap((Function1 & Serializable)count -> Validation$.$anonfun$validate$11(card, node, shape2, BoxesRunTime.unboxToInt((Object)count)), (Monad)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
                return eitherT;
            }, (Monad)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
        } else {
            throw new MatchError((Object)sLang);
        }
        return eitherT;
    }

    private EitherT<IndexedStateT, String, Val> cond(boolean cond, RDFNode node, SLang shape) {
        return cond ? this.updateShapesMap((Function1<ShapesMap, ShapesMap>)(Function1 & Serializable)x$6 -> x$6.conform(node, shape)).map((Function1 & Serializable)x$7 -> {
            BoxedUnit boxedUnit = x$7;
            Conforms$ conforms$ = Conforms$.MODULE$;
            return conforms$;
        }, (Functor)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO())) : this.updateShapesMap((Function1<ShapesMap, ShapesMap>)(Function1 & Serializable)x$8 -> x$8.notConform(node, shape)).map((Function1 & Serializable)x$9 -> {
            BoxedUnit boxedUnit = x$9;
            NotConforms$ notConforms$ = NotConforms$.MODULE$;
            return notConforms$;
        }, (Functor)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
    }

    private boolean hasDatatype(RDFNode node, IRI dt) {
        boolean bl;
        RDFNode rDFNode = node;
        if (rDFNode instanceof Literal) {
            Literal literal = (Literal)rDFNode;
            IRI iRI = literal.dataType();
            IRI iRI2 = dt;
            bl = !(iRI != null ? !iRI.equals(iRI2) : iRI2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    private EitherT<IndexedStateT, String, Object> countArcsWithShape(Set<IRI> predicates, Set<RDFTriple> triples, SLang shape, RDFReader rdf, SchemaS schema) {
        List values = ((IterableOnceOps)((IterableOps)triples.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)predicates.contains((Object)t.pred())))).map((Function1 & Serializable)x$10 -> x$10.obj())).toList();
        return ((EitherT)implicits$.MODULE$.toTraverseOps((Object)values.map((Function1 & Serializable)v -> MODULE$.validate((RDFNode)v, shape, rdf, schema)), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)EitherT$.MODULE$.catsDataMonadErrorForEitherT((Monad)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO())))).map((Function1 & Serializable)ls -> BoxesRunTime.boxToInteger((int)Validation$.MODULE$.countConforming((List<Val>)ls)), (Functor)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
    }

    private int countConforming(List<Val> ls) {
        return ls.filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.isConforming())).length();
    }

    public static final /* synthetic */ EitherT $anonfun$validate$11(Card card$1, RDFNode node$1, SLang shape$2, int count) {
        return MODULE$.cond(card$1.satisfies(count), node$1, shape$2).map((Function1 & Serializable)r -> r, (Functor)IndexedStateT$.MODULE$.catsDataMonadErrorForIndexedStateT((MonadError)IO$.MODULE$.asyncForIO()));
    }

    private Validation$() {
    }
}

