/*
 * Decompiled with CFR 0.152.
 */
package es.weso.utils;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.implicits$;
import cats.syntax.EitherIdOps$;
import es.weso.utils.FileUtils;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.file.Files;
import fs2.io.file.Files$;
import fs2.text$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class FileUtils$ {
    public static final FileUtils$ MODULE$ = new FileUtils$();
    private static String currentFolderURL;
    private static volatile boolean bitmap$0;

    public IO<List<File>> getFilesFromFolderWithExt(String path, String ext, List<String> ignoreFiles) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            File d = new File(path);
            return d.exists() && d.isDirectory() ? Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])d.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)FileUtils$.$anonfun$getFilesFromFolderWithExt$2(ext, ignoreFiles, file)))).toList() : (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        });
    }

    public IO<File> getFileFromFolderWithSameExt(File file, String oldExt, String newExt) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            String newName = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(file.getAbsolutePath())).replaceFirst(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(oldExt)), StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(newExt)))));
            return new File(newName);
        });
    }

    public IO<File> getFileFromFolderWithExt(String path, String name, String ext) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> new File(new StringBuilder(2).append(path).append("/").append(name).append(".").append(ext).toString()));
    }

    public Tuple2<String, String> splitExtension(String str) {
        String[] splits = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(str), '.');
        return new Tuple2((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.init$extension(Predef$.MODULE$.refArrayOps((Object[])splits))).mkString("."), ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])splits)));
    }

    public IO<String> getContents(Path path) {
        Function1 decoder = text$.MODULE$.utf8Decode();
        return ((IO)Files$.MODULE$.apply(Files$.MODULE$.forAsync(IO$.MODULE$.asyncForIO())).readAll(path, 4096).through(decoder).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).string((.less.colon.less)$less$colon$less$.MODULE$.refl())).handleErrorWith((Function1 & Serializable)e -> IO$.MODULE$.raiseError((Throwable)new FileUtils.GetContentsException(path)));
    }

    public Either<String, InputStreamReader> getStream(String fileName) {
        Either either;
        try {
            BufferedSource source = Source$.MODULE$.fromFile(fileName, Codec$.MODULE$.string2codec("UTF-8"));
            either = EitherIdOps$.MODULE$.asRight$extension(implicits$.MODULE$.catsSyntaxEitherId((Object)source.reader()));
        }
        catch (FileNotFoundException e) {
            either = package$.MODULE$.Left().apply((Object)new StringBuilder(21).append("Error reading file ").append(fileName).append(": ").append(e.getMessage()).toString());
        }
        catch (IOException e) {
            either = package$.MODULE$.Left().apply((Object)new StringBuilder(28).append("IO Exception reading file ").append(fileName).append(": ").append(e.getMessage()).toString());
        }
        catch (Exception e) {
            either = package$.MODULE$.Left().apply((Object)new StringBuilder(25).append("Exception reading file ").append(fileName).append(": ").append(e.getMessage()).toString());
        }
        return either;
    }

    public IO<BoxedUnit> writeFile(String name, String contents) {
        Path path = Paths.get(name, new String[0]);
        Stream qual$1 = Stream.PureOps$.MODULE$.covary$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.emits((Seq)Predef$.MODULE$.wrapString(contents))));
        int x$1 = 4096;
        boolean x$22 = qual$1.chunkN$default$2();
        Files qual$2 = Files$.MODULE$.apply(Files$.MODULE$.forAsync(IO$.MODULE$.asyncForIO()));
        Path x$3 = path;
        scala.collection.immutable.Seq x$4 = qual$2.writeAll$default$2();
        return (IO)qual$1.chunkN(4096, x$22).map((Function1 & Serializable)x$2 -> x$2.toVector().mkString()).through(text$.MODULE$.utf8Encode()).through(qual$2.writeAll(x$3, x$4)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
    }

    public String formatLines(CharSequence cs) {
        return StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(((Object)cs).toString())).zipWithIndex().map((Function1 & Serializable)p -> new StringBuilder(1).append(Integer.toString(p._2$mcI$sp() + 1)).append(" ").append(p._1()).toString()).mkString("\n");
    }

    private String currentFolderURL$lzycompute() {
        FileUtils$ fileUtils$ = this;
        synchronized (fileUtils$) {
            if (!bitmap$0) {
                currentFolderURL = Paths.get(".", new String[0]).normalize().toUri().toURL().toExternalForm();
                bitmap$0 = true;
            }
        }
        return currentFolderURL;
    }

    public String currentFolderURL() {
        return !bitmap$0 ? this.currentFolderURL$lzycompute() : currentFolderURL;
    }

    public static final /* synthetic */ boolean $anonfun$getFilesFromFolderWithExt$2(String ext$1, List ignoreFiles$1, File file) {
        boolean bl;
        if (file.isFile()) {
            String extension;
            Tuple2<String, String> tuple2 = MODULE$.splitExtension(file.getName());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            String extension2 = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)name, (Object)extension2);
            Tuple2 tuple23 = tuple22;
            String name2 = (String)tuple23._1();
            String string = extension = (String)tuple23._2();
            String string2 = ext$1;
            bl = !(string != null ? !string.equals(string2) : string2 != null) && !ignoreFiles$1.contains((Object)name2);
        } else {
            bl = false;
        }
        return bl;
    }

    private FileUtils$() {
    }
}

