/*
 * Decompiled with CFR 0.152.
 */
package es.weso.utils.json;

import io.circe.Json;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class JsonCompare$ {
    public static final JsonCompare$ MODULE$ = new JsonCompare$();
    private static final String OK = "";

    public String diffBasic(Json json1, Json json2) {
        return this.diffBasic(json1, json2, 0);
    }

    private String OK() {
        return OK;
    }

    private String diffBasic(Json json1, Json json2, int indent) {
        return (String)json1.fold((Function0 & Serializable)() -> MODULE$.checkNull(indent, json2), (Function1 & Serializable)v -> JsonCompare$.MODULE$.checkBool(indent, json2, BoxesRunTime.unboxToBoolean((Object)v)), (Function1 & Serializable)v -> MODULE$.checkNumber(indent, json2, (JsonNumber)v), (Function1 & Serializable)v -> MODULE$.checkString(indent, json2, (String)v), (Function1 & Serializable)v -> MODULE$.checkArray(indent, json2, (Vector<Json>)v), (Function1 & Serializable)v -> MODULE$.checkObject(indent, json2, (JsonObject)v));
    }

    private String checkNull(int indent, Json json) {
        return json.isNull() ? this.OK() : this.mkIndent(indent, new StringBuilder(20).append("json ").append(json).append(" should be null").toString());
    }

    private String checkBool(int indent, Json json, boolean v) {
        return json.isBoolean() ? (BoxesRunTime.unboxToBoolean((Object)json.asBoolean().get()) == v ? this.OK() : this.mkIndent(indent, new StringBuilder(28).append("json ").append(json).append(" should be the boolean ").append(v).toString())) : this.mkIndent(indent, new StringBuilder(21).append("json ").append(json).append(" should be bool ").append(v).toString());
    }

    private String checkNumber(int indent, Json json, JsonNumber v) {
        String string;
        if (json.isNumber()) {
            Object object = json.asNumber().get();
            JsonNumber jsonNumber = v;
            string = !(object != null ? !object.equals(jsonNumber) : jsonNumber != null) ? this.OK() : this.mkIndent(indent, new StringBuilder(23).append("json ").append(json).append(" should be number ").append(v).toString());
        } else {
            string = this.mkIndent(indent, new StringBuilder(40).append("json ").append(json).append(" should be a numer to compare with ").append(v).toString());
        }
        return string;
    }

    private String checkString(int indent, Json json, String v) {
        String string;
        if (json.isString()) {
            String str;
            String string2 = str = (String)json.asString().get();
            String string3 = v;
            string = !(string2 != null ? !string2.equals(string3) : string3 != null) ? this.OK() : this.mkIndent(indent, new StringBuilder(11).append(str).append(" should be ").append(v).toString());
        } else {
            string = this.mkIndent(indent, new StringBuilder(50).append("json ").append(json).append(" should be a string in order to compare with ").append(v).toString());
        }
        return string;
    }

    private String checkArray(int indent, Json json, Vector<Json> v) {
        String string;
        if (json.isArray()) {
            String d;
            Vector array = (Vector)json.asArray().get();
            String string2 = d = this.diffArrays(indent, (Vector<Json>)array, v);
            String string3 = this.OK();
            string = !(string2 != null ? !string2.equals(string3) : string3 != null) ? this.OK() : new StringBuilder(18).append("Arrays different: ").append(d).toString();
        } else {
            string = this.mkIndent(indent, new StringBuilder(22).append("json ").append(json).append(" should be array ").append(v).toString());
        }
        return string;
    }

    private String checkObject(int indent, Json json, JsonObject v) {
        String string;
        if (json.isObject()) {
            String d;
            JsonObject obj = (JsonObject)json.asObject().get();
            String string2 = d = this.diffObjects(indent + 1, obj, v);
            String string3 = this.OK();
            string = !(string2 != null ? !string2.equals(string3) : string3 != null) ? this.OK() : this.mkIndent(indent, new StringBuilder(20).append("Objects different...").append(d).toString());
        } else {
            string = this.mkIndent(indent, new StringBuilder(50).append("json ").append(json).append(" should be object to be able to compare with ").append(v).toString());
        }
        return string;
    }

    private String mkIndent(int indent, String msg) {
        return new StringBuilder(1).append("\n").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), indent)).append(msg).toString();
    }

    private String diffObjects(int indent, JsonObject o1, JsonObject o2) {
        String zero = "";
        Option<Tuple2<Set<String>, Set<String>>> fieldsDifferent = this.diffFields(o1, o2);
        return fieldsDifferent.isEmpty() ? (String)o2.toMap().foldRight((Object)zero, JsonCompare$.cont$1(o1, indent)) : this.mkIndent(indent, new StringBuilder(18).append("Fields different: ").append(fieldsDifferent.get()).toString());
    }

    private Option<Tuple2<Set<String>, Set<String>>> diffFields(JsonObject o1, JsonObject o2) {
        Set fields1minus2 = (Set)o1.keys().toSet().$minus$minus((IterableOnce)o2.keys().toSet());
        Set fields2minus1 = (Set)o2.keys().toSet().$minus$minus((IterableOnce)o1.keys().toSet());
        return fields1minus2.isEmpty() && fields2minus1.isEmpty() ? None$.MODULE$ : new Some((Object)new Tuple2((Object)fields1minus2, (Object)fields2minus1));
    }

    private String diffArrays(int indent, Vector<Json> o1, Vector<Json> o2) {
        String string;
        if (o1.length() == o2.length()) {
            String zero = "";
            string = (String)((List)((StrictOptimizedIterableOps)o1.toList().zip((IterableOnce)o2.toList())).zip((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), o1.length()))).foldRight((Object)zero, JsonCompare$.cont$2(indent));
        } else {
            string = this.mkIndent(indent, new StringBuilder(33).append("Arrays have different lengths: ").append(o1.length()).append("!=").append(o2.length()).toString());
        }
        return string;
    }

    private static final Function2 cont$1(JsonObject o1$1, int indent$2) {
        return (Function2 & Serializable)(pair, rest) -> {
            String string;
            Tuple2 tuple2 = pair;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String field = (String)tuple2._1();
            Json value = (Json)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)field, (Object)value);
            Tuple2 tuple23 = tuple22;
            String field2 = (String)tuple23._1();
            Json value2 = (Json)tuple23._2();
            Option option = o1$1.apply(field2);
            if (None$.MODULE$.equals(option)) {
                string = MODULE$.mkIndent(indent$2, new StringBuilder(0).append(new StringBuilder(40).append("obj1 ").append(o1$1).append(" doesn't contain field ").append(field2).append(" with value ").append(value2).toString()).append((String)rest).toString());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Json v = (Json)some.value();
                string = new StringBuilder(0).append(MODULE$.diffBasic(value2, v, indent$2)).append((String)rest).toString();
            } else {
                throw new MatchError((Object)option);
            }
            return string;
        };
    }

    private static final Function2 cont$2(int indent$3) {
        return (Function2 & Serializable)(t, rest) -> {
            String d;
            int n;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = t;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    n = tuple22._2$mcI$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Json v1 = (Json)tuple2._1();
            Json v2 = (Json)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)v1, (Object)v2, (Object)BoxesRunTime.boxToInteger((int)n));
            Tuple3 tuple32 = tuple3;
            Json v12 = (Json)tuple32._1();
            Json v22 = (Json)tuple32._2();
            int n2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
            String string = d = MODULE$.diffBasic(v12, v22, indent$3 + 1);
            String string2 = "";
            return !(string != null ? !string.equals(string2) : string2 != null) ? rest : MODULE$.mkIndent(indent$3, new StringBuilder(22).append("Array diff at index ").append(n2).append(": ").append(d).append((String)rest).toString());
        };
    }

    private JsonCompare$() {
    }
}

