/*
 * Decompiled with CFR 0.152.
 */
package es.weso.wdsub.fs2processor;

import cats.Applicative;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Sync;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import es.weso.wbmodel.EntityDoc;
import es.weso.wbmodel.EntityDoc$;
import es.weso.wdsub.DumpOptions;
import es.weso.wdsub.DumpOptions$;
import es.weso.wdsub.DumpResults;
import es.weso.wdsub.fs2processor.CloseBracket$;
import es.weso.wdsub.fs2processor.EndStream$;
import es.weso.wdsub.fs2processor.Error;
import es.weso.wdsub.fs2processor.OpenBracket$;
import es.weso.wdsub.fs2processor.ParsedEntity;
import es.weso.wdsub.fs2processor.ParsedLine;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.compat.NotGiven$;
import fs2.compression.Compression;
import fs2.compression.Compression$;
import fs2.io.package$;
import fs2.text;
import fs2.text$;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class IODumpProcessor$ {
    public static IODumpProcessor$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new IODumpProcessor$();
    }

    private Logger logger$lzycompute() {
        IODumpProcessor$ iODumpProcessor$ = this;
        synchronized (iODumpProcessor$) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)this.getClass().getCanonicalName());
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public IO<DumpResults> process(InputStream is, Option<OutputStream> os, IO<String> start, Function1<EntityDoc, IO<Option<String>>> withEntity, String sep, IO<String> end, Ref<IO, DumpResults> refResults, DumpOptions opts) {
        Stream x = package$.MODULE$.readInputStream(ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)is), (Applicative)IO$.MODULE$.asyncForIO()), opts.chunkSize(), package$.MODULE$.readInputStream$default$3(), (Sync)IO$.MODULE$.asyncForIO()).through(this.when(opts.decompressInput(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.decompress())).through(text.utf8$.MODULE$.decode()).through(text$.MODULE$.lines()).zipWithIndex().parEvalMap(opts.maxConcurrent(), (Function1 & Serializable & scala.Serializable)pair -> MODULE$.processLine(start, withEntity, sep, end, opts, (Tuple2<String, Object>)pair), (GenConcurrent)IO$.MODULE$.asyncForIO()).through(text.utf8$.MODULE$.encode()).through(this.when(opts.compressOutput() && os.isDefined(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.compress())).through(this.when(os.isDefined(), (Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.writeOutputStream(ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId(os.get()), (Applicative)IO$.MODULE$.asyncForIO()), package$.MODULE$.writeOutputStream$default$2(), (Sync)IO$.MODULE$.asyncForIO())));
        return ((IO)x.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain()).flatMap((Function1 & Serializable & scala.Serializable)_ -> ((IO)refResults.get()).map((Function1 & Serializable & scala.Serializable)results -> results));
    }

    public DumpOptions process$default$8() {
        return DumpOptions$.MODULE$.default();
    }

    public IO<String> processLine(IO<String> start, Function1<EntityDoc, IO<Option<String>>> withEntity, String sep, IO<String> end, DumpOptions opts, Tuple2<String, Object> pair) {
        Tuple2<String, Object> tuple2 = pair;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String line = (String)tuple2._1();
        long index = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)line, (Object)BoxesRunTime.boxToLong((long)index));
        String line2 = (String)tuple22._1();
        long index2 = tuple22._2$mcJ$sp();
        return this.parseLine(line2, opts).flatMap((Function1 & Serializable & scala.Serializable)parsedLine -> MODULE$.processParsedLine(withEntity, (ParsedLine)parsedLine, index2, start, sep, end).map((Function1 & Serializable & scala.Serializable)result -> result));
    }

    private Function1<Stream<IO, Object>, Stream<IO, Object>> decompress() {
        return (Function1 & Serializable & scala.Serializable)s -> {
            Compression qual$1 = Compression$.MODULE$.apply(Compression$.MODULE$.forSync((Sync)IO$.MODULE$.asyncForIO()));
            int x$1 = qual$1.gunzip$default$1();
            return s.through(qual$1.gunzip(x$1)).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.content(), NotGiven$.MODULE$.default());
        };
    }

    private Function1<Stream<IO, Object>, Stream<IO, Object>> compress() {
        return (Function1 & Serializable & scala.Serializable)s -> {
            Compression qual$1 = Compression$.MODULE$.apply(Compression$.MODULE$.forSync((Sync)IO$.MODULE$.asyncForIO()));
            int x$1 = qual$1.gzip$default$1();
            Option x$2 = qual$1.gzip$default$2();
            Option x$3 = qual$1.gzip$default$3();
            Option x$4 = qual$1.gzip$default$4();
            Option x$5 = qual$1.gzip$default$5();
            Option x$6 = qual$1.gzip$default$6();
            return s.through(qual$1.gzip(x$1, x$2, x$3, x$4, x$5, x$6));
        };
    }

    private <A> Function1<Stream<IO, A>, Stream<IO, A>> when(boolean cond, Function0<Function1<Stream<IO, A>, Stream<IO, A>>> action) {
        return (Function1 & Serializable & scala.Serializable)s -> {
            if (cond) {
                return s.through((Function1)action.apply());
            }
            return s;
        };
    }

    private IO<String> processParsedLine(Function1<EntityDoc, IO<Option<String>>> withEntity, ParsedLine parsedLine, long lineNumber, IO<String> start, String sep, IO<String> end) {
        ParsedLine parsedLine2 = parsedLine;
        if (OpenBracket$.MODULE$.equals(parsedLine2)) {
            return start;
        }
        if (CloseBracket$.MODULE$.equals(parsedLine2)) {
            return end;
        }
        if (parsedLine2 instanceof ParsedEntity) {
            ParsedEntity parsedEntity = (ParsedEntity)parsedLine2;
            EntityDoc e = parsedEntity.entity();
            return ((IO)withEntity.apply((Object)e)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.map((Function1 & Serializable & scala.Serializable)x$4 -> new StringBuilder(0).append((String)x$4).append(sep).toString())).map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        }
        if (parsedLine2 instanceof Error) {
            Error error = (Error)parsedLine2;
            String e = error.str();
            return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.println((Object)new StringBuilder(16).append("Error at line ").append(lineNumber).append(": ").append(e).toString())).$greater$greater((Function0 & Serializable & scala.Serializable)() -> (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)""), (Applicative)IO$.MODULE$.asyncForIO()));
        }
        if (EndStream$.MODULE$.equals(parsedLine2)) {
            return (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)""), (Applicative)IO$.MODULE$.asyncForIO());
        }
        throw new MatchError((Object)parsedLine2);
    }

    private IO<ParsedLine> parseLine(String line, DumpOptions opts) {
        String string = line.trim();
        return ("[".equals(string) ? (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)OpenBracket$.MODULE$), (Applicative)IO$.MODULE$.asyncForIO()) : ("]".equals(string) ? (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)CloseBracket$.MODULE$), (Applicative)IO$.MODULE$.asyncForIO()) : EntityDoc$.MODULE$.fromJsonStr(string, opts.jsonDeserializer()).map((Function1 & Serializable & scala.Serializable)e -> new ParsedEntity((EntityDoc)e)))).handleErrorWith((Function1 & Serializable & scala.Serializable)e -> {
            Throwable throwable = e;
            if (throwable instanceof MismatchedInputException) {
                return (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)EndStream$.MODULE$), (Applicative)IO$.MODULE$.asyncForIO());
            }
            return (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)new Error(e.getMessage())), (Applicative)IO$.MODULE$.asyncForIO());
        });
    }

    private IODumpProcessor$() {
        MODULE$ = this;
    }
}

