/*
 * Decompiled with CFR 0.152.
 */
package es.weso.wdsub.wdtk;

import cats.Applicative;
import cats.Functor;
import cats.Invariant;
import cats.Semigroupal;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.package$;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import es.weso.wdsub.DumpOptions;
import es.weso.wdsub.DumpResults;
import es.weso.wdsub.LogConfig$;
import es.weso.wdsub.wdtk.ShExProcessor;
import es.weso.wdsub.wdtk.WDTKProcessor;
import es.weso.wdsub.writer.DumpWriter;
import es.weso.wdsub.writer.DumpWriter$;
import es.weso.wshex.WSchema;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentProcessor;
import org.wikidata.wdtk.dumpfiles.DumpProcessingController;
import org.wikidata.wdtk.dumpfiles.MwDumpFile;
import org.wikidata.wdtk.dumpfiles.MwLocalDumpFile;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class DumpProcessor$ {
    public static DumpProcessor$ MODULE$;
    private DumpProcessingController dumpProcessingController;
    private Logger logger;
    private volatile byte bitmap$0;

    static {
        new DumpProcessor$();
    }

    private DumpProcessingController dumpProcessingController$lzycompute() {
        DumpProcessor$ dumpProcessor$ = this;
        synchronized (dumpProcessor$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dumpProcessingController = new DumpProcessingController("wdsubDump");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.dumpProcessingController;
    }

    private DumpProcessingController dumpProcessingController() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.dumpProcessingController$lzycompute();
        }
        return this.dumpProcessingController;
    }

    private Logger logger$lzycompute() {
        DumpProcessor$ dumpProcessor$ = this;
        synchronized (dumpProcessor$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LoggerFactory.getLogger((String)this.getClass().getCanonicalName());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    private Logger logger() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private IO<BoxedUnit> info(String msg) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.logger().info(msg));
    }

    private IO<ShExProcessor> acquireShExProcessor(WSchema wshex, Option<Path> outputPath, DumpOptions opts) {
        return (opts.showSchema() ? IO$.MODULE$.println((Object)new StringBuilder(8).append("Schema: ").append(wshex).toString(), implicits$.MODULE$.catsStdShowForString()) : IO$.MODULE$.unit()).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.acquireOutput(outputPath).map((Function1 & Serializable & scala.Serializable)maybeOut -> {
            WDTKProcessor shexProcessor = new WDTKProcessor(wshex, (Option<DumpWriter>)maybeOut.map((Function1 & Serializable & scala.Serializable)x$1 -> DumpWriter$.MODULE$.fromOutputStream((OutputStream)x$1, opts.dumpFormat())), opts);
            shexProcessor.open();
            return new ShExProcessor(shexProcessor, shexProcessor);
        }));
    }

    private Resource<IO, ShExProcessor> mkShExProcessor(WSchema schema, Option<Path> outputPath, DumpOptions opts) {
        return package$.MODULE$.Resource().make(this.acquireShExProcessor(schema, outputPath, opts), (Function1 & Serializable & scala.Serializable)shExProcessor -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (opts.verbose()) {
                Predef$.MODULE$.println((Object)"End of process...");
            }
            shExProcessor.entityDocumentDumpProcessor().close();
        }), (Functor)IO$.MODULE$.asyncForIO());
    }

    private IO<MwLocalDumpFile> acquireMwLocalDumpFile(Path file, boolean verbose) {
        String fileName = file.toFile().getAbsolutePath();
        return this.info(new StringBuilder(6).append("File: ").append(fileName).toString()).$times$greater(IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new MwLocalDumpFile(fileName)));
    }

    private Resource<IO, MwLocalDumpFile> mkDumpFile(Path file, boolean verbose) {
        return package$.MODULE$.Resource().make(this.acquireMwLocalDumpFile(file, verbose), (Function1 & Serializable & scala.Serializable)mwFile -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> mwFile.getDumpFileStream().close()), (Functor)IO$.MODULE$.asyncForIO());
    }

    private IO<Option<OutputStream>> acquireOutput(Option<Path> maybeOutputPath) {
        Option<Path> option = maybeOutputPath;
        if (option instanceof Some) {
            Some some = (Some)option;
            Path outputPath = (Path)some.value();
            return IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                OutputStream fileStream = Files.newOutputStream(outputPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                BufferedOutputStream bufferedStream = new BufferedOutputStream(fileStream, 0xA00000);
                GzipParameters gzipParams = new GzipParameters();
                gzipParams.setCompressionLevel(1);
                GzipCompressorOutputStream outputStream = new GzipCompressorOutputStream((OutputStream)bufferedStream, gzipParams);
                return new Some((Object)outputStream);
            });
        }
        if (None$.MODULE$.equals(option)) {
            return (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)implicits$.MODULE$.none()), (Applicative)IO$.MODULE$.asyncForIO());
        }
        throw new MatchError(option);
    }

    private IO<BoxedUnit> releaseOutput(Option<OutputStream> maybeOut) {
        Option<OutputStream> option = maybeOut;
        if (option instanceof Some) {
            Some some = (Some)option;
            OutputStream out = (OutputStream)some.value();
            return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.close());
        }
        if (None$.MODULE$.equals(option)) {
            return (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)BoxedUnit.UNIT), (Applicative)IO$.MODULE$.asyncForIO());
        }
        throw new MatchError(option);
    }

    private Resource<IO, Option<OutputStream>> mkOutput(Option<Path> maybeOutput) {
        return package$.MODULE$.Resource().make(this.acquireOutput(maybeOutput), (Function1 & Serializable & scala.Serializable)maybeOut -> MODULE$.releaseOutput((Option<OutputStream>)maybeOut), (Functor)IO$.MODULE$.asyncForIO());
    }

    public IO<DumpResults> dumpProcess(Path filePath, Option<Path> outPath, WSchema schema, DumpOptions opts) {
        return ((IO)((Resource)implicits$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(this.mkShExProcessor(schema, outPath, opts), this.mkDumpFile(filePath, opts.verbose()))).tupled((Invariant)Resource$.MODULE$.catsEffectAsyncForResource(IO$.MODULE$.asyncForIO()), (Semigroupal)Resource$.MODULE$.catsEffectAsyncForResource(IO$.MODULE$.asyncForIO()))).use((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ShExProcessor processor = (ShExProcessor)tuple2._1();
                MwLocalDumpFile mwDumpFile = (MwLocalDumpFile)tuple2._2();
                return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> LogConfig$.MODULE$.configureLogging()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.dumpProcessingController().registerEntityDocumentProcessor((EntityDocumentProcessor)processor.entityDocumentDumpProcessor(), null, true)).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.info(new StringBuilder(23).append("Processing local dump: ").append(filePath).toString()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.info(new StringBuilder(11).append("DateStamp: ").append(mwDumpFile.getDateStamp()).toString()).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.info(new StringBuilder(12).append("Available?: ").append(mwDumpFile.isAvailable()).toString()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.dumpProcessingController().processDump((MwDumpFile)mwDumpFile)).map((Function1 & Serializable & scala.Serializable)_ -> new DumpResults(processor.entityCounter().getTotalEntities(), processor.entityCounter().getMatchedEntities())))))));
            }
            throw new MatchError((Object)tuple2);
        }, (MonadCancel)IO$.MODULE$.asyncForIO())).map((Function1 & Serializable & scala.Serializable)results -> results);
    }

    private DumpProcessor$() {
        MODULE$ = this;
    }
}

