/*
 * Decompiled with CFR 0.152.
 */
package es.weso.wdsubmain;

import buildinfo.BuildInfo$;
import cats.Applicative;
import cats.Functor;
import cats.Semigroupal;
import cats.data.Validated;
import cats.data.Validated$;
import cats.effect.ExitCode;
import cats.effect.ExitCode$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.package$;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import com.monovore.decline.Argument$;
import com.monovore.decline.Opts;
import com.monovore.decline.Opts$;
import com.monovore.decline.effect.CommandIOApp;
import com.monovore.decline.effect.CommandIOApp$;
import es.weso.wdsub.DumpProcessor$;
import es.weso.wdsub.DumpResults;
import es.weso.wdsub.DumpResults$;
import es.weso.wdsub.IODumpProcessor$;
import es.weso.wdsubmain.CountEntities$;
import es.weso.wdsubmain.Dump;
import es.weso.wdsubmain.Dump$;
import es.weso.wdsubmain.DumpAction;
import es.weso.wdsubmain.FilterBySchema;
import es.weso.wdsubmain.Fs2$;
import es.weso.wdsubmain.ProcessEntity;
import es.weso.wdsubmain.ProcessEntity$;
import es.weso.wdsubmain.Processor;
import es.weso.wdsubmain.ShowEntities;
import es.weso.wdsubmain.WDTK$;
import es.weso.wikibase.Entity;
import es.weso.wikibase.EntityFetcher$;
import es.weso.wikibase.ShowEntityOptions$;
import es.weso.wshex.Matcher;
import es.weso.wshex.Matcher$;
import es.weso.wshex.WShEx$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Main$
extends CommandIOApp {
    public static Main$ MODULE$;
    private String DUMP_FILE;
    private final Opts<ProcessEntity> processEntity;
    private final Opts<Path> filePath;
    private final List<Product> processors;
    private final List<String> processorNames;
    private final Product defaultProcessor;
    private final Opts<Option<Object>> maxStatements;
    private final Opts<Product> processor;
    private final Opts<Path> schemaPath;
    private final Opts<Option<Path>> outPath;
    private final Opts<Object> verbose;
    private final Opts<CountEntities$> countEntities;
    private final Opts<BoxedUnit> showEntities;
    private final Opts<ShowEntities> showEntitiesMax;
    private final Opts<FilterBySchema> filterBySchema;
    private final Opts<DumpAction> action;
    private final Opts<Dump> dump;
    private volatile boolean bitmap$0;

    static {
        new Main$();
    }

    private String DUMP_FILE$lzycompute() {
        Main$ main$ = this;
        synchronized (main$) {
            if (!this.bitmap$0) {
                this.DUMP_FILE = "modules/wdsub/src/resources/sample-dump-20150815.json.gz";
                this.bitmap$0 = true;
            }
        }
        return this.DUMP_FILE;
    }

    public String DUMP_FILE() {
        return !this.bitmap$0 ? this.DUMP_FILE$lzycompute() : this.DUMP_FILE;
    }

    public Opts<ProcessEntity> processEntity() {
        return this.processEntity;
    }

    public Opts<Path> filePath() {
        return this.filePath;
    }

    public List<Product> processors() {
        return this.processors;
    }

    public List<String> processorNames() {
        return this.processorNames;
    }

    public Product defaultProcessor() {
        return this.defaultProcessor;
    }

    public Opts<Option<Object>> maxStatements() {
        return this.maxStatements;
    }

    public Opts<Product> processor() {
        return this.processor;
    }

    public Opts<Path> schemaPath() {
        return this.schemaPath;
    }

    public Opts<Option<Path>> outPath() {
        return this.outPath;
    }

    public Opts<Object> verbose() {
        return this.verbose;
    }

    public Opts<CountEntities$> countEntities() {
        return this.countEntities;
    }

    public ShowEntities f(BoxedUnit x, Option<Object> maxStatements) {
        return new ShowEntities(maxStatements);
    }

    public Opts<BoxedUnit> showEntities() {
        return this.showEntities;
    }

    public Opts<ShowEntities> showEntitiesMax() {
        return this.showEntitiesMax;
    }

    public Opts<FilterBySchema> filterBySchema() {
        return this.filterBySchema;
    }

    public Opts<DumpAction> action() {
        return this.action;
    }

    public Opts<Dump> dump() {
        return this.dump;
    }

    public Opts<IO<ExitCode>> main() {
        return this.processEntity().orElse(this.dump()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            IO<ExitCode> iO;
            Object object = x0$1;
            if (object instanceof ProcessEntity) {
                ProcessEntity processEntity = (ProcessEntity)object;
                String entity = processEntity.entity();
                iO = MODULE$.processEntity(entity);
            } else if (object instanceof Dump) {
                Dump dump = (Dump)object;
                Path filePath = dump.filePath();
                DumpAction action = dump.action();
                Option<Path> outPath = dump.outPath();
                boolean verbose = dump.verbose();
                Processor processor = dump.processor();
                iO = MODULE$.dump(filePath, action, outPath, verbose, processor);
            } else {
                throw new MatchError(object);
            }
            return iO;
        });
    }

    public IO<ExitCode> processEntity(String entityStr) {
        return EntityFetcher$.MODULE$.fetchEntity(entityStr).flatMap((Function1 & Serializable & scala.Serializable)entity -> IO$.MODULE$.println((Object)new StringBuilder(8).append("entity: ").append(entityStr).toString(), implicits$.MODULE$.catsStdShowForString()).flatMap((Function1 & Serializable & scala.Serializable)_ -> IO$.MODULE$.println((Object)new StringBuilder(11).append("entity ID: ").append(entity.getID()).toString(), implicits$.MODULE$.catsStdShowForString()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> IO$.MODULE$.println((Object)new StringBuilder(13).append("entity Type: ").append(entity.getType()).toString(), implicits$.MODULE$.catsStdShowForString()).map((Function1 & Serializable & scala.Serializable)_ -> ExitCode$.MODULE$.Success()))));
    }

    public IO<ExitCode> dump(Path filePath, DumpAction action, Option<Path> maybeOutPath, boolean verbose, Processor processor) {
        return IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Files.newInputStream(filePath, new OpenOption[0])).flatMap((Function1 & Serializable & scala.Serializable)is -> {
            IO iO;
            Option option = maybeOutPath;
            if (option instanceof Some) {
                Some some = (Some)option;
                Path outPath = (Path)some.value();
                iO = (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)new Some((Object)Files.newOutputStream(outPath, StandardOpenOption.CREATE))), (Applicative)IO$.MODULE$.asyncForIO());
            } else if (None$.MODULE$.equals(option)) {
                iO = (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)implicits$.MODULE$.none()), (Applicative)IO$.MODULE$.asyncForIO());
            } else {
                throw new MatchError((Object)option);
            }
            return iO.flatMap((Function1 & Serializable & scala.Serializable)os -> ((IO)Ref.ApplyBuilders$.MODULE$.of$extension(package$.MODULE$.Ref().apply(Ref.Make$.MODULE$.concurrentInstance((GenConcurrent)IO$.MODULE$.asyncForIO())), (Object)DumpResults$.MODULE$.initial())).flatMap((Function1 & Serializable & scala.Serializable)refResults -> MODULE$.getWithEntry(action, (Ref<IO, DumpResults>)refResults).flatMap((Function1 & Serializable & scala.Serializable)withEntry -> {
                IO iO;
                Processor processor = processor;
                if (Fs2$.MODULE$.equals(processor)) {
                    iO = IODumpProcessor$.MODULE$.process(is, os, withEntry, refResults, IODumpProcessor$.MODULE$.process$default$5());
                } else if (WDTK$.MODULE$.equals(processor)) {
                    IO iO2;
                    DumpAction dumpAction = action;
                    if (dumpAction instanceof FilterBySchema) {
                        FilterBySchema filterBySchema = (FilterBySchema)dumpAction;
                        Path schemaPath = filterBySchema.schema();
                        iO2 = DumpProcessor$.MODULE$.dumpProcess(filePath, maybeOutPath, schemaPath, verbose, 0);
                    } else {
                        iO2 = IO$.MODULE$.println((Object)"Not implemented yet", implicits$.MODULE$.catsStdShowForString());
                    }
                    iO = iO2;
                } else {
                    throw new MatchError((Object)processor);
                }
                return iO.flatMap((Function1 & Serializable & scala.Serializable)results -> IO$.MODULE$.println((Object)new StringBuilder(24).append("End of dump processing: ").append(results).toString(), implicits$.MODULE$.catsStdShowForString()).map((Function1 & Serializable & scala.Serializable)_ -> ExitCode$.MODULE$.Success()));
            })));
        });
    }

    private IO<Function1<Entity, IO<Option<String>>>> getWithEntry(DumpAction action, Ref<IO, DumpResults> refResults) {
        IO iO;
        DumpAction dumpAction = action;
        if (dumpAction instanceof FilterBySchema) {
            FilterBySchema filterBySchema = (FilterBySchema)dumpAction;
            Path schemaPath = filterBySchema.schema();
            iO = WShEx$.MODULE$.fromPath(schemaPath, WShEx$.MODULE$.fromPath$default$2()).map((Function1 & Serializable & scala.Serializable)wshex -> {
                Matcher matcher = new Matcher(wshex, Matcher$.MODULE$.$lessinit$greater$default$2(), Matcher$.MODULE$.$lessinit$greater$default$3());
                return new Tuple2(wshex, (Object)matcher);
            }).map((Function1 & Serializable & scala.Serializable)x$4 -> {
                Tuple2 tuple2 = x$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Matcher matcher = (Matcher)tuple2._2();
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)entity -> MODULE$.checkSchema(matcher, refResults, (Entity)entity);
                return intersect;
            });
        } else if (CountEntities$.MODULE$.equals(dumpAction)) {
            iO = (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId(this.withEntryCount(refResults)), (Applicative)IO$.MODULE$.asyncForIO());
        } else if (dumpAction instanceof ShowEntities) {
            ShowEntities showEntities = (ShowEntities)dumpAction;
            Option<Object> max = showEntities.maxStatements();
            iO = (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId(this.withEntryShow(refResults, max)), (Applicative)IO$.MODULE$.asyncForIO());
        } else {
            throw new MatchError((Object)dumpAction);
        }
        return iO;
    }

    private Function1<Entity, IO<Option<String>>> withEntryCount(Ref<IO, DumpResults> counter) {
        return (Function1 & Serializable & scala.Serializable)x$5 -> ((IO)counter.update((Function1 & Serializable & scala.Serializable)x$6 -> x$6.addEntity())).map((Function1 & Serializable & scala.Serializable)_ -> None$.MODULE$);
    }

    private Function1<Entity, IO<Option<String>>> withEntryShow(Ref<IO, DumpResults> counter, Option<Object> maxEntities) {
        return (Function1 & Serializable & scala.Serializable)entity -> IO$.MODULE$.println((Object)entity.show(ShowEntityOptions$.MODULE$.default().witMaxStatements(maxEntities)), implicits$.MODULE$.catsStdShowForString()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> ((IO)counter.update((Function1 & Serializable & scala.Serializable)x$7 -> x$7.addEntity())).map((Function1 & Serializable & scala.Serializable)_ -> None$.MODULE$));
    }

    private IO<Option<String>> checkSchema(Matcher matcher, Ref<IO, DumpResults> refResults, Entity entity) {
        EntityDocument entityDocument;
        EntityDocument entityDocument2 = entity.entityDocument();
        IO iO = entityDocument2 != null ? (matcher.matchStart(entityDocument = entityDocument2).matches() ? ((IO)refResults.update((Function1 & Serializable & scala.Serializable)x$8 -> x$8.addMatched())).$times$greater((IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)new Some((Object)new Entity(entityDocument).asJsonStr())), (Applicative)IO$.MODULE$.asyncForIO())) : ((IO)refResults.update((Function1 & Serializable & scala.Serializable)x$9 -> x$9.addEntity())).$times$greater((IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)implicits$.MODULE$.none()), (Applicative)IO$.MODULE$.asyncForIO()))) : (IO)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId((Object)implicits$.MODULE$.none()), (Applicative)IO$.MODULE$.asyncForIO());
        return iO;
    }

    public static final /* synthetic */ boolean $anonfun$processor$2(String str$1, Product x$2) {
        String string = ((Processor)x$2).name();
        String string2 = str$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Main$() {
        String x$12 = "wdsub";
        String x$2 = "Wikidata subsetting command line tool";
        String x$32 = BuildInfo$.MODULE$.version();
        boolean x$4 = CommandIOApp$.MODULE$.$lessinit$greater$default$3();
        super(x$12, x$2, x$4, x$32);
        MODULE$ = this;
        this.processEntity = Opts$.MODULE$.subcommand("extract", "Show information about an entity.", Opts$.MODULE$.subcommand$default$3(), Opts$.MODULE$.option("entity", "Entity name", "e", Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readString()).map((Function1)ProcessEntity$.MODULE$));
        this.filePath = Opts$.MODULE$.argument("dumpFile", Argument$.MODULE$.readPath());
        this.processors = new .colon.colon((Object)Fs2$.MODULE$, (List)new .colon.colon((Object)WDTK$.MODULE$, (List)Nil$.MODULE$));
        this.processorNames = (List)this.processors().map((Function1 & Serializable & scala.Serializable)x$1 -> ((Processor)x$1).name(), List$.MODULE$.canBuildFrom());
        this.defaultProcessor = (Product)this.processors().head();
        this.maxStatements = Opts$.MODULE$.option("maxStatements", "max statements to show", Opts$.MODULE$.option$default$3(), Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readInt()).orNone();
        this.processor = Opts$.MODULE$.option("processor", new StringBuilder(41).append("Dump processor library. Possible values: ").append(this.processorNames().mkString(",")).toString(), Opts$.MODULE$.option$default$3(), Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readString()).mapValidated((Function1 & Serializable & scala.Serializable)str -> {
            Validated validated;
            Option option = MODULE$.processors().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Main$.$anonfun$processor$2(str, x$2)));
            if (None$.MODULE$.equals(option)) {
                validated = Validated$.MODULE$.invalidNel((Object)new StringBuilder(48).append("Invalid processor name: ").append((String)str).append(". Available processors: ").append(MODULE$.processorNames().mkString(",")).toString());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Product p = (Product)some.value();
                validated = Validated$.MODULE$.valid((Object)p);
            } else {
                throw new MatchError((Object)option);
            }
            return validated;
        }).withDefault((Object)this.defaultProcessor());
        this.schemaPath = Opts$.MODULE$.option("schema", "ShEx schema", "s", "file", Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readPath());
        this.outPath = Opts$.MODULE$.option("out", "output path", "o", "file", Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readPath()).orNone();
        this.verbose = Opts$.MODULE$.flag("verbose", "Verbose mode", Opts$.MODULE$.flag$default$3(), Opts$.MODULE$.flag$default$4()).orFalse(Predef$.MODULE$.$conforms());
        this.countEntities = Opts$.MODULE$.flag("count", "count entities", Opts$.MODULE$.flag$default$3(), Opts$.MODULE$.flag$default$4()).map((Function1 & Serializable & scala.Serializable)x$3 -> CountEntities$.MODULE$);
        this.showEntities = Opts$.MODULE$.flag("show", "show entities", Opts$.MODULE$.flag$default$3(), Opts$.MODULE$.flag$default$4());
        this.showEntitiesMax = (Opts)implicits$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(this.showEntities(), this.maxStatements())).mapN((Function2 & Serializable & scala.Serializable)(x, maxStatements) -> MODULE$.f((BoxedUnit)x, (Option<Object>)maxStatements), (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative());
        this.filterBySchema = this.schemaPath().map((Function1 & Serializable & scala.Serializable)path -> new FilterBySchema((Path)path));
        this.action = this.countEntities().orElse(this.showEntitiesMax()).orElse(this.filterBySchema());
        this.dump = Opts$.MODULE$.subcommand("dump", "Process example dump file.", Opts$.MODULE$.subcommand$default$3(), (Opts)implicits$.MODULE$.catsSyntaxTuple5Semigroupal(new Tuple5(this.filePath(), this.action(), this.outPath(), this.verbose(), this.processor())).mapN((Function5)Dump$.MODULE$, (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative()));
    }
}

