/*
 * Decompiled with CFR 0.152.
 */
package jcifs.context;

import jcifs.CIFSContext;
import jcifs.Credentials;
import jcifs.context.AbstractCIFSContext;
import jcifs.context.CIFSContextWrapper;
import jcifs.smb.CredentialsInternal;
import jcifs.smb.NtlmAuthenticator;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbRenewableCredentials;

public final class CIFSContextCredentialWrapper
extends CIFSContextWrapper
implements CIFSContext {
    private Credentials creds;

    public CIFSContextCredentialWrapper(AbstractCIFSContext delegate, Credentials creds) {
        super(delegate);
        this.creds = creds;
    }

    @Override
    public Credentials getCredentials() {
        return this.creds;
    }

    @Override
    public boolean renewCredentials(String locationHint, Throwable error) {
        NtlmPasswordAuthentication newAuth;
        NtlmAuthenticator auth;
        SmbRenewableCredentials renewable;
        CredentialsInternal renewed;
        Credentials cred = this.getCredentials();
        if (cred instanceof SmbRenewableCredentials && (renewed = (renewable = (SmbRenewableCredentials)cred).renew()) != null) {
            this.creds = renewed;
        }
        if ((auth = NtlmAuthenticator.getDefault()) != null && (newAuth = NtlmAuthenticator.requestNtlmPasswordAuthentication(auth, locationHint, error instanceof SmbAuthException ? (SmbAuthException)error : null)) != null) {
            this.creds = newAuth;
            return true;
        }
        return false;
    }
}

