/*
 * Decompiled with CFR 0.152.
 */
package jcifs.http;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jcifs.CIFSContext;
import jcifs.ntlmssp.NtlmFlags;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import org.bouncycastle.util.encoders.Base64;

public class NtlmSsp
implements NtlmFlags {
    public NtlmPasswordAuthentication doAuthentication(CIFSContext tc, HttpServletRequest req, HttpServletResponse resp, byte[] challenge) throws IOException {
        return NtlmSsp.authenticate(tc, req, resp, challenge);
    }

    public static NtlmPasswordAuthentication authenticate(CIFSContext tc, HttpServletRequest req, HttpServletResponse resp, byte[] challenge) throws IOException {
        String msg = req.getHeader("Authorization");
        if (msg != null && msg.startsWith("NTLM ")) {
            byte[] src = Base64.decode((String)msg.substring(5));
            if (src[8] == 1) {
                Type1Message type1 = new Type1Message(src);
                Type2Message type2 = new Type2Message(tc, type1, challenge, null);
                msg = new String(Base64.encode((byte[])type2.toByteArray()), "US-ASCII");
                resp.setHeader("WWW-Authenticate", "NTLM " + msg);
            } else if (src[8] == 3) {
                byte[] ntResponse;
                Type3Message type3 = new Type3Message(src);
                byte[] lmResponse = type3.getLMResponse();
                if (lmResponse == null) {
                    lmResponse = new byte[]{};
                }
                if ((ntResponse = type3.getNTResponse()) == null) {
                    ntResponse = new byte[]{};
                }
                return new NtlmPasswordAuthentication(type3.getDomain(), type3.getUser(), challenge, lmResponse, ntResponse);
            }
        } else {
            resp.setHeader("WWW-Authenticate", "NTLM");
        }
        resp.setStatus(401);
        resp.setContentLength(0);
        resp.flushBuffer();
        return null;
    }
}

