/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.com;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jcifs.Configuration;
import jcifs.RuntimeCIFSException;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.util.Strings;

public class SmbComNegotiate
extends ServerMessageBlock {
    private String[] dialects;

    public SmbComNegotiate(Configuration config) {
        super(config, (byte)114);
        this.setFlags2(config.getFlags2());
        this.dialects = config.getSupportedDialects();
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (String dialect : this.dialects) {
            bos.write(2);
            try {
                bos.write(Strings.getASCIIBytes(dialect));
            }
            catch (IOException e) {
                throw new RuntimeCIFSException(e);
            }
            bos.write(0);
        }
        System.arraycopy(bos.toByteArray(), 0, dst, dstIndex, bos.size());
        return bos.size();
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("SmbComNegotiate[" + super.toString() + ",wordCount=" + this.wordCount + ",dialects=NT LM 0.12]");
    }
}

