/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.com;

import java.util.Date;
import jcifs.CIFSContext;
import jcifs.internal.CommonServerMessageBlock;
import jcifs.internal.SmbNegotiationResponse;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.smb1.com.ServerData;
import jcifs.internal.smb1.trans.SmbComTransaction;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;
import jcifs.util.Strings;
import jcifs.util.transport.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbComNegotiateResponse
extends ServerMessageBlock
implements SmbNegotiationResponse {
    private static final Logger log = LoggerFactory.getLogger(SmbComNegotiateResponse.class);
    private int dialectIndex;
    private ServerData server = new ServerData();
    private int negotiatedFlags2;
    private int maxMpxCount;
    private int snd_buf_size;
    private int recv_buf_size;
    private int tx_buf_size;
    private int capabilities;
    private int sessionKey = 0;
    private boolean useUnicode;

    public SmbComNegotiateResponse(CIFSContext ctx) {
        super(ctx.getConfig());
        this.capabilities = ctx.getConfig().getCapabilities();
        this.negotiatedFlags2 = ctx.getConfig().getFlags2();
        this.maxMpxCount = ctx.getConfig().getMaxMpxCount();
        this.snd_buf_size = ctx.getConfig().getSendBufferSize();
        this.recv_buf_size = ctx.getConfig().getRecieveBufferSize();
        this.tx_buf_size = ctx.getConfig().getTransactionBufferSize();
        this.useUnicode = ctx.getConfig().isUseUnicode();
    }

    @Override
    public int getTransactionBufferSize() {
        return this.tx_buf_size;
    }

    @Override
    public int getInitialCredits() {
        return this.getNegotiatedMpxCount();
    }

    @Override
    public boolean canReuse(CIFSContext tc, boolean forceSigning) {
        return this.getConfig().equals(tc.getConfig());
    }

    public int getDialectIndex() {
        return this.dialectIndex;
    }

    public int getNegotiatedCapabilities() {
        return this.capabilities;
    }

    public int getNegotiatedSendBufferSize() {
        return this.snd_buf_size;
    }

    public int getNegotiatedMpxCount() {
        return this.maxMpxCount;
    }

    public int getNegotiatedSessionKey() {
        return this.sessionKey;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.recv_buf_size;
    }

    @Override
    public int getSendBufferSize() {
        return this.snd_buf_size;
    }

    public int getNegotiatedFlags2() {
        return this.negotiatedFlags2;
    }

    @Override
    public boolean haveCapabilitiy(int cap) {
        return (this.capabilities & cap) == cap;
    }

    @Override
    public boolean isDFSSupported() {
        return !this.getConfig().isDfsDisabled() && this.haveCapabilitiy(4096);
    }

    @Override
    public boolean isSigningNegotiated() {
        return (this.negotiatedFlags2 & 4) == 4;
    }

    @Override
    public boolean isValid(CIFSContext ctx, boolean signingEnforced) {
        if (this.getDialectIndex() > 10) {
            return false;
        }
        if ((this.server.scapabilities & Integer.MIN_VALUE) != Integer.MIN_VALUE && this.server.encryptionKeyLength != 8 && ctx.getConfig().getLanManCompatibility() == 0) {
            log.warn("Unexpected encryption key length: " + this.server.encryptionKeyLength);
            return false;
        }
        if (signingEnforced && !this.server.signaturesEnabled) {
            log.error("Signatures are required but the server does not support them");
            return false;
        }
        if (signingEnforced || this.server.signaturesRequired || this.server.signaturesEnabled && ctx.getConfig().isSigningEnabled()) {
            this.negotiatedFlags2 |= 4;
            if (signingEnforced || this.isSigningRequired()) {
                this.negotiatedFlags2 |= 0x10;
            }
        } else {
            this.negotiatedFlags2 &= 0xFFFB;
            this.negotiatedFlags2 &= 0xFFEF;
        }
        if (log.isDebugEnabled()) {
            log.debug("Signing " + ((this.negotiatedFlags2 & 4) != 0 ? "enabled " : "not-enabled ") + ((this.negotiatedFlags2 & 0x10) != 0 ? "required" : "not-required"));
        }
        this.maxMpxCount = Math.min(this.maxMpxCount, this.server.smaxMpxCount);
        if (this.maxMpxCount < 1) {
            this.maxMpxCount = 1;
        }
        this.snd_buf_size = Math.min(this.snd_buf_size, this.server.maxBufferSize);
        this.recv_buf_size = Math.min(this.recv_buf_size, this.server.maxBufferSize);
        this.tx_buf_size = Math.min(this.tx_buf_size, this.server.maxBufferSize);
        this.capabilities &= this.server.scapabilities;
        if ((this.server.scapabilities & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            this.capabilities |= Integer.MIN_VALUE;
        }
        if (ctx.getConfig().isUseUnicode() || ctx.getConfig().isForceUnicode()) {
            this.capabilities |= 4;
        }
        if ((this.capabilities & 4) == 0) {
            if (ctx.getConfig().isForceUnicode()) {
                this.capabilities |= 4;
                this.useUnicode = true;
            } else {
                this.useUnicode = false;
                this.negotiatedFlags2 &= Short.MAX_VALUE;
            }
        } else {
            this.useUnicode = ctx.getConfig().isUseUnicode();
        }
        if (this.useUnicode) {
            log.debug("Unicode is enabled");
        } else {
            log.debug("Unicode is disabled");
        }
        return true;
    }

    @Override
    public void setupRequest(CommonServerMessageBlock request) {
        if (!(request instanceof ServerMessageBlock)) {
            return;
        }
        ServerMessageBlock req = (ServerMessageBlock)request;
        req.addFlags2(this.negotiatedFlags2);
        req.setUseUnicode(req.isForceUnicode() || this.useUnicode);
        if (req.isUseUnicode()) {
            req.addFlags2(32768);
        }
        if (req instanceof SmbComTransaction) {
            ((SmbComTransaction)req).setMaxBufferSize(this.snd_buf_size);
        }
    }

    @Override
    public void setupResponse(Response resp) {
        if (!(resp instanceof ServerMessageBlock)) {
            return;
        }
        ((ServerMessageBlock)resp).setUseUnicode(this.useUnicode);
    }

    @Override
    public boolean isSigningEnabled() {
        return this.server.signaturesEnabled || this.server.signaturesRequired;
    }

    @Override
    public boolean isSigningRequired() {
        return this.server.signaturesRequired;
    }

    public ServerData getServerData() {
        return this.server;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.dialectIndex = SMBUtil.readInt2(buffer, bufferIndex);
        bufferIndex += 2;
        if (this.dialectIndex > 10) {
            return bufferIndex - start;
        }
        this.server.securityMode = buffer[bufferIndex++] & 0xFF;
        this.server.security = this.server.securityMode & 1;
        this.server.encryptedPasswords = (this.server.securityMode & 2) == 2;
        this.server.signaturesEnabled = (this.server.securityMode & 4) == 4;
        this.server.signaturesRequired = (this.server.securityMode & 8) == 8;
        this.server.smaxMpxCount = SMBUtil.readInt2(buffer, bufferIndex);
        this.server.maxNumberVcs = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.server.maxBufferSize = SMBUtil.readInt4(buffer, bufferIndex += 2);
        this.server.maxRawSize = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.server.sessKey = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.server.scapabilities = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.server.serverTime = SMBUtil.readTime(buffer, bufferIndex += 4);
        int tzOffset = SMBUtil.readInt2(buffer, bufferIndex += 8);
        if (tzOffset > Short.MAX_VALUE) {
            tzOffset = -1 * (65536 - tzOffset);
        }
        this.server.serverTimeZone = tzOffset;
        bufferIndex += 2;
        this.server.encryptionKeyLength = buffer[bufferIndex++] & 0xFF;
        return bufferIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        if ((this.server.scapabilities & Integer.MIN_VALUE) == 0) {
            this.server.encryptionKey = new byte[this.server.encryptionKeyLength];
            System.arraycopy(buffer, bufferIndex, this.server.encryptionKey, 0, this.server.encryptionKeyLength);
            bufferIndex += this.server.encryptionKeyLength;
            if (this.byteCount > this.server.encryptionKeyLength) {
                int len = 0;
                if ((this.negotiatedFlags2 & 0x8000) == 32768) {
                    len = Strings.findUNITermination(buffer, bufferIndex, 256);
                    this.server.oemDomainName = Strings.fromUNIBytes(buffer, bufferIndex, len);
                } else {
                    len = Strings.findTermination(buffer, bufferIndex, 256);
                    this.server.oemDomainName = Strings.fromOEMBytes(buffer, bufferIndex, len, this.getConfig());
                }
                bufferIndex += len;
            } else {
                this.server.oemDomainName = new String();
            }
        } else {
            this.server.guid = new byte[16];
            System.arraycopy(buffer, bufferIndex, this.server.guid, 0, 16);
            bufferIndex += this.server.guid.length;
            this.server.oemDomainName = new String();
            if (this.byteCount > 16) {
                this.server.encryptionKeyLength = this.byteCount - 16;
                this.server.encryptionKey = new byte[this.server.encryptionKeyLength];
                System.arraycopy(buffer, bufferIndex, this.server.encryptionKey, 0, this.server.encryptionKeyLength);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Have initial token %s", Hexdump.toHexString(this.server.encryptionKey, 0, this.server.encryptionKeyLength)));
                }
            }
        }
        return bufferIndex - start;
    }

    @Override
    public String toString() {
        return new String("SmbComNegotiateResponse[" + super.toString() + ",wordCount=" + this.wordCount + ",dialectIndex=" + this.dialectIndex + ",securityMode=0x" + Hexdump.toHexString(this.server.securityMode, 1) + ",security=" + (this.server.security == 0 ? "share" : "user") + ",encryptedPasswords=" + this.server.encryptedPasswords + ",maxMpxCount=" + this.server.smaxMpxCount + ",maxNumberVcs=" + this.server.maxNumberVcs + ",maxBufferSize=" + this.server.maxBufferSize + ",maxRawSize=" + this.server.maxRawSize + ",sessionKey=0x" + Hexdump.toHexString(this.server.sessKey, 8) + ",capabilities=0x" + Hexdump.toHexString(this.server.scapabilities, 8) + ",serverTime=" + new Date(this.server.serverTime) + ",serverTimeZone=" + this.server.serverTimeZone + ",encryptionKeyLength=" + this.server.encryptionKeyLength + ",byteCount=" + this.byteCount + ",oemDomainName=" + this.server.oemDomainName + "]");
    }
}

