/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.ioctl;

import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.Encodable;
import jcifs.internal.smb2.RequestWithFileId;
import jcifs.internal.smb2.ServerMessageBlock2Request;
import jcifs.internal.smb2.Smb2Constants;
import jcifs.internal.smb2.ioctl.Smb2IoctlResponse;
import jcifs.internal.util.SMBUtil;

public class Smb2IoctlRequest
extends ServerMessageBlock2Request<Smb2IoctlResponse>
implements RequestWithFileId {
    public static final int FSCTL_DFS_GET_REFERRALS = 393620;
    public static final int FSCTL_PIPE_PEEK = 1130508;
    public static final int FSCTL_PIPE_WAIT = 0x110018;
    public static final int FSCTL_PIPE_TRANSCEIVE = 1163287;
    public static final int FSCTL_SRV_COPYCHUNK = 1327346;
    public static final int FSCTL_SRV_ENUMERATE_SNAPSHOTS = 1327204;
    public static final int FSCTL_SRV_REQUEST_RESUME_KEY = 1310840;
    public static final int FSCTL_SRV_READ_HASH = 0x1441BB;
    public static final int FSCTL_SRV_COPYCHUNK_WRITE = 1343730;
    public static final int FSCTL_LRM_REQUEST_RESILENCY = 1311188;
    public static final int FSCTL_QUERY_NETWORK_INTERFACE_INFO = 1311228;
    public static final int FSCTL_SET_REPARSE_POINT = 589988;
    public static final int FSCTL_DFS_GET_REFERRALS_EX = 393648;
    public static final int FSCTL_FILE_LEVEL_TRIM = 623112;
    public static final int FSCTL_VALIDATE_NEGOTIATE_INFO = 1311236;
    public static final int SMB2_O_IOCTL_IS_FSCTL = 1;
    private byte[] fileId;
    private final int controlCode;
    private final byte[] outputBuffer;
    private int maxOutputResponse;
    private int maxInputResponse;
    private int flags;
    private Encodable inputData;
    private Encodable outputData;

    public Smb2IoctlRequest(Configuration config, int controlCode) {
        this(config, controlCode, Smb2Constants.UNSPECIFIED_FILEID);
    }

    public Smb2IoctlRequest(Configuration config, int controlCode, byte[] fileId) {
        super(config, 11);
        this.controlCode = controlCode;
        this.fileId = fileId;
        this.maxOutputResponse = config.getTransactionBufferSize() & 0xFFFFFFF8;
        this.outputBuffer = null;
    }

    @Override
    public void setFileId(byte[] fileId) {
        this.fileId = fileId;
    }

    public Smb2IoctlRequest(Configuration config, int controlCode, byte[] fileId, byte[] outputBuffer) {
        super(config, 11);
        this.controlCode = controlCode;
        this.fileId = fileId;
        this.outputBuffer = outputBuffer;
        this.maxOutputResponse = outputBuffer.length;
    }

    @Override
    protected Smb2IoctlResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2IoctlResponse> req) {
        return new Smb2IoctlResponse(tc.getConfig(), this.outputBuffer);
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setMaxInputResponse(int maxInputResponse) {
        this.maxInputResponse = maxInputResponse;
    }

    public void setMaxOutputResponse(int maxOutputResponse) {
        this.maxOutputResponse = maxOutputResponse;
    }

    public void setInputData(Encodable inputData) {
        this.inputData = inputData;
    }

    public void setOutputData(Encodable outputData) {
        this.outputData = outputData;
    }

    @Override
    public int size() {
        int size = 120;
        int dataLength = 0;
        if (this.inputData != null) {
            dataLength += this.inputData.size();
        }
        if (this.outputData != null) {
            dataLength += this.outputData.size();
        }
        return Smb2IoctlRequest.size8(size + dataLength);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int len;
        int start = dstIndex;
        SMBUtil.writeInt2(57L, dst, dstIndex);
        SMBUtil.writeInt4(this.controlCode, dst, dstIndex += 4);
        System.arraycopy(this.fileId, 0, dst, dstIndex += 4, 16);
        int inputOffsetOffset = dstIndex += 16;
        int inputLengthOffset = dstIndex += 4;
        SMBUtil.writeInt4(this.maxInputResponse, dst, dstIndex += 4);
        int outputOffsetOffset = dstIndex += 4;
        int outputLengthOffset = dstIndex += 4;
        SMBUtil.writeInt4(this.maxOutputResponse, dst, dstIndex += 4);
        SMBUtil.writeInt4(this.flags, dst, dstIndex += 4);
        dstIndex += 4;
        dstIndex += 4;
        if (this.inputData != null) {
            SMBUtil.writeInt4(dstIndex - this.getHeaderStart(), dst, inputOffsetOffset);
            len = this.inputData.encode(dst, dstIndex);
            SMBUtil.writeInt4(len, dst, inputLengthOffset);
            dstIndex += len;
        } else {
            SMBUtil.writeInt4(0L, dst, inputOffsetOffset);
            SMBUtil.writeInt4(0L, dst, inputLengthOffset);
        }
        if (this.outputData != null) {
            SMBUtil.writeInt4(dstIndex - this.getHeaderStart(), dst, outputOffsetOffset);
            len = this.outputData.encode(dst, dstIndex);
            SMBUtil.writeInt4(len, dst, outputLengthOffset);
            dstIndex += len;
        } else {
            SMBUtil.writeInt4(0L, dst, outputOffsetOffset);
            SMBUtil.writeInt4(0L, dst, outputLengthOffset);
        }
        return dstIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

