/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.ioctl;

import jcifs.Configuration;
import jcifs.Decodable;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.dfs.DfsReferralResponseBuffer;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.smb2.ioctl.SrvCopyChunkCopyResponse;
import jcifs.internal.smb2.ioctl.SrvRequestResumeKeyResponse;
import jcifs.internal.util.SMBUtil;
import jcifs.smb.SmbException;

public class Smb2IoctlResponse
extends ServerMessageBlock2Response {
    private final byte[] outputBuffer;
    private int ctlCode;
    private byte[] fileId;
    private int ioctlFlags;
    private Decodable outputData;
    private Decodable inputData;
    private int outputLength;

    public Smb2IoctlResponse(Configuration config) {
        super(config);
        this.outputBuffer = null;
    }

    public Smb2IoctlResponse(Configuration config, byte[] outputBuffer) {
        super(config);
        this.outputBuffer = outputBuffer;
    }

    public int getCtlCode() {
        return this.ctlCode;
    }

    public int getIoctlFlags() {
        return this.ioctlFlags;
    }

    public byte[] getFileId() {
        return this.fileId;
    }

    public Decodable getOutputData() {
        return this.outputData;
    }

    public int getOutputLength() {
        return this.outputLength;
    }

    public Decodable getInputData() {
        return this.inputData;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected boolean isErrorResponseStatus() {
        return this.getStatus() != -1073741811 && super.isErrorResponseStatus();
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize == 9) {
            return super.readErrorResponse(buffer, bufferIndex);
        }
        if (structureSize != 49) {
            throw new SMBProtocolDecodingException("Expected structureSize = 49");
        }
        this.ctlCode = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.fileId = new byte[16];
        System.arraycopy(buffer, bufferIndex += 4, this.fileId, 0, 16);
        int inputOffset = SMBUtil.readInt4(buffer, bufferIndex += 16) + this.getHeaderStart();
        int inputCount = SMBUtil.readInt4(buffer, bufferIndex += 4);
        int outputOffset = SMBUtil.readInt4(buffer, bufferIndex += 4) + this.getHeaderStart();
        int outputCount = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.ioctlFlags = SMBUtil.readInt4(buffer, bufferIndex += 4);
        bufferIndex += 4;
        bufferIndex += 4;
        this.inputData = this.createInputDecodable();
        Decodable decodable = this.outputData = this.outputBuffer == null ? this.createOutputDecodable() : null;
        if (this.inputData != null) {
            this.inputData.decode(buffer, inputOffset, inputCount);
        }
        bufferIndex = Math.max(inputOffset + inputCount, bufferIndex);
        if (this.outputBuffer != null) {
            if (outputCount > this.outputBuffer.length) {
                throw new SMBProtocolDecodingException("Output length exceeds buffer size");
            }
            System.arraycopy(buffer, outputOffset, this.outputBuffer, 0, outputCount);
        } else if (this.outputData != null) {
            this.outputData.decode(buffer, outputOffset, outputCount);
        }
        this.outputLength = outputCount;
        bufferIndex = Math.max(outputOffset + outputCount, bufferIndex);
        return bufferIndex - start;
    }

    protected Decodable createOutputDecodable() {
        switch (this.ctlCode) {
            case 393620: {
                return new DfsReferralResponseBuffer();
            }
            case 1310840: {
                return new SrvRequestResumeKeyResponse();
            }
            case 1327346: 
            case 1343730: {
                return new SrvCopyChunkCopyResponse();
            }
        }
        return null;
    }

    protected Decodable createInputDecodable() {
        return null;
    }

    public <T extends Decodable> T getOutputData(Class<T> responseType) throws SmbException {
        Decodable out = this.getOutputData();
        if (out == null) {
            throw new SmbException("Failed to decode output data");
        }
        if (!responseType.isAssignableFrom(out.getClass())) {
            throw new SmbException("Incompatible response data " + out.getClass());
        }
        return (T)out;
    }
}

