/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.nego;

import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.internal.smb2.ServerMessageBlock2Request;
import jcifs.internal.smb2.nego.NegotiateContextRequest;
import jcifs.internal.smb2.nego.Smb2NegotiateResponse;
import jcifs.internal.util.SMBUtil;

public class Smb2NegotiateRequest
extends ServerMessageBlock2Request<Smb2NegotiateResponse> {
    private int[] dialects;
    private int capabilities;
    private byte[] clientGuid = new byte[16];
    private int securityMode;
    private NegotiateContextRequest[] negotiateContexts;

    public Smb2NegotiateRequest(Configuration config, int securityMode) {
        super(config, 0);
        this.securityMode = securityMode;
        if (!config.isDfsDisabled()) {
            this.capabilities = 1;
        }
        this.dialects = new int[]{514};
    }

    @Override
    protected Smb2NegotiateResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2NegotiateResponse> req) {
        return new Smb2NegotiateResponse(tc.getConfig());
    }

    @Override
    public int size() {
        int size = 100 + Smb2NegotiateRequest.size8(2 * this.dialects.length, 4);
        if (this.negotiateContexts != null) {
            for (NegotiateContextRequest ncr : this.negotiateContexts) {
                size += Smb2NegotiateRequest.size8(ncr.size());
            }
        }
        return Smb2NegotiateRequest.size8(size);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(36L, dst, dstIndex);
        SMBUtil.writeInt2(this.dialects.length, dst, dstIndex + 2);
        SMBUtil.writeInt2(this.securityMode, dst, dstIndex += 4);
        SMBUtil.writeInt2(0L, dst, dstIndex + 2);
        SMBUtil.writeInt4(this.capabilities, dst, dstIndex += 4);
        System.arraycopy(this.clientGuid, 0, dst, dstIndex += 4, 16);
        dstIndex += 16;
        int negotitateContextOffsetOffset = 0;
        if (this.negotiateContexts == null || this.negotiateContexts.length == 0) {
            SMBUtil.writeInt8(0L, dst, dstIndex);
        } else {
            negotitateContextOffsetOffset = dstIndex;
            SMBUtil.writeInt2(this.negotiateContexts.length, dst, dstIndex);
        }
        dstIndex += 8;
        for (int dialect : this.dialects) {
            SMBUtil.writeInt2(dialect, dst, dstIndex);
            dstIndex += 2;
        }
        dstIndex += this.pad8(dstIndex);
        if (this.negotiateContexts != null && this.negotiateContexts.length != 0) {
            SMBUtil.writeInt4(dstIndex - this.getHeaderStart(), dst, negotitateContextOffsetOffset);
            for (NegotiateContextRequest nc : this.negotiateContexts) {
                SMBUtil.writeInt2(nc.getContextType(), dst, dstIndex);
                int lenOffset = dstIndex + 2;
                dstIndex += 4;
                int dataLen = nc.encode(dst, dstIndex += 4);
                SMBUtil.writeInt2(dataLen, dst, lenOffset);
                dstIndex += dataLen;
                dstIndex += this.pad8(dstIndex);
            }
        }
        return dstIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

