/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.nego;

import java.util.Date;
import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.internal.CommonServerMessageBlock;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.SmbNegotiationResponse;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.smb2.nego.NegotiateContextResponse;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;
import jcifs.util.transport.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Smb2NegotiateResponse
extends ServerMessageBlock2Response
implements SmbNegotiationResponse {
    private static final Logger log = LoggerFactory.getLogger(Smb2NegotiateResponse.class);
    private int securityMode;
    private int dialectRevision;
    private byte[] serverGuid = new byte[16];
    private int capabilities;
    private int maxTransactSize;
    private int maxReadSize;
    private int maxWriteSize;
    private long systemTime;
    private long serverStartTime;
    private NegotiateContextResponse[] negotiateContexts;
    private byte[] securityBuffer;

    public Smb2NegotiateResponse(Configuration cfg) {
        super(cfg);
    }

    @Override
    public int getInitialCredits() {
        return this.getCredit();
    }

    public int getDialectRevision() {
        return this.dialectRevision;
    }

    public final int getCapabilities() {
        return this.capabilities;
    }

    public byte[] getSecurityBlob() {
        return this.securityBuffer;
    }

    public int getMaxTransactSize() {
        return this.maxTransactSize;
    }

    @Override
    public int getTransactionBufferSize() {
        return this.getMaxTransactSize();
    }

    public NegotiateContextResponse[] getNegotiateContexts() {
        return this.negotiateContexts;
    }

    public long getServerStartTime() {
        return this.serverStartTime;
    }

    public int getSecurityMode() {
        return this.securityMode;
    }

    @Override
    public boolean haveCapabilitiy(int cap) {
        return (this.capabilities & cap) == cap;
    }

    @Override
    public boolean isDFSSupported() {
        return !this.getConfig().isDfsDisabled() && this.haveCapabilitiy(1);
    }

    @Override
    public boolean canReuse(CIFSContext tc, boolean forceSigning) {
        return this.getConfig().equals(tc.getConfig());
    }

    @Override
    public boolean isValid(CIFSContext tc, boolean signingEnforced) {
        if (!this.isReceived() || this.getStatus() != 0) {
            return false;
        }
        if (signingEnforced && !this.isSigningEnabled()) {
            log.error("Signing is enforced but server does not allow it");
            return false;
        }
        if (this.getDialectRevision() == 767) {
            log.error("Server returned ANY dialect");
            return false;
        }
        int maxBufferSize = tc.getConfig().getTransactionBufferSize();
        this.maxReadSize = Math.min(maxBufferSize - 80, Math.min(tc.getConfig().getRecieveBufferSize(), this.maxReadSize)) & 0xFFFFFFF8;
        this.maxWriteSize = Math.min(maxBufferSize - 112, Math.min(tc.getConfig().getSendBufferSize(), this.maxWriteSize)) & 0xFFFFFFF8;
        this.maxTransactSize = Math.min(maxBufferSize - 512, this.maxTransactSize) & 0xFFFFFFF8;
        return true;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.maxReadSize;
    }

    @Override
    public int getSendBufferSize() {
        return this.maxWriteSize;
    }

    @Override
    public boolean isSigningEnabled() {
        return (this.securityMode & 3) != 0;
    }

    @Override
    public boolean isSigningRequired() {
        return (this.securityMode & 2) == 2;
    }

    @Override
    public boolean isSigningNegotiated() {
        return this.isSigningEnabled();
    }

    @Override
    public void setupRequest(CommonServerMessageBlock request) {
    }

    @Override
    public void setupResponse(Response resp) {
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 65) {
            throw new SMBProtocolDecodingException("Structure size is not 65");
        }
        this.securityMode = SMBUtil.readInt2(buffer, bufferIndex + 2);
        this.dialectRevision = SMBUtil.readInt2(buffer, bufferIndex += 4);
        int negotiateContextCount = SMBUtil.readInt2(buffer, bufferIndex + 2);
        System.arraycopy(buffer, bufferIndex += 4, this.serverGuid, 0, 16);
        this.capabilities = SMBUtil.readInt4(buffer, bufferIndex += 16);
        this.maxTransactSize = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.maxReadSize = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.maxWriteSize = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.systemTime = SMBUtil.readTime(buffer, bufferIndex += 4);
        this.serverStartTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        int securityBufferOffset = SMBUtil.readInt2(buffer, bufferIndex += 8);
        int securityBufferLength = SMBUtil.readInt2(buffer, bufferIndex + 2);
        int negotiateContextOffset = SMBUtil.readInt4(buffer, bufferIndex += 4);
        bufferIndex += 4;
        int hdrStart = this.getHeaderStart();
        if (hdrStart + securityBufferOffset + securityBufferLength < buffer.length) {
            this.securityBuffer = new byte[securityBufferLength];
            System.arraycopy(buffer, hdrStart + securityBufferOffset, this.securityBuffer, 0, securityBufferLength);
            bufferIndex += securityBufferLength;
        }
        int pad = (bufferIndex - hdrStart) % 8;
        bufferIndex += pad;
        if (negotiateContextOffset != 0 && negotiateContextCount != 0) {
            NegotiateContextResponse[] contexts = new NegotiateContextResponse[negotiateContextCount];
            for (int i = 0; i < negotiateContextCount; ++i) {
                int type = SMBUtil.readInt2(buffer, bufferIndex);
                int dataLen = SMBUtil.readInt2(buffer, bufferIndex + 2);
                bufferIndex += 4;
                bufferIndex += 4;
                NegotiateContextResponse ctx = Smb2NegotiateResponse.createContext(type);
                if (ctx != null) {
                    ctx.decode(buffer, bufferIndex, dataLen);
                    contexts[i] = ctx;
                }
                bufferIndex += dataLen;
                if (i == negotiateContextCount - 1) continue;
                bufferIndex += this.pad8(bufferIndex);
            }
        }
        return bufferIndex - start;
    }

    protected static NegotiateContextResponse createContext(int type) {
        return null;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("Smb2NegotiateResponse[" + super.toString() + ",dialectRevision=" + this.dialectRevision + ",securityMode=0x" + Hexdump.toHexString(this.securityMode, 1) + ",capabilities=0x" + Hexdump.toHexString(this.capabilities, 8) + ",serverTime=" + new Date(this.systemTime));
    }
}

