/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.session;

import jcifs.CIFSContext;
import jcifs.internal.smb2.ServerMessageBlock2;
import jcifs.internal.smb2.ServerMessageBlock2Request;
import jcifs.internal.smb2.session.Smb2SessionSetupResponse;
import jcifs.internal.util.SMBUtil;

public class Smb2SessionSetupRequest
extends ServerMessageBlock2Request<Smb2SessionSetupResponse> {
    private byte[] token;
    private int capabilities;
    private long previousSessionId;
    private int securityMode;

    public Smb2SessionSetupRequest(CIFSContext context, int securityMode, int capabilities, long previousSessionid, byte[] token) {
        super(context.getConfig(), 1);
        this.securityMode = securityMode;
        this.capabilities = capabilities;
        this.previousSessionId = previousSessionid;
        this.token = token;
    }

    @Override
    protected Smb2SessionSetupResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2SessionSetupResponse> req) {
        return new Smb2SessionSetupResponse(tc.getConfig());
    }

    @Override
    public boolean chain(ServerMessageBlock2 n) {
        n.setSessionId(-1L);
        return super.chain(n);
    }

    @Override
    public int size() {
        return Smb2SessionSetupRequest.size8(88 + (this.token != null ? this.token.length : 0));
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(25L, dst, dstIndex);
        dst[dstIndex + 2] = (byte)(this.previousSessionId != 0L ? 1 : 0);
        dst[dstIndex + 3] = (byte)this.securityMode;
        SMBUtil.writeInt4(this.capabilities, dst, dstIndex += 4);
        SMBUtil.writeInt4(0L, dst, dstIndex += 4);
        int offsetOffset = dstIndex += 4;
        SMBUtil.writeInt2(this.token != null ? (long)this.token.length : 0L, dst, dstIndex += 2);
        SMBUtil.writeInt8(this.previousSessionId, dst, dstIndex += 2);
        SMBUtil.writeInt2((dstIndex += 8) - this.getHeaderStart(), dst, offsetOffset);
        dstIndex += this.pad8(dstIndex);
        if (this.token != null) {
            System.arraycopy(this.token, 0, dst, dstIndex, this.token.length);
            dstIndex += this.token.length;
        }
        return dstIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

