/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp;

import java.io.IOException;
import jcifs.CIFSContext;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.util.Hexdump;

public class Type1Message
extends NtlmMessage {
    private String suppliedDomain;
    private String suppliedWorkstation;

    public Type1Message(CIFSContext tc) {
        this(tc, Type1Message.getDefaultFlags(tc), tc.getConfig().getDefaultDomain(), tc.getNameServiceClient().getLocalHost().getHostName());
    }

    public Type1Message(CIFSContext tc, int flags, String suppliedDomain, String suppliedWorkstation) {
        this.setFlags(Type1Message.getDefaultFlags(tc) | flags);
        this.setSuppliedDomain(suppliedDomain);
        if (suppliedWorkstation == null) {
            suppliedWorkstation = tc.getNameServiceClient().getLocalHost().getHostName();
        }
        this.setSuppliedWorkstation(suppliedWorkstation);
    }

    public Type1Message(byte[] material) throws IOException {
        this.parse(material);
    }

    public String getSuppliedDomain() {
        return this.suppliedDomain;
    }

    public void setSuppliedDomain(String suppliedDomain) {
        this.suppliedDomain = suppliedDomain;
    }

    public String getSuppliedWorkstation() {
        return this.suppliedWorkstation;
    }

    public void setSuppliedWorkstation(String suppliedWorkstation) {
        this.suppliedWorkstation = suppliedWorkstation;
    }

    @Override
    public byte[] toByteArray() {
        try {
            String suppliedDomainString = this.getSuppliedDomain();
            String suppliedWorkstationString = this.getSuppliedWorkstation();
            int flags = this.getFlags();
            boolean hostInfo = false;
            byte[] domain = new byte[]{};
            if (suppliedDomainString != null && suppliedDomainString.length() != 0) {
                hostInfo = true;
                flags |= 0x1000;
                domain = suppliedDomainString.toUpperCase().getBytes(Type1Message.getOEMEncoding());
            } else {
                flags &= 0xFFFFEFFF;
            }
            byte[] workstation = new byte[]{};
            if (suppliedWorkstationString != null && suppliedWorkstationString.length() != 0) {
                hostInfo = true;
                flags |= 0x2000;
                workstation = suppliedWorkstationString.toUpperCase().getBytes(Type1Message.getOEMEncoding());
            } else {
                flags &= 0xFFFFDFFF;
            }
            byte[] type1 = new byte[hostInfo ? 32 + domain.length + workstation.length : 16];
            System.arraycopy(NTLMSSP_SIGNATURE, 0, type1, 0, 8);
            Type1Message.writeULong(type1, 8, 1);
            Type1Message.writeULong(type1, 12, flags);
            if (hostInfo) {
                Type1Message.writeSecurityBuffer(type1, 16, 32, domain);
                Type1Message.writeSecurityBuffer(type1, 24, 32 + domain.length, workstation);
            }
            return type1;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public String toString() {
        String suppliedDomainString = this.getSuppliedDomain();
        String suppliedWorkstationString = this.getSuppliedWorkstation();
        return "Type1Message[suppliedDomain=" + (suppliedDomainString == null ? "null" : suppliedDomainString) + ",suppliedWorkstation=" + (suppliedWorkstationString == null ? "null" : suppliedWorkstationString) + ",flags=0x" + Hexdump.toHexString(this.getFlags(), 8) + "]";
    }

    public static int getDefaultFlags(CIFSContext tc) {
        return 0x200 | (tc.getConfig().isUseUnicode() ? 1 : 2);
    }

    private void parse(byte[] material) throws IOException {
        for (int i = 0; i < 8; ++i) {
            if (material[i] == NTLMSSP_SIGNATURE[i]) continue;
            throw new IOException("Not an NTLMSSP message.");
        }
        if (Type1Message.readULong(material, 8) != 1) {
            throw new IOException("Not a Type 1 message.");
        }
        int flags = Type1Message.readULong(material, 12);
        String suppliedDomainString = null;
        if ((flags & 0x1000) != 0) {
            byte[] domain = Type1Message.readSecurityBuffer(material, 16);
            suppliedDomainString = new String(domain, Type1Message.getOEMEncoding());
        }
        String suppliedWorkstationString = null;
        if ((flags & 0x2000) != 0) {
            byte[] workstation = Type1Message.readSecurityBuffer(material, 24);
            suppliedWorkstationString = new String(workstation, Type1Message.getOEMEncoding());
        }
        this.setFlags(flags);
        this.setSuppliedDomain(suppliedDomainString);
        this.setSuppliedWorkstation(suppliedWorkstationString);
    }
}

