/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import jcifs.CIFSContext;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type2Message;
import jcifs.smb.NtlmUtil;
import jcifs.util.Crypto;
import jcifs.util.Hexdump;

public class Type3Message
extends NtlmMessage {
    private byte[] lmResponse;
    private byte[] ntResponse;
    private String domain;
    private String user;
    private String workstation;
    private byte[] masterKey = null;
    private byte[] sessionKey = null;

    public Type3Message(CIFSContext tc) {
        this.setFlags(Type3Message.getDefaultFlags(tc));
        this.setDomain(tc.getConfig().getDefaultDomain());
        this.setUser(tc.getConfig().getDefaultUsername());
        this.setWorkstation(tc.getNameServiceClient().getLocalHost().getHostName());
    }

    public Type3Message(CIFSContext tc, Type2Message type2) throws GeneralSecurityException {
        this.setFlags(Type3Message.getDefaultFlags(tc, type2));
        this.setWorkstation(tc.getNameServiceClient().getLocalHost().getHostName());
        String defaultDomain = tc.getConfig().getDefaultDomain();
        this.setDomain(defaultDomain);
        String defaultUser = tc.getConfig().getDefaultUsername();
        this.setUser(defaultUser);
        String password = tc.getConfig().getDefaultPassword();
        switch (tc.getConfig().getLanManCompatibility()) {
            case 0: 
            case 1: {
                this.setLMResponse(Type3Message.getLMResponse(tc, type2, password));
                this.setNTResponse(Type3Message.getNTResponse(tc, type2, password));
                break;
            }
            case 2: {
                byte[] nt = Type3Message.getNTResponse(tc, type2, password);
                this.setLMResponse(nt);
                this.setNTResponse(nt);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                byte[] clientChallenge = new byte[8];
                tc.getConfig().getRandom().nextBytes(clientChallenge);
                this.setLMResponse(Type3Message.getLMv2Response(tc, type2, defaultDomain, defaultUser, password, clientChallenge));
                break;
            }
            default: {
                this.setLMResponse(Type3Message.getLMResponse(tc, type2, password));
                this.setNTResponse(Type3Message.getNTResponse(tc, type2, password));
            }
        }
    }

    public Type3Message(CIFSContext tc, Type2Message type2, String password, String domain, String user, String workstation, int flags) throws GeneralSecurityException {
        this.setFlags(flags | Type3Message.getDefaultFlags(tc, type2));
        if (domain == null || domain.length() == 0) {
            domain = "?";
        }
        if (workstation == null) {
            workstation = tc.getNameServiceClient().getLocalHost().getHostName();
        }
        this.setWorkstation(workstation);
        this.setDomain(domain);
        this.setUser(user);
        if (password == null || password.length() == 0) {
            this.setLMResponse(null);
            this.setNTResponse(null);
            this.setUser(null);
            return;
        }
        switch (tc.getConfig().getLanManCompatibility()) {
            case 0: 
            case 1: {
                if ((this.getFlags() & 0x80000) == 0) {
                    this.setLMResponse(Type3Message.getLMResponse(tc, type2, password));
                    this.setNTResponse(Type3Message.getNTResponse(tc, type2, password));
                    break;
                }
                byte[] clientChallenge = new byte[24];
                tc.getConfig().getRandom().nextBytes(clientChallenge);
                Arrays.fill(clientChallenge, 8, 24, (byte)0);
                byte[] responseKeyNT = NtlmUtil.nTOWFv1(password);
                byte[] ntlm2Response = NtlmUtil.getNTLM2Response(responseKeyNT, type2.getChallenge(), clientChallenge);
                this.setLMResponse(clientChallenge);
                this.setNTResponse(ntlm2Response);
                if ((this.getFlags() & 0x10) != 16) break;
                byte[] sessionNonce = new byte[16];
                System.arraycopy(type2.getChallenge(), 0, sessionNonce, 0, 8);
                System.arraycopy(clientChallenge, 0, sessionNonce, 8, 8);
                MessageDigest md4 = Crypto.getMD4();
                md4.update(responseKeyNT);
                byte[] userSessionKey = md4.digest();
                MessageDigest hmac = Crypto.getHMACT64(userSessionKey);
                hmac.update(sessionNonce);
                byte[] ntlm2SessionKey = hmac.digest();
                if ((this.getFlags() & 0x40000000) != 0) {
                    this.masterKey = new byte[16];
                    tc.getConfig().getRandom().nextBytes(this.masterKey);
                    byte[] exchangedKey = new byte[16];
                    Cipher arcfour = Crypto.getArcfour(ntlm2SessionKey);
                    arcfour.update(this.masterKey, 0, 16, exchangedKey, 0);
                    this.setSessionKey(exchangedKey);
                    break;
                }
                this.masterKey = ntlm2SessionKey;
                break;
            }
            case 2: {
                byte[] nt = Type3Message.getNTResponse(tc, type2, password);
                this.setLMResponse(nt);
                this.setNTResponse(nt);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                byte[] responseKeyNT = NtlmUtil.nTOWFv2(domain, user, password);
                byte[] clientChallenge = new byte[8];
                tc.getConfig().getRandom().nextBytes(clientChallenge);
                this.setLMResponse(Type3Message.getLMv2Response(tc, type2, domain, user, password, clientChallenge));
                byte[] clientChallenge2 = new byte[8];
                tc.getConfig().getRandom().nextBytes(clientChallenge2);
                this.setNTResponse(Type3Message.getNTLMv2Response(tc, type2, responseKeyNT, clientChallenge2));
                if ((this.getFlags() & 0x10) != 16) break;
                MessageDigest hmac = Crypto.getHMACT64(responseKeyNT);
                hmac.update(this.ntResponse, 0, 16);
                byte[] userSessionKey = hmac.digest();
                if ((this.getFlags() & 0x40000000) != 0) {
                    this.masterKey = new byte[16];
                    tc.getConfig().getRandom().nextBytes(this.masterKey);
                    byte[] exchangedKey = new byte[16];
                    Cipher rc4 = Crypto.getArcfour(userSessionKey);
                    rc4.update(this.masterKey, 0, 16, exchangedKey, 0);
                    this.setSessionKey(exchangedKey);
                    break;
                }
                this.masterKey = userSessionKey;
                break;
            }
            default: {
                this.setLMResponse(Type3Message.getLMResponse(tc, type2, password));
                this.setNTResponse(Type3Message.getNTResponse(tc, type2, password));
            }
        }
    }

    public Type3Message(int flags, byte[] lmResponse, byte[] ntResponse, String domain, String user, String workstation) {
        this.setFlags(flags);
        this.setLMResponse(lmResponse);
        this.setNTResponse(ntResponse);
        this.setDomain(domain);
        this.setUser(user);
        this.setWorkstation(workstation);
    }

    public Type3Message(byte[] material) throws IOException {
        this.parse(material);
    }

    public byte[] getLMResponse() {
        return this.lmResponse;
    }

    public void setLMResponse(byte[] lmResponse) {
        this.lmResponse = lmResponse;
    }

    public byte[] getNTResponse() {
        return this.ntResponse;
    }

    public void setNTResponse(byte[] ntResponse) {
        this.ntResponse = ntResponse;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public void setWorkstation(String workstation) {
        this.workstation = workstation;
    }

    public byte[] getMasterKey() {
        return this.masterKey;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(byte[] sessionKey) {
        this.sessionKey = sessionKey;
    }

    @Override
    public byte[] toByteArray() {
        try {
            int flags = this.getFlags();
            boolean unicode = (flags & 1) != 0;
            String oem = unicode ? null : Type3Message.getOEMEncoding();
            String domainName = this.getDomain();
            byte[] domainBytes = null;
            if (domainName != null && domainName.length() != 0) {
                domainBytes = unicode ? domainName.getBytes("UTF-16LE") : domainName.getBytes(oem);
            }
            int domainLength = domainBytes != null ? domainBytes.length : 0;
            String userName = this.getUser();
            byte[] userBytes = null;
            if (userName != null && userName.length() != 0) {
                userBytes = unicode ? userName.getBytes("UTF-16LE") : userName.toUpperCase().getBytes(oem);
            }
            int userLength = userBytes != null ? userBytes.length : 0;
            String workstationName = this.getWorkstation();
            byte[] workstationBytes = null;
            if (workstationName != null && workstationName.length() != 0) {
                workstationBytes = unicode ? workstationName.getBytes("UTF-16LE") : workstationName.toUpperCase().getBytes(oem);
            }
            int workstationLength = workstationBytes != null ? workstationBytes.length : 0;
            byte[] lmResponseBytes = this.getLMResponse();
            int lmLength = lmResponseBytes != null ? lmResponseBytes.length : 0;
            byte[] ntResponseBytes = this.getNTResponse();
            int ntLength = ntResponseBytes != null ? ntResponseBytes.length : 0;
            byte[] sessionKeyBytes = this.getSessionKey();
            int keyLength = sessionKeyBytes != null ? sessionKeyBytes.length : 0;
            byte[] type3 = new byte[64 + domainLength + userLength + workstationLength + lmLength + ntLength + keyLength];
            System.arraycopy(NTLMSSP_SIGNATURE, 0, type3, 0, 8);
            Type3Message.writeULong(type3, 8, 3);
            int offset = 64;
            Type3Message.writeSecurityBuffer(type3, 12, offset, lmResponseBytes);
            Type3Message.writeSecurityBuffer(type3, 20, offset += lmLength, ntResponseBytes);
            Type3Message.writeSecurityBuffer(type3, 28, offset += ntLength, domainBytes);
            Type3Message.writeSecurityBuffer(type3, 36, offset += domainLength, userBytes);
            Type3Message.writeSecurityBuffer(type3, 44, offset += userLength, workstationBytes);
            Type3Message.writeSecurityBuffer(type3, 52, offset += workstationLength, sessionKeyBytes);
            Type3Message.writeULong(type3, 60, flags);
            return type3;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public String toString() {
        String userString = this.getUser();
        String domainString = this.getDomain();
        String workstationString = this.getWorkstation();
        byte[] lmResponseBytes = this.getLMResponse();
        byte[] ntResponseBytes = this.getNTResponse();
        byte[] sessionKeyBytes = this.getSessionKey();
        return "Type3Message[domain=" + domainString + ",user=" + userString + ",workstation=" + workstationString + ",lmResponse=" + (lmResponseBytes == null ? "null" : "<" + lmResponseBytes.length + " bytes>") + ",ntResponse=" + (ntResponseBytes == null ? "null" : "<" + ntResponseBytes.length + " bytes>") + ",sessionKey=" + (sessionKeyBytes == null ? "null" : "<" + sessionKeyBytes.length + " bytes>") + ",flags=0x" + Hexdump.toHexString(this.getFlags(), 8) + "]";
    }

    public static int getDefaultFlags(CIFSContext tc) {
        return 0x200 | (tc.getConfig().isUseUnicode() ? 1 : 2);
    }

    public static int getDefaultFlags(CIFSContext tc, Type2Message type2) {
        if (type2 == null) {
            return Type3Message.getDefaultFlags(tc);
        }
        int flags = 512;
        return flags |= (type2.getFlags() & 1) != 0 ? 1 : 2;
    }

    public static byte[] getLMResponse(CIFSContext tc, Type2Message type2, String password) throws GeneralSecurityException {
        if (type2 == null || password == null) {
            return null;
        }
        return NtlmUtil.getPreNTLMResponse(tc, password, type2.getChallenge());
    }

    public static byte[] getLMv2Response(CIFSContext tc, Type2Message type2, String domain, String user, String password, byte[] clientChallenge) throws GeneralSecurityException {
        if (type2 == null || domain == null || user == null || password == null || clientChallenge == null) {
            return null;
        }
        return NtlmUtil.getLMv2Response(domain, user, password, type2.getChallenge(), clientChallenge);
    }

    public static byte[] getNTLMv2Response(CIFSContext tc, Type2Message type2, byte[] responseKeyNT, byte[] clientChallenge) {
        if (type2 == null || responseKeyNT == null || clientChallenge == null) {
            return null;
        }
        long nanos1601 = (System.currentTimeMillis() + 11644473600000L) * 10000L;
        return NtlmUtil.getNTLMv2Response(responseKeyNT, type2.getChallenge(), clientChallenge, nanos1601, type2.getTargetInformation());
    }

    public static byte[] getNTResponse(CIFSContext tc, Type2Message type2, String password) throws GeneralSecurityException {
        if (type2 == null || password == null) {
            return null;
        }
        return NtlmUtil.getNTLMResponse(password, type2.getChallenge());
    }

    private void parse(byte[] material) throws IOException {
        String charset;
        int flags;
        for (int i = 0; i < 8; ++i) {
            if (material[i] == NTLMSSP_SIGNATURE[i]) continue;
            throw new IOException("Not an NTLMSSP message.");
        }
        if (Type3Message.readULong(material, 8) != 3) {
            throw new IOException("Not a Type 3 message.");
        }
        byte[] lmResponseBytes = Type3Message.readSecurityBuffer(material, 12);
        int lmResponseOffset = Type3Message.readULong(material, 16);
        byte[] ntResponseBytes = Type3Message.readSecurityBuffer(material, 20);
        int ntResponseOffset = Type3Message.readULong(material, 24);
        byte[] domainBytes = Type3Message.readSecurityBuffer(material, 28);
        int domainOffset = Type3Message.readULong(material, 32);
        byte[] userBytes = Type3Message.readSecurityBuffer(material, 36);
        int userOffset = Type3Message.readULong(material, 40);
        byte[] workstationBytes = Type3Message.readSecurityBuffer(material, 44);
        int workstationOffset = Type3Message.readULong(material, 48);
        byte[] _sessionKey = null;
        if (lmResponseOffset == 52 || ntResponseOffset == 52 || domainOffset == 52 || userOffset == 52 || workstationOffset == 52) {
            flags = 514;
            charset = Type3Message.getOEMEncoding();
        } else {
            _sessionKey = Type3Message.readSecurityBuffer(material, 52);
            flags = Type3Message.readULong(material, 60);
            charset = (flags & 1) != 0 ? "UTF-16LE" : Type3Message.getOEMEncoding();
        }
        this.setSessionKey(_sessionKey);
        this.setFlags(flags);
        this.setLMResponse(lmResponseBytes);
        this.setNTResponse(ntResponseBytes);
        this.setDomain(new String(domainBytes, charset));
        this.setUser(new String(userBytes, charset));
        this.setWorkstation(new String(workstationBytes, charset));
    }
}

