/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import jcifs.CIFSContext;
import jcifs.smb.Kerb5Context;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SSPContext;
import jcifs.smb.SmbException;
import jcifs.smb.SmbUnsupportedOperationException;
import jcifs.smb.SpnegoContext;
import jcifs.spnego.NegTokenInit;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Kerb5Authenticator
extends NtlmPasswordAuthentication {
    private static final long serialVersionUID = 1999400043787454432L;
    private static final Logger log = LoggerFactory.getLogger(Kerb5Authenticator.class);
    private static final String DEFAULT_SERVICE = "cifs";
    private Subject subject = null;
    private String user = null;
    private String realm = null;
    private String service = "cifs";
    private int userLifetime = 0;
    private int contextLifetime = 0;
    private boolean canFallback = false;

    public Kerb5Authenticator(CIFSContext tc, Subject subject) {
        super(tc);
        this.subject = subject;
    }

    public Kerb5Authenticator(CIFSContext tc, Subject subject, String domain, String username, String password) {
        super(tc, domain, username, password);
        this.canFallback = true;
        this.subject = subject;
    }

    @Override
    public SSPContext createContext(CIFSContext tc, String targetDomain, String host, byte[] initialToken, boolean doSigning) throws SmbException {
        if (host.indexOf(46) < 0 && host.toUpperCase(Locale.ROOT).equals(host)) {
            throw new SmbUnsupportedOperationException("Cannot use netbios/short names with kerberos authentication, have " + host);
        }
        try {
            NegTokenInit tok = new NegTokenInit(initialToken);
            if (log.isDebugEnabled()) {
                log.debug("Have initial token " + tok);
            }
            if (tok.getMechanisms() != null) {
                HashSet<Oid> mechs = new HashSet<Oid>(Arrays.asList(tok.getMechanisms()));
                boolean foundKerberos = false;
                for (Oid mech : Kerb5Context.SUPPORTED_MECHS) {
                    foundKerberos |= mechs.contains(mech);
                }
                if (!foundKerberos && this.canFallback && tc.getConfig().isAllowNTLMFallback()) {
                    log.debug("Falling back to NTLM authentication");
                    return super.createContext(tc, targetDomain, host, initialToken, doSigning);
                }
                if (!foundKerberos) {
                    throw new SmbUnsupportedOperationException("Server does not support kerberos authentication");
                }
            }
        }
        catch (IOException e1) {
            log.debug("Ignoring invalid initial token", (Throwable)e1);
        }
        try {
            return this.createContext(targetDomain, host);
        }
        catch (GSSException e) {
            throw new SmbException("Context setup failed", (Throwable)e);
        }
    }

    @Override
    public Kerb5Authenticator clone() {
        Kerb5Authenticator auth = new Kerb5Authenticator(this.getContext(), this.getSubject());
        Kerb5Authenticator.cloneInternal(auth, this);
        return auth;
    }

    public static void cloneInternal(Kerb5Authenticator to, Kerb5Authenticator from) {
        NtlmPasswordAuthentication.cloneInternal(to, from);
        to.setUser(from.getUser());
        to.setRealm(from.getRealm());
        to.setService(from.getService());
        to.setLifeTime(from.getLifeTime());
        to.setUserLifeTime(from.getUserLifeTime());
    }

    public void setUser(String name) {
        this.user = name;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    public String getUser() {
        return this.user;
    }

    public void setService(String name) {
        this.service = name;
    }

    public String getService() {
        return this.service;
    }

    public int getUserLifeTime() {
        return this.userLifetime;
    }

    public void setUserLifeTime(int time) {
        this.userLifetime = time;
    }

    public int getLifeTime() {
        return this.contextLifetime;
    }

    public void setLifeTime(int time) {
        this.contextLifetime = time;
    }

    @Override
    public boolean isAnonymous() {
        return this.getSubject() == null && super.isAnonymous();
    }

    @Override
    public String toString() {
        return "Kerb5Authenticatior[subject=" + (this.getSubject() != null ? this.getSubject().getPrincipals() : null) + ",user=" + this.user + ",realm=" + this.realm + "]";
    }

    private SpnegoContext createContext(String targetDomain, String host) throws GSSException {
        return new SpnegoContext(new Kerb5Context(host, this.service, this.user, this.userLifetime, this.contextLifetime, targetDomain != null ? targetDomain.toUpperCase(Locale.ROOT) : null));
    }

    @Override
    public boolean equals(Object other) {
        if (other != null && other instanceof Kerb5Authenticator) {
            return Objects.equals(this.getSubject(), ((Kerb5Authenticator)other).getSubject());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String getUserDomain() {
        if (this.realm == null && this.getSubject() != null) {
            Set<Principal> pr = this.getSubject().getPrincipals();
            Iterator<Principal> ite = pr.iterator();
            while (ite.hasNext()) {
                try {
                    KerberosPrincipal entry = (KerberosPrincipal)ite.next();
                    return entry.getRealm();
                }
                catch (Exception e) {
                }
            }
        }
        if (this.realm != null) {
            return this.realm;
        }
        return super.getUserDomain();
    }
}

