/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Key;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import jcifs.smb.MIEName;
import jcifs.smb.SSPContext;
import jcifs.smb.SmbException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Kerb5Context
implements SSPContext {
    private static final Logger log;
    private static Oid KRB5_MECH_OID;
    private static Oid KRB5_MS_MECH_OID;
    private static Oid KRB5_NAME_OID;
    static Oid[] SUPPORTED_MECHS;
    private GSSContext gssContext;
    private GSSName clientName;
    private GSSName serviceName;
    private static final String OPENJDK_JGSS_INQUIRE_TYPE_CLASS = "com.sun.security.jgss.InquireType";
    private static final String OPENJDK_JGSS_EXT_GSSCTX_CLASS = "com.sun.security.jgss.ExtendedGSSContext";
    private static final String IBM_JGSS_INQUIRE_TYPE_CLASS = "com.ibm.security.jgss.InquireType";
    private static final String IBM_JGSS_EXT_GSSCTX_CLASS = "com.ibm.security.jgss.ExtendedGSSContext";
    private static final Class<?> extendedGSSContextClass;
    private static final Method inquireSecContext;
    private static final Object inquireTypeSessionKey;

    Kerb5Context(String host, String service, String name, int userLifetime, int contextLifetime, String realm) throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        GSSCredential clientCreds = null;
        this.serviceName = realm != null ? manager.createName(service + "/" + host + "@" + realm, KRB5_NAME_OID, KRB5_MECH_OID) : manager.createName(service + "@" + host, GSSName.NT_HOSTBASED_SERVICE, KRB5_MECH_OID);
        if (log.isDebugEnabled()) {
            log.debug("Service name is " + this.serviceName);
        }
        if (name != null) {
            this.clientName = manager.createName(name, GSSName.NT_USER_NAME, KRB5_MECH_OID);
            clientCreds = manager.createCredential(this.clientName, userLifetime, KRB5_MECH_OID, 1);
        }
        this.gssContext = manager.createContext(this.serviceName, KRB5_MECH_OID, clientCreds, contextLifetime);
        this.gssContext.requestAnonymity(false);
        this.gssContext.requestSequenceDet(false);
        this.gssContext.requestConf(false);
        this.gssContext.requestInteg(false);
        this.gssContext.requestReplayDet(false);
        this.gssContext.requestMutualAuth(true);
        this.gssContext.requestCredDeleg(true);
    }

    @Override
    public boolean isSupported(Oid mechanism) {
        return KRB5_MECH_OID.equals(mechanism) || KRB5_MS_MECH_OID.equals(mechanism);
    }

    @Override
    public Oid[] getSupportedMechs() {
        return SUPPORTED_MECHS;
    }

    @Override
    public int getFlags() {
        int contextFlags = 0;
        if (this.gssContext.getCredDelegState()) {
            contextFlags |= 0x40;
        }
        if (this.gssContext.getMutualAuthState()) {
            contextFlags |= 0x20;
        }
        if (this.gssContext.getReplayDetState()) {
            contextFlags |= 0x10;
        }
        if (this.gssContext.getSequenceDetState()) {
            contextFlags |= 8;
        }
        if (this.gssContext.getAnonymityState()) {
            contextFlags |= 4;
        }
        if (this.gssContext.getConfState()) {
            contextFlags |= 2;
        }
        if (this.gssContext.getIntegState()) {
            contextFlags |= 1;
        }
        return contextFlags;
    }

    @Override
    public boolean isEstablished() {
        return this.gssContext != null && this.gssContext.isEstablished();
    }

    @Override
    public String getNetbiosName() {
        return null;
    }

    @Override
    public byte[] getSigningKey() throws SmbException {
        if (extendedGSSContextClass == null || inquireSecContext == null || inquireTypeSessionKey == null) {
            throw new SmbException("ExtendedGSSContext support not available from JRE");
        }
        if (extendedGSSContextClass.isAssignableFrom(this.gssContext.getClass())) {
            try {
                Key k = (Key)inquireSecContext.invoke((Object)this.gssContext, inquireTypeSessionKey);
                return k.getEncoded();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new SmbException("Failed to query Kerberos session key from ExtendedGSSContext", (Throwable)ex);
            }
        }
        throw new SmbException("ExtendedGSSContext is not implemented by GSSContext");
    }

    @Override
    public byte[] initSecContext(byte[] token, int off, int len) throws SmbException {
        try {
            return this.gssContext.initSecContext(token, off, len);
        }
        catch (GSSException e) {
            throw new SmbException("GSSAPI mechanism failed", (Throwable)e);
        }
    }

    Key searchSessionKey(Subject subject) throws GSSException {
        MIEName src = new MIEName(this.gssContext.getSrcName().export());
        MIEName targ = new MIEName(this.gssContext.getTargName().export());
        for (KerberosTicket ticket : subject.getPrivateCredentials(KerberosTicket.class)) {
            MIEName client = new MIEName(this.gssContext.getMech(), ticket.getClient().getName());
            MIEName server = new MIEName(this.gssContext.getMech(), ticket.getServer().getName());
            if (!src.equals(client) || !targ.equals(server)) continue;
            return ticket.getSessionKey();
        }
        return null;
    }

    public String toString() {
        if (this.gssContext == null || !this.gssContext.isEstablished()) {
            return String.format("KERB5[src=%s,targ=%s]", this.clientName, this.serviceName);
        }
        try {
            return String.format("KERB5[src=%s,targ=%s,mech=%s]", this.gssContext.getSrcName(), this.gssContext.getTargName(), this.gssContext.getMech());
        }
        catch (GSSException e) {
            log.debug("Failed to get info", (Throwable)e);
            return super.toString();
        }
    }

    @Override
    public void dispose() throws SmbException {
        if (this.gssContext != null) {
            try {
                this.gssContext.dispose();
            }
            catch (GSSException e) {
                throw new SmbException("Context disposal failed", (Throwable)e);
            }
        }
    }

    private static <T extends Enum<T>> Object getSessionKeyInquireType(Class<?> inquireTypeClass) {
        return Enum.valueOf(inquireTypeClass, "KRB5_GET_SESSION_KEY");
    }

    static {
        Object inquireTypeSessionKeyPrep;
        Method inquireSecContextPrep;
        Class<?> extendedGSSContextClassPrep;
        block9: {
            Class<?> inquireTypeClass;
            block8: {
                log = LoggerFactory.getLogger(Kerb5Context.class);
                try {
                    KRB5_MECH_OID = new Oid("1.2.840.113554.1.2.2");
                    KRB5_MS_MECH_OID = new Oid("1.2.840.48018.1.2.2");
                    KRB5_NAME_OID = new Oid("1.2.840.113554.1.2.2.1");
                    SUPPORTED_MECHS = new Oid[]{KRB5_MECH_OID, KRB5_MS_MECH_OID};
                }
                catch (GSSException e) {
                    log.error("Failed to initialize kerberos OIDs");
                }
                extendedGSSContextClassPrep = null;
                inquireSecContextPrep = null;
                inquireTypeSessionKeyPrep = null;
                try {
                    extendedGSSContextClassPrep = Class.forName(OPENJDK_JGSS_EXT_GSSCTX_CLASS);
                    inquireTypeClass = Class.forName(OPENJDK_JGSS_INQUIRE_TYPE_CLASS);
                    inquireTypeSessionKeyPrep = Kerb5Context.getSessionKeyInquireType(inquireTypeClass);
                    inquireSecContextPrep = extendedGSSContextClassPrep.getMethod("inquireSecContext", inquireTypeClass);
                }
                catch (ClassNotFoundException | NoSuchMethodException | RuntimeException ex) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug("Failed to initalize ExtendedGSSContext initializdation for OracleJDK / OpenJDK", (Throwable)ex);
                }
            }
            if (extendedGSSContextClassPrep == null || inquireSecContextPrep == null || inquireTypeSessionKeyPrep == null) {
                try {
                    extendedGSSContextClassPrep = Class.forName(IBM_JGSS_EXT_GSSCTX_CLASS);
                    inquireTypeClass = Class.forName(IBM_JGSS_INQUIRE_TYPE_CLASS);
                    inquireTypeSessionKeyPrep = Kerb5Context.getSessionKeyInquireType(inquireTypeClass);
                    inquireSecContextPrep = extendedGSSContextClassPrep.getMethod("inquireSecContext", inquireTypeClass);
                }
                catch (ClassNotFoundException | NoSuchMethodException | RuntimeException ex) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug("Failed to initalize ExtendedGSSContext initializdation for IBM JDK", (Throwable)ex);
                }
            }
        }
        extendedGSSContextClass = extendedGSSContextClassPrep;
        inquireSecContext = inquireSecContextPrep;
        inquireTypeSessionKey = inquireTypeSessionKeyPrep;
        if (extendedGSSContextClass != null && inquireSecContext != null && inquireTypeSessionKey != null && log.isDebugEnabled()) {
            log.debug("Found ExtendedGSSContext implementation: " + extendedGSSContextClass.getName());
        }
    }
}

