/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.CIFSContext;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SSPContext;
import jcifs.smb.SmbException;
import jcifs.util.Hexdump;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmContext
implements SSPContext {
    private static final Logger log = LoggerFactory.getLogger(NtlmContext.class);
    private static Oid NTLMSSP_OID;
    private NtlmPasswordAuthentication auth;
    private int ntlmsspFlags;
    private String workstation;
    private boolean isEstablished = false;
    private byte[] serverChallenge = null;
    private byte[] signingKey = null;
    private String netbiosName = null;
    int state = 1;
    private CIFSContext transportContext;

    public NtlmContext(CIFSContext tc, NtlmPasswordAuthentication auth, boolean doSigning) {
        this.transportContext = tc;
        this.auth = auth;
        this.ntlmsspFlags = this.ntlmsspFlags | 4 | 0x80000 | 0x20000000;
        if (doSigning) {
            this.ntlmsspFlags |= 0x40008010;
        }
        this.workstation = tc.getNameServiceClient().getLocalHost().getHostName();
    }

    @Override
    public Oid[] getSupportedMechs() {
        return new Oid[]{NTLMSSP_OID};
    }

    public String toString() {
        String ret = "NtlmContext[auth=" + this.auth + ",ntlmsspFlags=0x" + Hexdump.toHexString(this.ntlmsspFlags, 8) + ",workstation=" + this.workstation + ",isEstablished=" + this.isEstablished + ",state=" + this.state + ",serverChallenge=";
        ret = this.serverChallenge == null ? ret + "null" : ret + Hexdump.toHexString(this.serverChallenge, 0, this.serverChallenge.length * 2);
        ret = ret + ",signingKey=";
        ret = this.signingKey == null ? ret + "null" : ret + Hexdump.toHexString(this.signingKey, 0, this.signingKey.length * 2);
        ret = ret + "]";
        return ret;
    }

    @Override
    public int getFlags() {
        return 0;
    }

    @Override
    public boolean isSupported(Oid mechanism) {
        return NTLMSSP_OID.equals(mechanism);
    }

    @Override
    public boolean isEstablished() {
        return this.isEstablished;
    }

    public byte[] getServerChallenge() {
        return this.serverChallenge;
    }

    @Override
    public byte[] getSigningKey() {
        return this.signingKey;
    }

    @Override
    public String getNetbiosName() {
        return this.netbiosName;
    }

    @Override
    public byte[] initSecContext(byte[] token, int offset, int len) throws SmbException {
        switch (this.state) {
            case 1: {
                Type1Message msg1 = new Type1Message(this.transportContext, this.ntlmsspFlags, this.auth.getUserDomain(), this.workstation);
                token = msg1.toByteArray();
                if (log.isTraceEnabled()) {
                    log.trace(msg1.toString());
                    log.trace(Hexdump.toHexString(token, 0, token.length));
                }
                ++this.state;
                break;
            }
            case 2: {
                try {
                    Type2Message msg2 = new Type2Message(token);
                    if (log.isTraceEnabled()) {
                        log.trace(msg2.toString());
                        log.trace(Hexdump.toHexString(token, 0, token.length));
                    }
                    this.serverChallenge = msg2.getChallenge();
                    this.ntlmsspFlags &= msg2.getFlags() | 0x10 | 0x8000 | 0x20;
                    Type3Message msg3 = new Type3Message(this.transportContext, msg2, this.auth.getPassword(), this.auth.getUserDomain(), this.auth.getUsername(), this.workstation, this.ntlmsspFlags);
                    token = msg3.toByteArray();
                    if (log.isTraceEnabled()) {
                        log.trace(msg3.toString());
                        log.trace(Hexdump.toHexString(token, 0, token.length));
                    }
                    if ((this.ntlmsspFlags & 0x10) != 0) {
                        this.signingKey = msg3.getMasterKey();
                    }
                    this.isEstablished = true;
                    ++this.state;
                    break;
                }
                catch (Exception e) {
                    throw new SmbException(e.getMessage(), (Throwable)e);
                }
            }
            default: {
                throw new SmbException("Invalid state");
            }
        }
        return token;
    }

    @Override
    public void dispose() throws SmbException {
        this.isEstablished = false;
    }

    static {
        try {
            NTLMSSP_OID = new Oid("1.3.6.1.4.1.311.2.2.10");
        }
        catch (GSSException e) {
            log.error("Failed to parse OID", (Throwable)e);
        }
    }
}

