/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.Subject;
import jcifs.CIFSContext;
import jcifs.Credentials;
import jcifs.RuntimeCIFSException;
import jcifs.smb.CredentialsInternal;
import jcifs.smb.NtlmContext;
import jcifs.smb.NtlmUtil;
import jcifs.smb.SSPContext;
import jcifs.smb.SmbException;
import jcifs.util.Crypto;
import jcifs.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmPasswordAuthentication
implements Principal,
CredentialsInternal,
Serializable {
    private static final long serialVersionUID = -2832037191318016836L;
    private static final Logger log = LoggerFactory.getLogger(NtlmPasswordAuthentication.class);
    private String domain;
    private String username;
    private String password;
    private byte[] ansiHash;
    private byte[] unicodeHash;
    private boolean hashesExternal = false;
    private byte[] clientChallenge = null;
    private boolean nullAuth;
    private CIFSContext context;

    private NtlmPasswordAuthentication() {
    }

    @Override
    public <T extends Credentials> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public NtlmPasswordAuthentication(CIFSContext tc, String domain, String username, String password) {
        this.context = tc;
        if (username != null) {
            int ci = username.indexOf(64);
            if (ci > 0) {
                domain = username.substring(ci + 1);
                username = username.substring(0, ci);
            } else {
                ci = username.indexOf(92);
                if (ci > 0) {
                    domain = username.substring(0, ci);
                    username = username.substring(ci + 1);
                }
            }
        }
        this.domain = domain;
        this.username = username;
        this.password = password;
        this.setupDefaults(tc);
    }

    public NtlmPasswordAuthentication(String domain, String username, byte[] challenge, byte[] ansiHash, byte[] unicodeHash) {
        if (domain == null || username == null || ansiHash == null || unicodeHash == null) {
            throw new IllegalArgumentException("External credentials cannot be null");
        }
        this.domain = domain;
        this.username = username;
        this.password = null;
        this.ansiHash = ansiHash;
        this.unicodeHash = unicodeHash;
        this.hashesExternal = true;
    }

    public NtlmPasswordAuthentication(CIFSContext tc) {
        this(tc, "", "", "");
    }

    public NtlmPasswordAuthentication(CIFSContext tc, String userInfo) {
        this.password = null;
        this.username = null;
        this.domain = null;
        if (userInfo != null) {
            int i;
            try {
                userInfo = NtlmPasswordAuthentication.unescape(userInfo);
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeCIFSException(uee);
            }
            int end = userInfo.length();
            int u = 0;
            for (i = 0; i < end; ++i) {
                char c = userInfo.charAt(i);
                if (c == ';') {
                    this.domain = userInfo.substring(0, i);
                    u = i + 1;
                    continue;
                }
                if (c != ':') continue;
                this.password = userInfo.substring(i + 1);
                break;
            }
            this.username = userInfo.substring(u, i);
        }
        this.setupDefaults(tc);
    }

    protected CIFSContext getContext() {
        return this.context;
    }

    @Override
    public Subject getSubject() {
        return null;
    }

    @Override
    public SSPContext createContext(CIFSContext transportContext, String targetDomain, String host, byte[] initialToken, boolean doSigning) throws SmbException {
        return new NtlmContext(transportContext, this, doSigning);
    }

    @Override
    public NtlmPasswordAuthentication clone() {
        NtlmPasswordAuthentication cloned = new NtlmPasswordAuthentication();
        NtlmPasswordAuthentication.cloneInternal(cloned, this);
        return cloned;
    }

    protected static void cloneInternal(NtlmPasswordAuthentication to, NtlmPasswordAuthentication from) {
        to.domain = from.domain;
        to.username = from.username;
        to.password = from.password;
        to.nullAuth = from.nullAuth;
        if (from.hashesExternal) {
            to.hashesExternal = true;
            to.ansiHash = from.ansiHash != null ? Arrays.copyOf(from.ansiHash, from.ansiHash.length) : null;
            to.unicodeHash = from.unicodeHash != null ? Arrays.copyOf(from.unicodeHash, from.unicodeHash.length) : null;
        }
    }

    private void setupDefaults(CIFSContext tc) {
        if (this.domain == null) {
            this.domain = tc.getConfig().getDefaultDomain();
        }
        if (this.username == null) {
            String string = this.username = tc.getConfig().getDefaultUsername() != null ? tc.getConfig().getDefaultUsername() : "GUEST";
        }
        if (this.password == null) {
            this.password = tc.getConfig().getDefaultPassword() != null ? tc.getConfig().getDefaultPassword() : "";
        }
    }

    @Override
    public String getUserDomain() {
        return this.domain;
    }

    public String getSpecifiedUserDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getName() {
        boolean d = this.domain != null && this.domain.length() > 0;
        return d ? this.domain + "\\" + this.username : this.username;
    }

    public byte[] getAnsiHash(CIFSContext tc, byte[] chlng) throws GeneralSecurityException {
        if (this.hashesExternal) {
            return this.ansiHash;
        }
        switch (tc.getConfig().getLanManCompatibility()) {
            case 0: 
            case 1: {
                return NtlmUtil.getPreNTLMResponse(tc, this.password, chlng);
            }
            case 2: {
                return NtlmUtil.getNTLMResponse(this.password, chlng);
            }
            case 3: 
            case 4: 
            case 5: {
                if (this.clientChallenge == null) {
                    this.clientChallenge = new byte[8];
                    tc.getConfig().getRandom().nextBytes(this.clientChallenge);
                }
                return NtlmUtil.getLMv2Response(this.domain, this.username, this.password, chlng, this.clientChallenge);
            }
        }
        return NtlmUtil.getPreNTLMResponse(tc, this.password, chlng);
    }

    public byte[] getUnicodeHash(CIFSContext tc, byte[] chlng) throws GeneralSecurityException {
        if (this.hashesExternal) {
            return this.unicodeHash;
        }
        switch (tc.getConfig().getLanManCompatibility()) {
            case 0: 
            case 1: 
            case 2: {
                return NtlmUtil.getNTLMResponse(this.password, chlng);
            }
            case 3: 
            case 4: 
            case 5: {
                return new byte[0];
            }
        }
        return NtlmUtil.getNTLMResponse(this.password, chlng);
    }

    public byte[] getSigningKey(CIFSContext tc, byte[] chlng) throws SmbException, GeneralSecurityException {
        switch (tc.getConfig().getLanManCompatibility()) {
            case 0: 
            case 1: 
            case 2: {
                byte[] signingKey = new byte[40];
                this.getUserSessionKey(tc, chlng, signingKey, 0);
                System.arraycopy(this.getUnicodeHash(tc, chlng), 0, signingKey, 16, 24);
                return signingKey;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new SmbException("NTLMv2 requires extended security (jcifs.smb.client.useExtendedSecurity must be true if jcifs.smb.lmCompatibility >= 3)");
            }
        }
        return null;
    }

    public byte[] getUserSessionKey(CIFSContext tc, byte[] chlng) {
        if (this.hashesExternal) {
            return null;
        }
        byte[] key = new byte[16];
        try {
            this.getUserSessionKey(tc, chlng, key, 0);
        }
        catch (Exception ex) {
            log.error("Failed to get session key", (Throwable)ex);
        }
        return key;
    }

    public void getUserSessionKey(CIFSContext tc, byte[] chlng, byte[] dest, int offset) throws SmbException {
        if (this.hashesExternal) {
            return;
        }
        try {
            MessageDigest md4 = Crypto.getMD4();
            md4.update(Strings.getUNIBytes(this.password));
            switch (tc.getConfig().getLanManCompatibility()) {
                case 0: 
                case 1: 
                case 2: {
                    md4.update(md4.digest());
                    md4.digest(dest, offset, 16);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (this.clientChallenge == null) {
                        this.clientChallenge = new byte[8];
                        tc.getConfig().getRandom().nextBytes(this.clientChallenge);
                    }
                    MessageDigest hmac = Crypto.getHMACT64(md4.digest());
                    hmac.update(Strings.getUNIBytes(this.username.toUpperCase()));
                    hmac.update(Strings.getUNIBytes(this.domain.toUpperCase()));
                    byte[] ntlmv2Hash = hmac.digest();
                    hmac = Crypto.getHMACT64(ntlmv2Hash);
                    hmac.update(chlng);
                    hmac.update(this.clientChallenge);
                    MessageDigest userKey = Crypto.getHMACT64(ntlmv2Hash);
                    userKey.update(hmac.digest());
                    userKey.digest(dest, offset, 16);
                    break;
                }
                default: {
                    md4.update(md4.digest());
                    md4.digest(dest, offset, 16);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new SmbException("", (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NtlmPasswordAuthentication) {
            String domB;
            NtlmPasswordAuthentication ntlm = (NtlmPasswordAuthentication)obj;
            String domA = ntlm.getUserDomain() != null ? ntlm.getUserDomain().toUpperCase() : null;
            String string = domB = this.getUserDomain() != null ? this.getUserDomain().toUpperCase() : null;
            if (Objects.equals(domA, domB) && ntlm.getUsername().equalsIgnoreCase(this.getUsername())) {
                if (this.areHashesExternal() && ntlm.areHashesExternal()) {
                    return Arrays.equals(this.ansiHash, ntlm.ansiHash) && Arrays.equals(this.unicodeHash, ntlm.unicodeHash);
                }
                if (!this.areHashesExternal() && this.getPassword().equals(ntlm.getPassword())) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().toUpperCase().hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isAnonymous() {
        return !(this.getUserDomain() != null && !this.getUserDomain().isEmpty() || !this.getUsername().isEmpty() && !this.isGuest() || !this.getPassword().isEmpty());
    }

    @Override
    public boolean isGuest() {
        return "GUEST".equalsIgnoreCase(this.getUsername());
    }

    static String unescape(String str) throws NumberFormatException, UnsupportedEncodingException {
        byte[] b = new byte[1];
        if (str == null) {
            return null;
        }
        int len = str.length();
        char[] out = new char[len];
        int state = 0;
        int j = 0;
        block4: for (int i = 0; i < len; ++i) {
            switch (state) {
                case 0: {
                    char ch = str.charAt(i);
                    if (ch == '%') {
                        state = 1;
                        continue block4;
                    }
                    out[j++] = ch;
                    continue block4;
                }
                case 1: {
                    b[0] = (byte)(Integer.parseInt(str.substring(i, i + 2), 16) & 0xFF);
                    out[j++] = new String(b, 0, 1, "ASCII").charAt(0);
                    ++i;
                    state = 0;
                }
            }
        }
        return new String(out, 0, j);
    }

    public boolean areHashesExternal() {
        return this.hashesExternal;
    }
}

