/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Arrays;
import jcifs.CIFSException;
import jcifs.smb.DosError;
import jcifs.smb.NtStatus;
import jcifs.smb.WinError;
import jcifs.util.Hexdump;

public class SmbException
extends CIFSException
implements NtStatus,
DosError,
WinError {
    private static final long serialVersionUID = 484863569441792249L;
    private int status;

    public static String getMessageByCode(int errcode) {
        if (errcode == 0) {
            return "NT_STATUS_SUCCESS";
        }
        if ((errcode & 0xC0000000) == -1073741824) {
            int found = Arrays.binarySearch(NT_STATUS_CODES, errcode);
            if (found >= 0 && NT_STATUS_CODES[found] == errcode) {
                return NT_STATUS_MESSAGES[found];
            }
        } else {
            int min = 0;
            int max = DOS_ERROR_CODES.length - 1;
            while (max >= min) {
                int mid = (min + max) / 2;
                if (errcode > DOS_ERROR_CODES[mid][0]) {
                    min = mid + 1;
                    continue;
                }
                if (errcode < DOS_ERROR_CODES[mid][0]) {
                    max = mid - 1;
                    continue;
                }
                return DOS_ERROR_MESSAGES[mid];
            }
        }
        return "0x" + Hexdump.toHexString(errcode, 8);
    }

    static int getStatusByCode(int errcode) {
        if ((errcode & 0xC0000000) != 0) {
            return errcode;
        }
        int min = 0;
        int max = DOS_ERROR_CODES.length - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            if (errcode > DOS_ERROR_CODES[mid][0]) {
                min = mid + 1;
                continue;
            }
            if (errcode < DOS_ERROR_CODES[mid][0]) {
                max = mid - 1;
                continue;
            }
            return DOS_ERROR_CODES[mid][1];
        }
        return -1073741823;
    }

    static String getMessageByWinerrCode(int errcode) {
        int min = 0;
        int max = WINERR_CODES.length - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            if (errcode > WINERR_CODES[mid]) {
                min = mid + 1;
                continue;
            }
            if (errcode < WINERR_CODES[mid]) {
                max = mid - 1;
                continue;
            }
            return WINERR_MESSAGES[mid];
        }
        return "W" + Hexdump.toHexString(errcode, 8);
    }

    public SmbException() {
    }

    public SmbException(int errcode, Throwable rootCause) {
        super(SmbException.getMessageByCode(errcode), rootCause);
        this.status = SmbException.getStatusByCode(errcode);
    }

    public SmbException(String msg) {
        super(msg);
        this.status = -1073741823;
    }

    public SmbException(String msg, Throwable rootCause) {
        super(msg, rootCause);
        this.status = -1073741823;
    }

    public SmbException(int errcode, boolean winerr) {
        super(winerr ? SmbException.getMessageByWinerrCode(errcode) : SmbException.getMessageByCode(errcode));
        this.status = winerr ? errcode : SmbException.getStatusByCode(errcode);
    }

    public int getNtStatus() {
        return this.status;
    }

    @Deprecated
    public Throwable getRootCause() {
        return this.getCause();
    }

    static SmbException wrap(CIFSException e) {
        if (e instanceof SmbException) {
            return (SmbException)e;
        }
        return new SmbException(e.getMessage(), (Throwable)e);
    }
}

