/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import jcifs.smb.SSPContext;
import jcifs.smb.SmbException;
import jcifs.spnego.NegTokenInit;
import jcifs.spnego.NegTokenTarg;
import jcifs.spnego.SpnegoToken;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpnegoContext
implements SSPContext {
    private static final Logger log = LoggerFactory.getLogger(SpnegoContext.class);
    private static Oid SPNEGO_MECH_OID;
    private SSPContext mechContext;
    private Oid[] mechs;
    private boolean firstResponse;

    SpnegoContext(SSPContext source) {
        this(source, source.getSupportedMechs());
    }

    SpnegoContext(SSPContext source, Oid[] mech) {
        this.mechContext = source;
        this.mechs = mech;
    }

    @Override
    public Oid[] getSupportedMechs() {
        return new Oid[]{SPNEGO_MECH_OID};
    }

    @Override
    public int getFlags() {
        return this.mechContext.getFlags();
    }

    @Override
    public boolean isSupported(Oid mechanism) {
        return false;
    }

    Oid[] getMechs() {
        return this.mechs;
    }

    void setMechs(Oid[] mechs) {
        this.mechs = mechs;
    }

    @Override
    public String getNetbiosName() {
        return null;
    }

    @Override
    public byte[] getSigningKey() throws SmbException {
        return this.mechContext.getSigningKey();
    }

    @Override
    public byte[] initSecContext(byte[] inputBuf, int offset, int len) throws SmbException {
        if (len == 0) {
            return this.initialToken();
        }
        return this.negotitate(inputBuf, offset, len);
    }

    private byte[] negotitate(byte[] inputBuf, int offset, int len) throws SmbException {
        try {
            SpnegoToken spToken = SpnegoContext.getToken(inputBuf, offset, len);
            if (this.firstResponse && spToken instanceof NegTokenTarg) {
                NegTokenTarg targ = (NegTokenTarg)spToken;
                if (!this.mechContext.isSupported(targ.getMechanism())) {
                    throw new SmbException("Server chose an unsupported mechanism " + targ.getMechanism());
                }
                this.firstResponse = false;
            }
            Oid currentMech = null;
            byte[] mechToken = spToken.getMechanismToken();
            if (mechToken == null) {
                return this.initialToken();
            }
            if ((mechToken = this.mechContext.initSecContext(mechToken, 0, mechToken.length)) != null) {
                int result = 1;
                byte[] mechMIC = null;
                if (spToken instanceof NegTokenTarg) {
                    NegTokenTarg targ = (NegTokenTarg)spToken;
                    if (targ.getResult() == 0 && this.mechContext.isEstablished()) {
                        result = 0;
                        if (targ.getMechanism() != null) {
                            currentMech = targ.getMechanism();
                        }
                        mechMIC = targ.getMechanismListMIC();
                    } else if (targ.getResult() == 2) {
                        throw new SmbException("SPNEGO mechanism was rejected");
                    }
                }
                return new NegTokenTarg(result, null, mechToken, mechMIC).toByteArray();
            }
            return null;
        }
        catch (GSSException e) {
            throw new SmbException("SPNEGO mechanism failed", (Throwable)e);
        }
    }

    private byte[] initialToken() throws SmbException {
        byte[] mechToken = this.mechContext.initSecContext(new byte[0], 0, 0);
        return new NegTokenInit(this.mechs, this.mechContext.getFlags(), mechToken, null).toByteArray();
    }

    @Override
    public boolean isEstablished() {
        return this.mechContext.isEstablished();
    }

    private static SpnegoToken getToken(byte[] token, int off, int len) throws GSSException {
        byte[] b = new byte[len];
        if (off == 0 && token.length == len) {
            b = token;
        } else {
            System.arraycopy(token, off, b, 0, len);
        }
        return SpnegoContext.getToken(b);
    }

    private static SpnegoToken getToken(byte[] token) throws GSSException {
        SpnegoToken spnegoToken = null;
        try {
            switch (token[0]) {
                case 96: {
                    spnegoToken = new NegTokenInit(token);
                    break;
                }
                case -95: {
                    spnegoToken = new NegTokenTarg(token);
                    break;
                }
                default: {
                    throw new GSSException(10);
                }
            }
            return spnegoToken;
        }
        catch (IOException e) {
            throw new GSSException(11);
        }
    }

    public String toString() {
        return "SPNEGO[" + this.mechContext + "]";
    }

    @Override
    public void dispose() throws SmbException {
        this.mechContext.dispose();
    }

    static {
        try {
            SPNEGO_MECH_OID = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException e) {
            log.error("Failed to initialize OID", (Throwable)e);
        }
    }
}

