/*
 * Decompiled with CFR 0.152.
 */
package jcifs.spnego;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import jcifs.spnego.SpnegoToken;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class NegTokenTarg
extends SpnegoToken {
    public static final int UNSPECIFIED_RESULT = -1;
    public static final int ACCEPT_COMPLETED = 0;
    public static final int ACCEPT_INCOMPLETE = 1;
    public static final int REJECTED = 2;
    private Oid mechanism;
    private int result = -1;

    public NegTokenTarg() {
    }

    public NegTokenTarg(int result, Oid mechanism, byte[] mechanismToken, byte[] mechanismListMIC) {
        this.setResult(result);
        this.setMechanism(mechanism);
        this.setMechanismToken(mechanismToken);
        this.setMechanismListMIC(mechanismListMIC);
    }

    public NegTokenTarg(byte[] token) throws IOException {
        this.parse(token);
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public Oid getMechanism() {
        return this.mechanism;
    }

    public void setMechanism(Oid mechanism) {
        this.mechanism = mechanism;
    }

    @Override
    public byte[] toByteArray() {
        try {
            byte[] mechanismListMIC;
            byte[] mechanismToken;
            Oid mech;
            ByteArrayOutputStream collector = new ByteArrayOutputStream();
            DEROutputStream der = new DEROutputStream((OutputStream)collector);
            ASN1EncodableVector fields = new ASN1EncodableVector();
            int res = this.getResult();
            if (res != -1) {
                fields.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new ASN1Enumerated(res)));
            }
            if ((mech = this.getMechanism()) != null) {
                fields.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)ASN1ObjectIdentifier.getInstance((Object)mech.getDER())));
            }
            if ((mechanismToken = this.getMechanismToken()) != null) {
                fields.add((ASN1Encodable)new DERTaggedObject(true, 2, (ASN1Encodable)new DEROctetString(mechanismToken)));
            }
            if ((mechanismListMIC = this.getMechanismListMIC()) != null) {
                fields.add((ASN1Encodable)new DERTaggedObject(true, 3, (ASN1Encodable)new DEROctetString(mechanismListMIC)));
            }
            der.writeObject((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new DERSequence(fields)));
            return collector.toByteArray();
        }
        catch (IOException | GSSException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    @Override
    protected void parse(byte[] token) throws IOException {
        try (ASN1InputStream der = new ASN1InputStream(token);){
            ASN1TaggedObject tagged = (ASN1TaggedObject)der.readObject();
            ASN1Sequence sequence = ASN1Sequence.getInstance((ASN1TaggedObject)tagged, (boolean)true);
            Enumeration fields = sequence.getObjects();
            block17: while (fields.hasMoreElements()) {
                tagged = (ASN1TaggedObject)fields.nextElement();
                switch (tagged.getTagNo()) {
                    case 0: {
                        ASN1Enumerated enumerated = ASN1Enumerated.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                        this.setResult(enumerated.getValue().intValue());
                        continue block17;
                    }
                    case 1: {
                        ASN1ObjectIdentifier mech = ASN1ObjectIdentifier.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                        this.setMechanism(new Oid(mech.getId()));
                        continue block17;
                    }
                    case 2: {
                        ASN1OctetString mechanismToken = ASN1OctetString.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                        this.setMechanismToken(mechanismToken.getOctets());
                        continue block17;
                    }
                    case 3: {
                        ASN1OctetString mechanismListMIC = ASN1OctetString.getInstance((ASN1TaggedObject)tagged, (boolean)true);
                        this.setMechanismListMIC(mechanismListMIC.getOctets());
                        continue block17;
                    }
                }
                throw new IOException("Malformed token field.");
            }
        }
        catch (GSSException e) {
            throw new IOException("Failed to parse Oid", e);
        }
    }
}

