/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.OutputStream;
import jcifs.CIFSException;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.fscc.FileEndOfFileInformation;
import jcifs.internal.smb1.com.SmbComWrite;
import jcifs.internal.smb1.com.SmbComWriteAndX;
import jcifs.internal.smb1.com.SmbComWriteAndXResponse;
import jcifs.internal.smb1.com.SmbComWriteResponse;
import jcifs.internal.smb2.info.Smb2SetInfoRequest;
import jcifs.internal.smb2.io.Smb2WriteRequest;
import jcifs.internal.smb2.io.Smb2WriteResponse;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileHandleImpl;
import jcifs.smb.SmbTreeHandleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbFileOutputStream
extends OutputStream {
    private static final Logger log = LoggerFactory.getLogger(SmbFileOutputStream.class);
    private SmbFile file;
    private boolean append;
    private boolean useNTSmbs;
    private int openFlags;
    private int access;
    private int writeSize;
    private int writeSizeFile;
    private long fp;
    private byte[] tmp = new byte[1];
    private SmbComWriteAndX reqx;
    private SmbComWriteAndXResponse rspx;
    private SmbComWrite req;
    private SmbComWriteResponse rsp;
    private SmbFileHandleImpl handle;
    private int sharing;
    private final boolean smb2;

    public SmbFileOutputStream(SmbFile file) throws SmbException {
        this(file, false);
    }

    public SmbFileOutputStream(SmbFile file, boolean append) throws SmbException {
        this(file, append, append ? 22 : 82, 0, 7);
    }

    SmbFileOutputStream(SmbFile file, boolean append, int openFlags, int access, int sharing) throws SmbException {
        this.file = file;
        this.append = append;
        this.openFlags = openFlags;
        this.sharing = sharing;
        this.access = access | 2;
        try (SmbTreeHandleImpl th = file.ensureTreeConnected();){
            this.smb2 = th.isSMB2();
            try (SmbFileHandleImpl fh = this.ensureOpen();){
                if (append) {
                    this.fp = fh.getInitialSize();
                }
                this.init(th);
                if (!append && this.smb2) {
                    Smb2SetInfoRequest treq = new Smb2SetInfoRequest(th.getConfig(), fh.getFileId());
                    treq.setFileInformation(new FileEndOfFileInformation(0L));
                    th.send(treq, RequestParam.NO_RETRY);
                }
            }
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    SmbFileOutputStream(SmbFile file, SmbTreeHandleImpl th, SmbFileHandleImpl handle, int openFlags, int access, int sharing) throws CIFSException {
        this.file = file;
        this.handle = handle;
        this.openFlags = openFlags;
        this.access = access;
        this.sharing = sharing;
        this.append = false;
        this.smb2 = th.isSMB2();
        this.init(th);
    }

    protected final void init(SmbTreeHandleImpl th) throws CIFSException {
        int sendBufferSize = th.getSendBufferSize();
        if (this.smb2) {
            this.writeSize = sendBufferSize;
            this.writeSizeFile = sendBufferSize;
            return;
        }
        this.openFlags &= 0xFFFFFFAF;
        this.writeSize = sendBufferSize - 70;
        this.useNTSmbs = th.hasCapability(16);
        if (!this.useNTSmbs) {
            log.debug("No support for NT SMBs");
        }
        if (th.hasCapability(32768) && !th.areSignaturesActive()) {
            this.writeSizeFile = Math.min(th.getConfig().getSendBufferSize() - 70, 65465);
        } else {
            log.debug("No support or SMB signing is enabled, not enabling large writes");
            this.writeSizeFile = this.writeSize;
        }
        if (log.isDebugEnabled()) {
            log.debug("Negotiated file write size is " + this.writeSizeFile);
        }
        if (this.useNTSmbs) {
            this.reqx = new SmbComWriteAndX(th.getConfig());
            this.rspx = new SmbComWriteAndXResponse(th.getConfig());
        } else {
            this.req = new SmbComWrite(th.getConfig());
            this.rsp = new SmbComWriteResponse(th.getConfig());
        }
    }

    public void open() throws CIFSException {
        SmbFileHandleImpl fh = this.ensureOpen();
        Throwable throwable = null;
        if (fh != null) {
            if (throwable != null) {
                try {
                    fh.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                fh.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.handle.isValid()) {
                this.handle.close();
            }
        }
        finally {
            this.file.clearAttributeCache();
            this.tmp = null;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.tmp[0] = (byte)b;
        this.write(this.tmp, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public boolean isOpen() {
        return this.handle != null && this.handle.isValid();
    }

    protected synchronized SmbFileHandleImpl ensureOpen() throws CIFSException {
        if (!this.isOpen()) {
            this.handle = this.file.openUnshared(this.openFlags, this.access, this.sharing, 128, 0).acquire();
            if (this.append) {
                this.fp = this.handle.getInitialSize();
                if (log.isDebugEnabled()) {
                    log.debug("File pointer is at " + this.fp);
                }
            }
            return this.handle;
        }
        log.trace("File already open");
        return this.handle.acquire();
    }

    protected SmbTreeHandleImpl ensureTreeConnected() throws CIFSException {
        return this.file.ensureTreeConnected();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeDirect(b, off, len, 0);
    }

    public void writeDirect(byte[] b, int off, int len, int flags) throws IOException {
        if (len <= 0) {
            return;
        }
        if (this.tmp == null) {
            throw new IOException("Bad file descriptor");
        }
        try (SmbFileHandleImpl fh = this.ensureOpen();
             SmbTreeHandleImpl th = fh.getTree();){
            if (log.isDebugEnabled()) {
                log.debug("write: fid=" + fh + ",off=" + off + ",len=" + len);
            }
            do {
                int w;
                int blockSize = this.file.getType() == 1 ? this.writeSizeFile : this.writeSize;
                int n = w = len > blockSize ? blockSize : len;
                if (this.smb2) {
                    Smb2WriteRequest wr = new Smb2WriteRequest(th.getConfig(), fh.getFileId());
                    wr.setOffset(this.fp);
                    wr.setData(b, off, w);
                    Smb2WriteResponse resp = th.send(wr, RequestParam.NO_RETRY);
                    long cnt = resp.getCount();
                    this.fp += cnt;
                    len = (int)((long)len - cnt);
                    off = (int)((long)off + cnt);
                    continue;
                }
                if (this.useNTSmbs) {
                    this.reqx.setParam(fh.getFid(), this.fp, len - w, b, off, w);
                    if ((flags & 1) != 0) {
                        this.reqx.setParam(fh.getFid(), this.fp, len, b, off, w);
                        this.reqx.setWriteMode(8);
                    } else {
                        this.reqx.setWriteMode(0);
                    }
                    th.send((CommonServerMessageBlockRequest)this.reqx, this.rspx, RequestParam.NO_RETRY);
                    long cnt = this.rspx.getCount();
                    this.fp += cnt;
                    len = (int)((long)len - cnt);
                    off = (int)((long)off + cnt);
                    continue;
                }
                if (log.isTraceEnabled()) {
                    log.trace(String.format("Wrote at %d remain %d off %d len %d", this.fp, len - w, off, w));
                }
                this.req.setParam(fh.getFid(), this.fp, len - w, b, off, w);
                th.send((CommonServerMessageBlockRequest)this.req, this.rsp, new RequestParam[0]);
                long cnt = this.rsp.getCount();
                this.fp += cnt;
                len = (int)((long)len - cnt);
                off = (int)((long)off + cnt);
                if (!log.isTraceEnabled()) continue;
                log.trace(String.format("Wrote at %d remain %d off %d len %d", this.fp, len - w, off, w));
            } while (len > 0);
        }
    }
}

