/*
 * Decompiled with CFR 0.152.
 */
package eu.aronnax.smartconstraints.parser.common;

import eu.aronnax.smartconstraints.domain.port.coderenderer.ElementCollectorPort;
import eu.aronnax.smartconstraints.domain.port.coderenderer.SourceAnnotDto;
import eu.aronnax.smartconstraints.domain.port.coderenderer.SourceAnnotParamDto;
import eu.aronnax.smartconstraints.domain.port.coderenderer.SourceEntityDto;
import eu.aronnax.smartconstraints.domain.port.coderenderer.SourcePropertyDto;
import eu.aronnax.smartconstraints.parser.common.ConstraintsHelperPort;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

@ApplicationScoped
public class CollectElementsHelper
implements ElementCollectorPort {
    private static final Logger LOGGER = Logger.getLogger(CollectElementsHelper.class.getName());
    private final ConstraintsHelperPort constraintsHelper;

    @Inject
    CollectElementsHelper(ConstraintsHelperPort constraintsHelper) {
        this.constraintsHelper = constraintsHelper;
    }

    public Stream<SourceEntityDto> collectAnnotElements(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, ProcessingEnvironment processingEnv) {
        return annotations.stream().filter(annot -> annot.getQualifiedName().contentEquals(this.constraintsHelper.getCopyConstraintsAnnotation().getName())).flatMap(smartConstraintsAnnot -> roundEnv.getElementsAnnotatedWith((TypeElement)smartConstraintsAnnot).stream()).map(this::buildSourceTarget).flatMap(sourceTargetVO -> this.collectSourceEntities((SourceTargetVO)sourceTargetVO, processingEnv)).peek(this::logProcessedElement);
    }

    private SourceTargetVO buildSourceTarget(Element targetPackage) {
        return new SourceTargetVO(this.constraintsHelper.extractFromPackage(targetPackage), ((PackageElement)targetPackage).getQualifiedName());
    }

    private Stream<SourceEntityDto> collectSourceEntities(SourceTargetVO sourceTargetVO, ProcessingEnvironment processingEnv) {
        return processingEnv.getElementUtils().getPackageElement(sourceTargetVO.sourcePackage).getEnclosedElements().stream().filter(element -> !element.getSimpleName().toString().endsWith("_Constraints")).map(element -> new SourceEntityDto(((TypeElement)element).getQualifiedName().toString(), this.collectSourceProps((TypeElement)element), sourceTargetVO.targetPackage().toString()));
    }

    private List<SourcePropertyDto> collectSourceProps(TypeElement entityElement) {
        return entityElement.getEnclosedElements().stream().filter(typeElem -> typeElem.getKind().equals((Object)ElementKind.FIELD)).filter(element -> this.constraintsHelper.getConstraintClasses().anyMatch(constClass -> element.getAnnotation(constClass) != null)).map(element -> new SourcePropertyDto(element.getSimpleName().toString(), this.collectSourceAnnots((Element)element))).toList();
    }

    private List<SourceAnnotDto> collectSourceAnnots(Element propElement) {
        return propElement.getAnnotationMirrors().stream().map(annotMirror -> new SourceAnnotDto(annotMirror.getAnnotationType().toString(), annotMirror.getAnnotationType().asElement().getSimpleName().toString(), this.collectSourceAnnotParams((AnnotationMirror)annotMirror))).toList();
    }

    private List<SourceAnnotParamDto> collectSourceAnnotParams(AnnotationMirror annotMirror) {
        return annotMirror.getElementValues().entrySet().stream().map(entry -> new SourceAnnotParamDto(((ExecutableElement)entry.getKey()).getSimpleName().toString(), ((AnnotationValue)entry.getValue()).getValue())).toList();
    }

    private void logProcessedElement(SourceEntityDto entry) {
        LOGGER.info("CLASSE: " + entry.classQualifiedName() + " ELEMS : " + entry.sourceProperties().stream().map(element -> element.propertyName() + " (" + element.annots().stream().map(Objects::toString).collect(Collectors.joining(", ")) + ") ").collect(Collectors.joining(", ")));
    }

    record SourceTargetVO(CharSequence sourcePackage, CharSequence targetPackage) {
    }
}

