/*
 * Decompiled with CFR 0.152.
 */
package eu.benschroeder.mockito;

import eu.benschroeder.mockito.WithArgumentMatchers;
import java.util.function.Function;
import org.mockito.CheckReturnValue;
import org.mockito.InOrder;
import org.mockito.Incubating;
import org.mockito.MockSettings;
import org.mockito.MockedConstruction;
import org.mockito.MockedStatic;
import org.mockito.MockingDetails;
import org.mockito.Mockito;
import org.mockito.MockitoFramework;
import org.mockito.session.MockitoSessionBuilder;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.LenientStubber;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationAfterDelay;
import org.mockito.verification.VerificationMode;
import org.mockito.verification.VerificationWithTimeout;

public interface WithMockito
extends WithArgumentMatchers {
    @CheckReturnValue
    default public <T> T mock(Class<T> classToMock) {
        return (T)Mockito.mock(classToMock);
    }

    @CheckReturnValue
    default public <T> T mock(Class<T> classToMock, String name) {
        return (T)Mockito.mock(classToMock, (String)name);
    }

    @CheckReturnValue
    default public MockingDetails mockingDetails(Object toInspect) {
        return Mockito.mockingDetails((Object)toInspect);
    }

    @CheckReturnValue
    default public <T> T mock(Class<T> classToMock, Answer defaultAnswer) {
        return (T)Mockito.mock(classToMock, (Answer)defaultAnswer);
    }

    @CheckReturnValue
    default public <T> T mock(Class<T> classToMock, MockSettings mockSettings) {
        return (T)Mockito.mock(classToMock, (MockSettings)mockSettings);
    }

    @CheckReturnValue
    default public <T> T spy(T object) {
        return (T)Mockito.spy(object);
    }

    @Incubating
    @CheckReturnValue
    default public <T> T spy(Class<T> classToSpy) {
        return (T)Mockito.spy(classToSpy);
    }

    @Incubating
    @CheckReturnValue
    default public <T> MockedStatic<T> mockStatic(Class<T> classToMock) {
        return Mockito.mockStatic(classToMock);
    }

    @Incubating
    @CheckReturnValue
    default public <T> MockedStatic<T> mockStatic(Class<T> classToMock, Answer defaultAnswer) {
        return Mockito.mockStatic(classToMock, (Answer)defaultAnswer);
    }

    @Incubating
    @CheckReturnValue
    default public <T> MockedStatic<T> mockStatic(Class<T> classToMock, String name) {
        return Mockito.mockStatic(classToMock, (String)name);
    }

    @Incubating
    @CheckReturnValue
    default public <T> MockedStatic<T> mockStatic(Class<T> classToMock, MockSettings mockSettings) {
        return Mockito.mockStatic(classToMock, (MockSettings)mockSettings);
    }

    @Incubating
    @CheckReturnValue
    default public <T> MockedConstruction<T> mockConstructionWithAnswer(Class<T> classToMock, Answer defaultAnswer, Answer ... additionalAnswers) {
        return Mockito.mockConstructionWithAnswer(classToMock, (Answer)defaultAnswer, (Answer[])additionalAnswers);
    }

    @Incubating
    @CheckReturnValue
    default public <T> MockedConstruction<T> mockConstruction(Class<T> classToMock) {
        return Mockito.mockConstruction(classToMock);
    }

    @Incubating
    @CheckReturnValue
    default public <T> MockedConstruction<T> mockConstruction(Class<T> classToMock, MockedConstruction.MockInitializer<T> mockInitializer) {
        return Mockito.mockConstruction(classToMock, mockInitializer);
    }

    @Incubating
    @CheckReturnValue
    default public <T> MockedConstruction<T> mockConstruction(Class<T> classToMock, MockSettings mockSettings) {
        return Mockito.mockConstruction(classToMock, (MockSettings)mockSettings);
    }

    @Incubating
    @CheckReturnValue
    default public <T> MockedConstruction<T> mockConstruction(Class<T> classToMock, Function<MockedConstruction.Context, MockSettings> mockSettingsFactory) {
        return Mockito.mockConstruction(classToMock, mockSettingsFactory);
    }

    @Incubating
    @CheckReturnValue
    default public <T> MockedConstruction<T> mockConstruction(Class<T> classToMock, MockSettings mockSettings, MockedConstruction.MockInitializer<T> mockInitializer) {
        return Mockito.mockConstruction(classToMock, (MockSettings)mockSettings, mockInitializer);
    }

    @Incubating
    @CheckReturnValue
    default public <T> MockedConstruction<T> mockConstruction(Class<T> classToMock, Function<MockedConstruction.Context, MockSettings> mockSettingsFactory, MockedConstruction.MockInitializer<T> mockInitializer) {
        return Mockito.mockConstruction(classToMock, mockSettingsFactory, mockInitializer);
    }

    @CheckReturnValue
    default public <T> OngoingStubbing<T> when(T methodCall) {
        return Mockito.when(methodCall);
    }

    @CheckReturnValue
    default public <T> T verify(T mock) {
        return (T)Mockito.verify(mock);
    }

    @CheckReturnValue
    default public <T> T verify(T mock, VerificationMode mode) {
        return (T)Mockito.verify(mock, (VerificationMode)mode);
    }

    default public <T> void reset(T ... mocks) {
        Mockito.reset((Object[])mocks);
    }

    default public void clearAllCaches() {
        Mockito.clearAllCaches();
    }

    default public <T> void clearInvocations(T ... mocks) {
        Mockito.clearInvocations((Object[])mocks);
    }

    default public void verifyNoMoreInteractions(Object ... mocks) {
        Mockito.verifyNoMoreInteractions((Object[])mocks);
    }

    @Deprecated
    default public void verifyZeroInteractions(Object ... mocks) {
        Mockito.verifyNoMoreInteractions((Object[])mocks);
    }

    default public void verifyNoInteractions(Object ... mocks) {
        Mockito.verifyNoInteractions((Object[])mocks);
    }

    @CheckReturnValue
    default public Stubber doThrow(Throwable ... toBeThrown) {
        return Mockito.doThrow((Throwable[])toBeThrown);
    }

    @CheckReturnValue
    default public Stubber doThrow(Class<? extends Throwable> toBeThrown) {
        return Mockito.doThrow(toBeThrown);
    }

    @CheckReturnValue
    default public Stubber doThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable> ... toBeThrownNext) {
        return Mockito.doThrow(toBeThrown, (Class[])toBeThrownNext);
    }

    @CheckReturnValue
    default public Stubber doCallRealMethod() {
        return Mockito.doCallRealMethod();
    }

    @CheckReturnValue
    default public Stubber doAnswer(Answer answer) {
        return Mockito.doAnswer((Answer)answer);
    }

    @CheckReturnValue
    default public Stubber doNothing() {
        return Mockito.doNothing();
    }

    @CheckReturnValue
    default public Stubber doReturn(Object toBeReturned) {
        return Mockito.doReturn((Object)toBeReturned);
    }

    @CheckReturnValue
    default public Stubber doReturn(Object toBeReturned, Object ... toBeReturnedNext) {
        return Mockito.doReturn((Object)toBeReturned, (Object[])toBeReturnedNext);
    }

    @CheckReturnValue
    default public InOrder inOrder(Object ... mocks) {
        return Mockito.inOrder((Object[])mocks);
    }

    default public Object[] ignoreStubs(Object ... mocks) {
        return Mockito.ignoreStubs((Object[])mocks);
    }

    @CheckReturnValue
    default public VerificationMode times(int wantedNumberOfInvocations) {
        return Mockito.times((int)wantedNumberOfInvocations);
    }

    @CheckReturnValue
    default public VerificationMode never() {
        return Mockito.never();
    }

    @CheckReturnValue
    default public VerificationMode atLeastOnce() {
        return Mockito.atLeastOnce();
    }

    @CheckReturnValue
    default public VerificationMode atLeast(int minNumberOfInvocations) {
        return Mockito.atLeast((int)minNumberOfInvocations);
    }

    @CheckReturnValue
    default public VerificationMode atMostOnce() {
        return Mockito.atMostOnce();
    }

    @CheckReturnValue
    default public VerificationMode atMost(int maxNumberOfInvocations) {
        return Mockito.atMost((int)maxNumberOfInvocations);
    }

    @CheckReturnValue
    default public VerificationMode calls(int wantedNumberOfInvocations) {
        return Mockito.calls((int)wantedNumberOfInvocations);
    }

    @CheckReturnValue
    default public VerificationMode only() {
        return Mockito.only();
    }

    @CheckReturnValue
    default public VerificationWithTimeout timeout(long millis) {
        return Mockito.timeout((long)millis);
    }

    @CheckReturnValue
    default public VerificationAfterDelay after(long millis) {
        return Mockito.after((long)millis);
    }

    default public void validateMockitoUsage() {
        Mockito.validateMockitoUsage();
    }

    @CheckReturnValue
    default public MockSettings withSettings() {
        return Mockito.withSettings();
    }

    @CheckReturnValue
    default public VerificationMode description(String description) {
        return Mockito.description((String)description);
    }

    @Incubating
    @CheckReturnValue
    default public MockitoFramework framework() {
        return Mockito.framework();
    }

    @Incubating
    @CheckReturnValue
    default public MockitoSessionBuilder mockitoSession() {
        return Mockito.mockitoSession();
    }

    @Incubating
    default public LenientStubber lenient() {
        return Mockito.lenient();
    }
}

