/*
 * Decompiled with CFR 0.152.
 */
package eu.benschroeder.testdata.statics;

import eu.benschroeder.testdata.Constants;
import eu.benschroeder.testdata.statics.RandomNumbers;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.GregorianCalendar;

public final class RandomDateAndTime {
    public static OffsetDateTime randomPastOffsetDateTime() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(RandomNumbers.randomLong(Constants.MIN_UTC_EPOCH, Instant.now().getEpochSecond())), ZoneId.systemDefault());
    }

    public static OffsetDateTime randomFutureOffsetDateTime() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(RandomNumbers.randomLong(Instant.now().getEpochSecond(), 7258118400L)), ZoneId.systemDefault());
    }

    public static ZonedDateTime randomPastZonedDateTime() {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(RandomNumbers.randomLong(Constants.MIN_UTC_EPOCH, Instant.now().getEpochSecond())), ZoneId.systemDefault());
    }

    public static ZonedDateTime randomFutureZonedDateTime() {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(RandomNumbers.randomLong(Instant.now().getEpochSecond(), 7258118400L)), ZoneId.systemDefault());
    }

    public static LocalDateTime randomPastLocalDateTime() {
        return LocalDateTime.ofEpochSecond(RandomNumbers.randomLong(Constants.MIN_UTC_EPOCH, Instant.now().getEpochSecond()), 0, ZoneOffset.UTC);
    }

    public static LocalDateTime randomFutureLocalDateTime() {
        return LocalDateTime.ofEpochSecond(RandomNumbers.randomLong(Instant.now().getEpochSecond(), 7258118400L), 0, ZoneOffset.UTC);
    }

    public static LocalDate randomPastLocalDate() {
        return LocalDate.ofEpochDay(RandomNumbers.randomLong(0L, LocalDate.now().plusDays(1L).toEpochDay()));
    }

    public static LocalDate randomFutureLocalDate() {
        return LocalDate.ofEpochDay(RandomNumbers.randomLong(LocalDate.now().toEpochDay(), LocalDate.of(2200, 1, 1).toEpochDay()));
    }

    public static LocalTime randomLocalTime() {
        return LocalTime.of(RandomNumbers.randomInt(0, 24), RandomNumbers.randomInt(0, 60), RandomNumbers.randomInt(0, 60));
    }

    public static OffsetTime randomOffsetTime() {
        return OffsetTime.of(RandomDateAndTime.randomLocalTime(), ZoneOffset.UTC);
    }

    public static Date randomPastDate() {
        long from = new GregorianCalendar(1970, 1, 1, 0, 0, 0).getTimeInMillis();
        long to = new Date().getTime();
        return new Date(RandomNumbers.randomLong(from, to));
    }

    public static Date randomFutureDate() {
        long from = new Date().getTime();
        long to = new GregorianCalendar(2200, 0, 1, 0, 0, 0).getTimeInMillis();
        return new Date(RandomNumbers.randomLong(from, to));
    }

    private RandomDateAndTime() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

