/*
 * Decompiled with CFR 0.152.
 */
package eu.benschroeder.testdata.statics;

import eu.benschroeder.testdata.statics.RandomNumbers;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomUtils;

public final class RandomTestData {
    public static boolean randomBoolean() {
        return RandomUtils.nextBoolean();
    }

    public static byte[] randomByteArray() {
        return RandomUtils.nextBytes((int)10);
    }

    public static byte[] randomByteArray(int length) {
        return RandomUtils.nextBytes((int)length);
    }

    public static <T extends Enum<T>> T randomEnum(Class<T> clazz) {
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        return (T)enumConstants[RandomNumbers.randomInt(0, enumConstants.length)];
    }

    public static <T extends Enum<T>> T randomEnumExcluding(Class<T> clazz, T ... excludes) {
        Enum[] enumConstants = (Enum[])ArrayUtils.removeElements((Object[])((Enum[])clazz.getEnumConstants()), (Object[])excludes);
        return (T)enumConstants[RandomNumbers.randomInt(0, enumConstants.length)];
    }

    private RandomTestData() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

