/*
 * Decompiled with CFR 0.152.
 */
package eu.bolt.kalev.okhttp;

import eu.bolt.kalev.Kalev;
import eu.bolt.kalev.LogEntry;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"Leu/bolt/kalev/okhttp/LoggingInterceptor;", "Lokhttp3/Interceptor;", "()V", "formatRequestBody", "", "request", "Lokhttp3/Request;", "formatResponseBody", "body", "Lokhttp3/ResponseBody;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "logError", "", "error", "", "logResponse", "response", "Companion", "kalev-okhttp"})
public final class LoggingInterceptor
implements Interceptor {
    @NotNull
    public static final String NETWORK_MESSAGE = "network";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        Response response = null;
        try {
            Response response2 = chain.proceed(request);
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"chain.proceed(request)");
            response = response2;
        }
        catch (Exception e) {
            Request request2 = request;
            Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"request");
            this.logError(request2, e);
            throw (Throwable)e;
        }
        this.logResponse(response);
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private final void logResponse(Response response) {
        boolean bl;
        String string;
        void $this$mapTo$iv$iv;
        HttpUrl url = response.request().url();
        Set set = url.queryParameterNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"url.queryParameterNames()");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void name;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)name, (Object)url.queryParameter((String)name));
            collection.add(pair);
        }
        Map query = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        LogEntry entry = Kalev.with((String)"method", (Object)response.request().method()).with("path", (Object)url.encodedPath());
        Iterable $this$forEach$iv = query.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry queryEntry = (Map.Entry)element$iv;
            boolean bl3 = false;
            Object k = queryEntry.getKey();
            Intrinsics.checkExpressionValueIsNotNull(k, (String)"queryEntry.key");
            String string3 = (String)k;
            String string4 = (String)queryEntry.getValue();
            if (string4 == null) {
                string4 = "";
            }
            entry.with(string3, (Object)string4);
        }
        Request request = response.request();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"response.request()");
        String string5 = this.formatRequestBody(request);
        if (string5 != null) {
            string = string5;
            bl = false;
            boolean bl4 = false;
            String it = string;
            boolean bl5 = false;
            try {
                LogEntry logEntry = entry.with("request.body", (Object)new JSONObject(it));
            }
            catch (JSONException exc) {
                LogEntry logEntry = entry.with("request.body", (Object)it);
            }
        }
        entry.with("response.code", (Object)response.code());
        String string6 = this.formatResponseBody(response.body());
        if (string6 != null) {
            string = string6;
            bl = false;
            boolean bl6 = false;
            String it = string;
            boolean bl7 = false;
            try {
                LogEntry logEntry = entry.with("response.body", (Object)new JSONObject(it));
            }
            catch (JSONException exc) {
                LogEntry logEntry = entry.with("response.body", (Object)it);
            }
        }
        entry.v(NETWORK_MESSAGE);
    }

    private final String formatRequestBody(Request request) {
        String string;
        if (Intrinsics.areEqual((Object)request.method(), (Object)"GET")) {
            return null;
        }
        RequestBody requestBody = request.body();
        if (requestBody != null) {
            RequestBody requestBody2 = requestBody;
            boolean bl = false;
            boolean bl2 = false;
            RequestBody it = requestBody2;
            boolean bl3 = false;
            Buffer buffer = new Buffer();
            it.writeTo((BufferedSink)buffer);
            string = buffer.readString(Charset.forName("UTF-8"));
        } else {
            string = null;
        }
        return string;
    }

    private final String formatResponseBody(ResponseBody body) {
        String string;
        ResponseBody responseBody = body;
        if (responseBody != null) {
            ResponseBody responseBody2 = responseBody;
            boolean bl = false;
            boolean bl2 = false;
            ResponseBody it = responseBody2;
            boolean bl3 = false;
            BufferedSource source = it.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            string = buffer.clone().readString(Charset.forName("UTF-8"));
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void logError(Request request, Throwable error) {
        boolean bl;
        String string;
        void $this$mapTo$iv$iv;
        HttpUrl url = request.url();
        Set set = url.queryParameterNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"url.queryParameterNames()");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void name;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)name, (Object)url.queryParameter((String)name));
            collection.add(pair);
        }
        Map query = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        LogEntry entry = Kalev.with((String)"method", (Object)request.method()).with("path", (Object)url.encodedPath());
        Iterable $this$forEach$iv = query.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry queryEntry = (Map.Entry)element$iv;
            boolean bl3 = false;
            Object k = queryEntry.getKey();
            Intrinsics.checkExpressionValueIsNotNull(k, (String)"queryEntry.key");
            String string3 = (String)k;
            String string4 = (String)queryEntry.getValue();
            if (string4 == null) {
                string4 = "";
            }
            entry.with(string3, (Object)string4);
        }
        String string5 = this.formatRequestBody(request);
        if (string5 != null) {
            string = string5;
            bl = false;
            boolean bl4 = false;
            String it = string;
            boolean bl5 = false;
            try {
                LogEntry logEntry = entry.with("request.body", (Object)new JSONObject(it));
            }
            catch (JSONException exc) {
                LogEntry logEntry = entry.with("request.body", (Object)it);
            }
        }
        entry.with("response.error", (Object)error.getClass().getName());
        String string6 = error.getMessage();
        if (string6 != null) {
            string = string6;
            bl = false;
            boolean bl6 = false;
            String it = string;
            boolean bl7 = false;
            entry.with("response.error.message", (Object)it);
        }
        entry.e(NETWORK_MESSAGE);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Leu/bolt/kalev/okhttp/LoggingInterceptor$Companion;", "", "()V", "NETWORK_MESSAGE", "", "kalev-okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

