/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.drafts.Draft;
import org.java_websocket.enums.CloseHandshakeType;
import org.java_websocket.enums.HandshakeState;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.exceptions.InvalidHandshakeException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ClientHandshakeBuilder;
import org.java_websocket.handshake.HandshakeBuilder;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.handshake.ServerHandshakeBuilder;
import org.java_websocket.util.Charsetfunctions;

class Draft_HttpHealthCheck
extends Draft {
    static final int HTTP_HEALTH_CHECK_CLOSE_CODE = 10200;

    Draft_HttpHealthCheck() {
    }

    static Boolean isHttp(ClientHandshake handshakedata) {
        String upgradeField = handshakedata.getFieldValue("Upgrade");
        return upgradeField == null || upgradeField == "";
    }

    public List<ByteBuffer> createHandshake(Handshakedata handshakedata, boolean withcontent) {
        byte[] content = Charsetfunctions.asciiBytes((String)"<h1>OCPP-J Websocket OK</h1>");
        byte[] header = Charsetfunctions.asciiBytes((String)("HTTP/1.0 200 OK\r\nMime-Version: 1.0\r\nContent-Type: text/html\r\nContent-Length: " + content.length + " \r\nConnection: close\r\n\r\n"));
        ByteBuffer bytebuffer = ByteBuffer.allocate(content.length + header.length);
        bytebuffer.put(header);
        bytebuffer.put(content);
        bytebuffer.flip();
        return Collections.singletonList(bytebuffer);
    }

    public HandshakeState acceptHandshakeAsClient(ClientHandshake request, ServerHandshake response) throws InvalidHandshakeException {
        throw new InvalidHandshakeException("This draft can't be used on a client");
    }

    public HandshakeState acceptHandshakeAsServer(ClientHandshake handshakedata) throws InvalidHandshakeException {
        return Draft_HttpHealthCheck.isHttp(handshakedata) != false ? HandshakeState.MATCHED : HandshakeState.NOT_MATCHED;
    }

    public ByteBuffer createBinaryFrame(Framedata framedata) {
        return null;
    }

    public List<Framedata> createFrames(ByteBuffer binary, boolean mask) {
        return null;
    }

    public List<Framedata> createFrames(String text, boolean mask) {
        return null;
    }

    public void processFrame(WebSocketImpl webSocketImpl, Framedata frame) throws InvalidDataException {
        throw new InvalidDataException(0, "This draft can't be used on a client");
    }

    public void reset() {
    }

    public ClientHandshakeBuilder postProcessHandshakeRequestAsClient(ClientHandshakeBuilder request) throws InvalidHandshakeException {
        throw new InvalidHandshakeException("This draft can't be used on a client");
    }

    public HandshakeBuilder postProcessHandshakeResponseAsServer(ClientHandshake request, ServerHandshakeBuilder response) throws InvalidHandshakeException {
        return response;
    }

    public List<Framedata> translateFrame(ByteBuffer buffer) throws InvalidDataException {
        throw new InvalidHandshakeException("This draft doesn't work with frames");
    }

    public CloseHandshakeType getCloseHandshakeType() {
        return CloseHandshakeType.NONE;
    }

    public Draft copyInstance() {
        return this;
    }
}

