/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import eu.chargetime.ocpp.Communicator;
import eu.chargetime.ocpp.Radio;
import eu.chargetime.ocpp.model.CallErrorMessage;
import eu.chargetime.ocpp.model.CallMessage;
import eu.chargetime.ocpp.model.CallResultMessage;
import eu.chargetime.ocpp.model.Message;
import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONCommunicator
extends Communicator {
    private static final Logger logger = LoggerFactory.getLogger(JSONCommunicator.class);
    private static final int INDEX_MESSAGEID = 0;
    private static final int TYPENUMBER_CALL = 2;
    private static final int INDEX_CALL_ACTION = 2;
    private static final int INDEX_CALL_PAYLOAD = 3;
    private static final int TYPENUMBER_CALLRESULT = 3;
    private static final int INDEX_CALLRESULT_PAYLOAD = 2;
    private static final int TYPENUMBER_CALLERROR = 4;
    private static final int INDEX_CALLERROR_ERRORCODE = 2;
    private static final int INDEX_CALLERROR_DESCRIPTION = 3;
    private static final int INDEX_CALLERROR_PAYLOAD = 4;
    private static final int INDEX_UNIQUEID = 1;
    private static final String CALL_FORMAT = "[2,\"%s\",\"%s\",%s]";
    private static final String CALLRESULT_FORMAT = "[3,\"%s\",%s]";
    private static final String CALLERROR_FORMAT = "[4,\"%s\",\"%s\",\"%s\",%s]";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String DATE_FORMAT_WITH_MS = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final int DATE_FORMAT_WITH_MS_LENGTH = 24;
    private boolean hasLongDateFormat = false;
    private static Gson gson;

    public JSONCommunicator(Radio radio) {
        super(radio);
    }

    public <T> T unpackPayload(Object payload, Class<T> type) throws Exception {
        return (T)gson.fromJson(payload.toString(), type);
    }

    public Object packPayload(Object payload) {
        return gson.toJson(payload);
    }

    protected Object makeCallResult(String uniqueId, String action, Object payload) {
        return String.format(CALLRESULT_FORMAT, uniqueId, payload);
    }

    protected Object makeCall(String uniqueId, String action, Object payload) {
        return String.format(CALL_FORMAT, uniqueId, action, payload);
    }

    protected Object makeCallError(String uniqueId, String action, String errorCode, String errorDescription) {
        return String.format(CALLERROR_FORMAT, uniqueId, errorCode, errorDescription, "{}");
    }

    protected Message parse(Object json) {
        CallMessage message;
        JsonParser parser = new JsonParser();
        JsonArray array = parser.parse(json.toString()).getAsJsonArray();
        if (array.get(0).getAsInt() == 2) {
            message = new CallMessage();
            message.setAction(array.get(2).getAsString());
            message.setPayload((Object)array.get(3).toString());
        } else if (array.get(0).getAsInt() == 3) {
            message = new CallResultMessage();
            message.setPayload((Object)array.get(2).toString());
        } else if (array.get(0).getAsInt() == 4) {
            message = new CallErrorMessage();
            ((CallErrorMessage)message).setErrorCode(array.get(2).getAsString());
            ((CallErrorMessage)message).setErrorDescription(array.get(3).getAsString());
            ((CallErrorMessage)message).setRawPayload(array.get(4).toString());
        } else {
            logger.error("Unknown message type of message: {}", (Object)json.toString());
            throw new IllegalArgumentException("Unknown message type");
        }
        message.setId(array.get(1).getAsString());
        return message;
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeSerializer());
        gson = builder.create();
    }

    private static class ZonedDateTimeSerializer
    implements JsonSerializer<ZonedDateTime>,
    JsonDeserializer<ZonedDateTime> {
        private ZonedDateTimeSerializer() {
        }

        public JsonElement serialize(ZonedDateTime zonedDateTime, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(zonedDateTime.format(DateTimeFormatter.ISO_INSTANT));
        }

        public ZonedDateTime deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return ZonedDateTime.parse(jsonElement.getAsJsonPrimitive().getAsString());
        }
    }
}

