/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.AuthenticationException;
import eu.chargetime.ocpp.Communicator;
import eu.chargetime.ocpp.Draft_HttpHealthCheck;
import eu.chargetime.ocpp.ISessionFactory;
import eu.chargetime.ocpp.JSONCommunicator;
import eu.chargetime.ocpp.JSONConfiguration;
import eu.chargetime.ocpp.Listener;
import eu.chargetime.ocpp.ListenerEvents;
import eu.chargetime.ocpp.Radio;
import eu.chargetime.ocpp.WebSocketReceiver;
import eu.chargetime.ocpp.WebSocketReceiverEvents;
import eu.chargetime.ocpp.model.SessionInformation;
import eu.chargetime.ocpp.wss.WssFactoryBuilder;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.java_websocket.WebSocket;
import org.java_websocket.drafts.Draft;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshakeBuilder;
import org.java_websocket.server.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketListener
implements Listener {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketListener.class);
    private static final int DEFAULT_WEBSOCKET_WORKER_COUNT = 4;
    private static final int TIMEOUT_IN_MILLIS = 10000;
    private static final int OCPPJ_CP_MIN_PASSWORD_LENGTH = 16;
    private static final int OCPPJ_CP_MAX_PASSWORD_LENGTH = 20;
    private static final String HTTP_HEADER_PROXIED_ADDRESS = "X-Forwarded-For";
    private final ISessionFactory sessionFactory;
    private final List<Draft> drafts;
    private final JSONConfiguration configuration;
    private volatile WebSocketServer server;
    private WssFactoryBuilder wssFactoryBuilder;
    private final Map<WebSocket, WebSocketReceiver> sockets;
    private volatile boolean closed = true;
    private boolean handleRequestAsync;

    public WebSocketListener(ISessionFactory sessionFactory, JSONConfiguration configuration, Draft ... drafts) {
        this.sessionFactory = sessionFactory;
        this.configuration = configuration;
        this.drafts = Arrays.asList(drafts);
        this.sockets = new ConcurrentHashMap<WebSocket, WebSocketReceiver>();
    }

    public WebSocketListener(ISessionFactory sessionFactory, Draft ... drafts) {
        this(sessionFactory, JSONConfiguration.get(), drafts);
    }

    public void open(String hostname, int port, final ListenerEvents handler) {
        this.server = new WebSocketServer(new InetSocketAddress(hostname, port), this.configuration.getParameter("WEBSOCKET_WORKER_COUNT", 4), this.drafts){

            public void onOpen(final WebSocket webSocket, ClientHandshake clientHandshake) {
                if (Draft_HttpHealthCheck.isHttp(clientHandshake).booleanValue()) {
                    logger.debug("On HTTP Request, for heathcheck");
                    webSocket.close(10200);
                    return;
                }
                logger.debug("On connection open (resource descriptor: {})", (Object)clientHandshake.getResourceDescriptor());
                WebSocketReceiver receiver = new WebSocketReceiver(new WebSocketReceiverEvents(){

                    @Override
                    public boolean isClosed() {
                        return WebSocketListener.this.closed;
                    }

                    @Override
                    public void close() {
                        webSocket.close();
                    }

                    @Override
                    public void relay(String message) {
                        webSocket.send(message);
                    }
                });
                WebSocketListener.this.sockets.put(webSocket, receiver);
                String proxiedAddress = clientHandshake.getFieldValue(WebSocketListener.HTTP_HEADER_PROXIED_ADDRESS);
                logger.debug("New web-socket connection opened from address: {} proxied for: {}", (Object)webSocket.getRemoteSocketAddress(), (Object)proxiedAddress);
                SessionInformation information = new SessionInformation.Builder().Identifier(clientHandshake.getResourceDescriptor()).InternetAddress(webSocket.getRemoteSocketAddress()).ProxiedAddress(proxiedAddress).build();
                handler.newSession(WebSocketListener.this.sessionFactory.createSession((Communicator)new JSONCommunicator((Radio)receiver)), information);
            }

            public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket webSocket, Draft draft, ClientHandshake clientHandshake) throws InvalidDataException {
                SessionInformation information = new SessionInformation.Builder().Identifier(clientHandshake.getResourceDescriptor()).InternetAddress(webSocket.getRemoteSocketAddress()).build();
                String username = null;
                byte[] password = null;
                if (clientHandshake.hasFieldValue("Authorization")) {
                    String authorization = clientHandshake.getFieldValue("Authorization");
                    if (authorization != null && authorization.toLowerCase().startsWith("basic")) {
                        String base64Credentials = authorization.substring("Basic".length()).trim();
                        byte[] credDecoded = Base64.getDecoder().decode(base64Credentials);
                        for (int i = 0; i < credDecoded.length; ++i) {
                            if (credDecoded[i] != 58) continue;
                            username = new String(Arrays.copyOfRange(credDecoded, 0, i), StandardCharsets.UTF_8);
                            if (i + 1 >= credDecoded.length) break;
                            password = Arrays.copyOfRange(credDecoded, i + 1, credDecoded.length);
                            break;
                        }
                    }
                    if (password == null || password.length < 16 || password.length > 20) {
                        throw new InvalidDataException(401, "Invalid password length");
                    }
                }
                try {
                    handler.authenticateSession(information, username, password);
                }
                catch (AuthenticationException e) {
                    throw new InvalidDataException(e.getErrorCode(), e.getMessage());
                }
                catch (Exception e) {
                    throw new InvalidDataException(401, e.getMessage());
                }
                return super.onWebsocketHandshakeReceivedAsServer(webSocket, draft, clientHandshake);
            }

            public void onClose(WebSocket webSocket, int code, String reason, boolean remote) {
                logger.debug("On connection close (resource descriptor: {}, code: {}, reason: {}, remote: {})", new Object[]{webSocket.getResourceDescriptor(), code, reason, remote});
                if (code == 10200) {
                    return;
                }
                WebSocketReceiver receiver = (WebSocketReceiver)WebSocketListener.this.sockets.get(webSocket);
                if (receiver != null) {
                    receiver.disconnect();
                    WebSocketListener.this.sockets.remove(webSocket);
                } else {
                    logger.debug("Receiver for socket not found: {}", (Object)webSocket);
                }
            }

            public void onMessage(WebSocket webSocket, String message) {
                ((WebSocketReceiver)WebSocketListener.this.sockets.get(webSocket)).relay(message);
            }

            public void onError(WebSocket webSocket, Exception ex) {
                String resourceDescriptor;
                String string = resourceDescriptor = webSocket != null ? webSocket.getResourceDescriptor() : "not defined (webSocket is null)";
                if (ex instanceof ConnectException) {
                    logger.error("On error (resource descriptor: " + resourceDescriptor + ") triggered caused by:", (Throwable)ex);
                } else {
                    logger.error("On error (resource descriptor: " + resourceDescriptor + ") triggered:", (Throwable)ex);
                }
            }

            public void onStart() {
                logger.debug("Server socket bound");
            }
        };
        if (this.wssFactoryBuilder != null) {
            this.server.setWebSocketFactory(this.wssFactoryBuilder.build());
        }
        this.configure();
        this.server.start();
        this.closed = false;
    }

    void configure() {
        this.server.setReuseAddr(this.configuration.getParameter("REUSE_ADDR", true).booleanValue());
        this.server.setTcpNoDelay(this.configuration.getParameter("TCP_NO_DELAY", false).booleanValue());
        this.server.setConnectionLostTimeout(this.configuration.getParameter("PING_INTERVAL", 60).intValue());
    }

    void enableWSS(WssFactoryBuilder wssFactoryBuilder) {
        if (this.server != null) {
            throw new IllegalStateException("Cannot enable WSS on already running server");
        }
        this.wssFactoryBuilder = wssFactoryBuilder;
    }

    public void close() {
        if (this.server == null) {
            return;
        }
        try {
            this.server.stop(10000);
            this.sockets.clear();
        }
        catch (InterruptedException e) {
            try {
                this.server.stop();
            }
            catch (InterruptedException ex) {
                logger.error("Failed to close listener", (Throwable)ex);
            }
        }
        finally {
            this.closed = true;
            this.server = null;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setAsyncRequestHandler(boolean async) {
        this.handleRequestAsync = async;
    }
}

