/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.JSONConfiguration;
import eu.chargetime.ocpp.NotConnectedException;
import eu.chargetime.ocpp.RadioEvents;
import eu.chargetime.ocpp.Transmitter;
import eu.chargetime.ocpp.wss.WssSocketBuilder;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransmitter
implements Transmitter {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketTransmitter.class);
    public static final String WSS_SCHEME = "wss";
    private final Draft draft;
    private final JSONConfiguration configuration;
    private volatile boolean closed = true;
    private volatile WebSocketClient client;
    private WssSocketBuilder wssSocketBuilder;

    public WebSocketTransmitter(JSONConfiguration configuration, Draft draft) {
        this.configuration = configuration;
        this.draft = draft;
    }

    public WebSocketTransmitter(Draft draft) {
        this(JSONConfiguration.get(), draft);
    }

    public void connect(String uri, final RadioEvents events) {
        URI resource = URI.create(uri);
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        String username = (String)this.configuration.getParameter("USERNAME");
        Object password = this.configuration.getParameter("PASSWORD");
        byte[] credentials = null;
        if (username != null && password != null) {
            if (password instanceof String) {
                credentials = (username + ":" + password).getBytes(StandardCharsets.UTF_8);
            } else if (password instanceof byte[]) {
                credentials = this.joinByteArrays((username + ":").getBytes(StandardCharsets.UTF_8), (byte[])password);
            }
        }
        if (credentials != null) {
            byte[] base64Credentials = Base64.getEncoder().encode(credentials);
            httpHeaders.put("Authorization", "Basic " + new String(base64Credentials));
        }
        int connectTimeout = this.configuration.getParameter("CONNECT_TIMEOUT_IN_MS", 0);
        this.client = new WebSocketClient(resource, this.draft, httpHeaders, connectTimeout){

            public void onOpen(ServerHandshake serverHandshake) {
                logger.debug("On connection open (HTTP status: {})", (Object)serverHandshake.getHttpStatus());
                events.connected();
            }

            public void onMessage(String message) {
                events.receivedMessage((Object)message);
            }

            public void onClose(int code, String reason, boolean remote) {
                logger.debug("On connection close (code: {}, reason: {}, remote: {})", new Object[]{code, reason, remote});
                events.disconnected();
            }

            public void onError(Exception ex) {
                if (ex instanceof ConnectException) {
                    logger.error("On error triggered caused by:", (Throwable)ex);
                } else {
                    logger.error("On error triggered:", (Throwable)ex);
                }
            }
        };
        if (WSS_SCHEME.equals(resource.getScheme())) {
            if (this.wssSocketBuilder == null) {
                throw new IllegalStateException("wssSocketBuilder must be set to support wss scheme");
            }
            try {
                this.client.setSocket(this.wssSocketBuilder.uri(resource).build());
            }
            catch (IOException ex) {
                logger.error("SSL socket creation failed", (Throwable)ex);
            }
        }
        this.configure();
        logger.debug("Trying to connect to: {}", (Object)resource);
        try {
            this.client.connectBlocking();
            this.closed = false;
        }
        catch (Exception ex) {
            logger.warn("client.connectBlocking() failed", (Throwable)ex);
        }
    }

    byte[] joinByteArrays(byte[] a, byte[] b) {
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    void configure() {
        this.client.setReuseAddr(this.configuration.getParameter("REUSE_ADDR", false).booleanValue());
        this.client.setTcpNoDelay(this.configuration.getParameter("TCP_NO_DELAY", false).booleanValue());
        this.client.setConnectionLostTimeout(this.configuration.getParameter("PING_INTERVAL", 60).intValue());
        this.client.setProxy(this.configuration.getParameter("PROXY", Proxy.NO_PROXY));
    }

    void enableWSS(WssSocketBuilder wssSocketBuilder) {
        if (this.client != null) {
            throw new IllegalStateException("Cannot enable WSS on already connected client");
        }
        this.wssSocketBuilder = wssSocketBuilder;
    }

    public void disconnect() {
        if (this.client == null) {
            return;
        }
        try {
            this.client.closeBlocking();
        }
        catch (Exception ex) {
            logger.info("client.closeBlocking() failed", (Throwable)ex);
        }
        finally {
            this.client = null;
            this.closed = true;
        }
    }

    public void send(Object request) throws NotConnectedException {
        if (this.client == null) {
            throw new NotConnectedException();
        }
        try {
            this.client.send(request.toString());
        }
        catch (WebsocketNotConnectedException ex) {
            throw new NotConnectedException();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

