/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.wss;

import eu.chargetime.ocpp.wss.CustomSSLWebSocketServerFactory;
import eu.chargetime.ocpp.wss.WssFactoryBuilder;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;

public class BaseWssFactoryBuilder
implements WssFactoryBuilder {
    private SSLContext sslContext;
    private List<String> ciphers;

    private BaseWssFactoryBuilder() {
    }

    public static BaseWssFactoryBuilder builder() {
        return new BaseWssFactoryBuilder();
    }

    public BaseWssFactoryBuilder ciphers(List<String> ciphers) {
        this.ciphers = ciphers;
        return this;
    }

    public BaseWssFactoryBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    @Override
    public WebSocketServerFactory build() {
        this.verify();
        return this.ciphers == null ? new DefaultSSLWebSocketServerFactory(this.sslContext) : new CustomSSLWebSocketServerFactory(this.sslContext, this.ciphers);
    }

    @Override
    public void verify() {
        if (this.sslContext == null) {
            throw new IllegalStateException("sslContext must be set");
        }
    }
}

