/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.wss;

import eu.chargetime.ocpp.wss.WssSocketBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import javax.net.ssl.SSLSocketFactory;

public class BaseWssSocketBuilder
implements WssSocketBuilder {
    public static final int DEFAULT_WSS_PORT = 443;
    private Proxy proxy = Proxy.NO_PROXY;
    private SocketFactory socketFactory = Socket::new;
    private SSLSocketFactory sslSocketFactory;
    private boolean tcpNoDelay;
    private boolean reuseAddr;
    private boolean autoClose = true;
    private URI uri;
    private InetSocketAddressFactory inetSocketAddressFactory = (host, port) -> new InetSocketAddress(host, port);
    private int connectionTimeout = 0;

    private BaseWssSocketBuilder() {
    }

    public static BaseWssSocketBuilder builder() {
        return new BaseWssSocketBuilder();
    }

    public BaseWssSocketBuilder proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public BaseWssSocketBuilder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public BaseWssSocketBuilder socketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        return this;
    }

    public BaseWssSocketBuilder inetSocketAddressFactory(InetSocketAddressFactory inetSocketAddressFactory) {
        this.inetSocketAddressFactory = inetSocketAddressFactory;
        return this;
    }

    public BaseWssSocketBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public BaseWssSocketBuilder reuseAddr(boolean reuseAddr) {
        this.reuseAddr = reuseAddr;
        return this;
    }

    public BaseWssSocketBuilder autoClose(boolean autoClose) {
        this.autoClose = autoClose;
        return this;
    }

    @Override
    public BaseWssSocketBuilder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public BaseWssSocketBuilder connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Override
    public Socket build() throws IOException {
        this.verify(true);
        Socket socket = this.socketFactory.getSocket(this.proxy);
        socket.setTcpNoDelay(this.tcpNoDelay);
        socket.setReuseAddress(this.reuseAddr);
        if (!socket.isBound()) {
            socket.connect(this.inetSocketAddressFactory.getInetSocketAddress(this.uri.getHost(), this.getPort(this.uri)), this.connectionTimeout);
        }
        return this.sslSocketFactory.createSocket(socket, this.uri.getHost(), this.getPort(this.uri), this.autoClose);
    }

    @Override
    public void verify() {
        this.verify(false);
    }

    private void verify(boolean complete) {
        if (this.sslSocketFactory == null) {
            throw new IllegalStateException("sslSocketFactory must be set");
        }
        if (complete && this.uri == null) {
            throw new IllegalStateException("uri must be set");
        }
    }

    private int getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            String scheme = uri.getScheme();
            if ("wss".equals(scheme)) {
                return 443;
            }
            if ("ws".equals(scheme)) {
                throw new IllegalArgumentException("Not supported scheme: " + scheme);
            }
            throw new IllegalArgumentException("Unknown scheme: " + scheme);
        }
        return port;
    }

    public static interface InetSocketAddressFactory {
        public InetSocketAddress getInetSocketAddress(String var1, int var2);
    }

    public static interface SocketFactory {
        public Socket getSocket(Proxy var1);
    }
}

