/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp.wss;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.java_websocket.SSLSocketChannel2;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;

public final class CustomSSLWebSocketServerFactory
extends DefaultSSLWebSocketServerFactory {
    private List<String> ciphers;

    public CustomSSLWebSocketServerFactory(SSLContext sslContext, List<String> ciphers) {
        super(sslContext);
        this.ciphers = ciphers;
    }

    public ByteChannel wrapChannel(SocketChannel channel, SelectionKey key) throws IOException {
        SSLEngine e = this.sslcontext.createSSLEngine();
        ArrayList<String> enabledCiphers = new ArrayList<String>(Arrays.asList(e.getEnabledCipherSuites()));
        enabledCiphers.retainAll(this.ciphers);
        e.setEnabledCipherSuites(enabledCiphers.toArray(new String[enabledCiphers.size()]));
        e.setUseClientMode(false);
        return new SSLSocketChannel2(channel, e, this.exec, key);
    }
}

