/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.CallErrorException;
import eu.chargetime.ocpp.ClientEvents;
import eu.chargetime.ocpp.IFeatureRepository;
import eu.chargetime.ocpp.IPromiseRepository;
import eu.chargetime.ocpp.ISession;
import eu.chargetime.ocpp.OccurenceConstraintException;
import eu.chargetime.ocpp.SessionEvents;
import eu.chargetime.ocpp.UnsupportedFeatureException;
import eu.chargetime.ocpp.feature.Feature;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    private ISession session;
    private final IFeatureRepository featureRepository;
    private final IPromiseRepository promiseRepository;

    public Client(ISession session, IFeatureRepository featureRepository, IPromiseRepository promiseRepository) {
        this.session = session;
        this.featureRepository = featureRepository;
        this.promiseRepository = promiseRepository;
    }

    public void connect(String uri, final ClientEvents events) {
        this.session.open(uri, new SessionEvents(){

            @Override
            public void handleConfirmation(String uniqueId, Confirmation confirmation) {
                Optional<CompletableFuture<Confirmation>> promiseOptional = Client.this.promiseRepository.getPromise(uniqueId);
                if (promiseOptional.isPresent()) {
                    promiseOptional.get().complete(confirmation);
                    Client.this.promiseRepository.removePromise(uniqueId);
                } else {
                    logger.debug("Promise not found for confirmation {}", (Object)confirmation);
                }
            }

            @Override
            public Confirmation handleRequest(Request request) throws UnsupportedFeatureException {
                Optional<Feature> featureOptional = Client.this.featureRepository.findFeature(request);
                if (featureOptional.isPresent()) {
                    return featureOptional.get().handleRequest(Client.this.getSessionId(), request);
                }
                throw new UnsupportedFeatureException();
            }

            @Override
            public void handleError(String uniqueId, String errorCode, String errorDescription, Object payload) {
                Optional<CompletableFuture<Confirmation>> promiseOptional = Client.this.promiseRepository.getPromise(uniqueId);
                if (promiseOptional.isPresent()) {
                    promiseOptional.get().completeExceptionally(new CallErrorException(errorCode, errorDescription, payload));
                    Client.this.promiseRepository.removePromise(uniqueId);
                } else {
                    logger.debug("Promise not found for error {}", (Object)errorDescription);
                }
            }

            @Override
            public void handleConnectionClosed() {
                if (events != null) {
                    events.connectionClosed();
                }
            }

            @Override
            public void handleConnectionOpened() {
                if (events != null) {
                    events.connectionOpened();
                }
            }
        });
    }

    public void disconnect() {
        try {
            this.session.close();
        }
        catch (Exception ex) {
            logger.info("session.close() failed", (Throwable)ex);
        }
    }

    public CompletableFuture<Confirmation> send(Request request) throws UnsupportedFeatureException, OccurenceConstraintException {
        Optional<Feature> featureOptional = this.featureRepository.findFeature(request);
        if (!featureOptional.isPresent()) {
            logger.error("Can't send request: unsupported feature. Payload: {}", (Object)request);
            throw new UnsupportedFeatureException();
        }
        if (!request.validate()) {
            logger.error("Can't send request: not validated. Payload {}: ", (Object)request);
            throw new OccurenceConstraintException();
        }
        String id = this.session.storeRequest(request);
        CompletableFuture<Confirmation> promise = this.promiseRepository.createPromise(id);
        this.session.sendRequest(featureOptional.get().getAction(), request, id);
        return promise;
    }

    public UUID getSessionId() {
        return this.session.getSessionId();
    }
}

