/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.CommunicatorEvents;
import eu.chargetime.ocpp.NotConnectedException;
import eu.chargetime.ocpp.Radio;
import eu.chargetime.ocpp.RadioEvents;
import eu.chargetime.ocpp.Receiver;
import eu.chargetime.ocpp.Transmitter;
import eu.chargetime.ocpp.model.CallErrorMessage;
import eu.chargetime.ocpp.model.CallMessage;
import eu.chargetime.ocpp.model.CallResultMessage;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Message;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.utilities.SugarUtil;
import java.util.ArrayDeque;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class Communicator {
    private static final Logger logger = LoggerFactory.getLogger(Communicator.class);
    private RetryRunner retryRunner;
    protected Radio radio;
    private ArrayDeque<Object> transactionQueue;
    private CommunicatorEvents events;
    private boolean failedFlag;

    public abstract <T> T unpackPayload(Object var1, Class<T> var2) throws Exception;

    public abstract Object packPayload(Object var1);

    protected abstract Object makeCallResult(String var1, String var2, Object var3);

    protected abstract Object makeCall(String var1, String var2, Object var3);

    protected abstract Object makeCallError(String var1, String var2, String var3, String var4);

    protected abstract Message parse(Object var1);

    public Communicator(Radio transmitter) {
        this.radio = transmitter;
        this.transactionQueue = new ArrayDeque();
        this.retryRunner = new RetryRunner();
        this.failedFlag = false;
    }

    public void connect(String uri, CommunicatorEvents events) {
        this.events = events;
        if (this.radio instanceof Transmitter) {
            ((Transmitter)this.radio).connect(uri, new EventHandler(events));
        }
    }

    public void accept(CommunicatorEvents events) {
        this.events = events;
        if (this.radio instanceof Receiver) {
            ((Receiver)this.radio).accept(new EventHandler(events));
        }
    }

    public synchronized void sendCall(String uniqueId, String action, Request request) {
        Object call = this.makeCall(uniqueId, action, this.packPayload(request));
        if (call != null) {
            if (call instanceof SOAPMessage) {
                logger.trace("Send a message: {}", (Object)SugarUtil.soapMessageToString((SOAPMessage)call));
            } else {
                logger.trace("Send a message: {}", call);
            }
        }
        try {
            if (this.radio.isClosed()) {
                if (request.transactionRelated()) {
                    logger.warn("Not connected: storing request to queue: {}", (Object)request);
                    this.transactionQueue.add(call);
                } else {
                    logger.warn("Not connected: can't send request: {}", (Object)request);
                    this.events.onError(uniqueId, "Not connected", "The request can't be sent due to the lack of connection", request);
                }
            } else if (request.transactionRelated() && this.transactionQueue.size() > 0) {
                this.transactionQueue.add(call);
                this.processTransactionQueue();
            } else {
                this.radio.send(call);
            }
        }
        catch (NotConnectedException ex) {
            logger.warn("sendCall() failed: not connected");
            if (request.transactionRelated()) {
                this.transactionQueue.add(call);
            }
            this.events.onError(uniqueId, "Not connected", "The request can't be sent due to the lack of connection", request);
        }
    }

    public void sendCallResult(String uniqueId, String action, Confirmation confirmation) {
        try {
            this.radio.send(this.makeCallResult(uniqueId, action, this.packPayload(confirmation)));
        }
        catch (NotConnectedException ex) {
            logger.warn("sendCallResult() failed", (Throwable)ex);
            this.events.onError(uniqueId, "Not connected", "The confirmation couldn't be send due to the lack of connection", confirmation);
        }
    }

    public void sendCallError(String uniqueId, String action, String errorCode, String errorDescription) {
        logger.error("An error occurred. Sending this information: uniqueId {}: action: {}, errorCore: {}, errorDescription: {}", new Object[]{uniqueId, action, errorCode, errorDescription});
        try {
            this.radio.send(this.makeCallError(uniqueId, action, errorCode, errorDescription));
        }
        catch (NotConnectedException ex) {
            logger.warn("sendCallError() failed", (Throwable)ex);
            this.events.onError(uniqueId, "Not connected", "The error couldn't be send due to the lack of connection", errorCode);
        }
    }

    public void disconnect() {
        this.radio.disconnect();
    }

    private synchronized void processTransactionQueue() {
        if (!this.retryRunner.isAlive()) {
            if (this.retryRunner.getState() != Thread.State.NEW) {
                this.retryRunner = new RetryRunner();
            }
            this.retryRunner.start();
        }
    }

    private Object getRetryMessage() {
        Object result = null;
        if (!this.transactionQueue.isEmpty()) {
            result = this.transactionQueue.peek();
        }
        return result;
    }

    private boolean hasFailed() {
        return this.failedFlag;
    }

    private void popRetryMessage() {
        if (!this.transactionQueue.isEmpty()) {
            this.transactionQueue.pop();
        }
    }

    private class RetryRunner
    extends Thread {
        private static final long DELAY_IN_MILLISECONDS = 1000L;

        private RetryRunner() {
        }

        @Override
        public void run() {
            try {
                Object call;
                while ((call = Communicator.this.getRetryMessage()) != null) {
                    Communicator.this.failedFlag = false;
                    Communicator.this.radio.send(call);
                    Thread.sleep(1000L);
                    if (Communicator.this.hasFailed()) continue;
                    Communicator.this.popRetryMessage();
                }
            }
            catch (Exception ex) {
                logger.warn("RetryRunner::run() failed", (Throwable)ex);
            }
        }
    }

    private class EventHandler
    implements RadioEvents {
        private final CommunicatorEvents events;

        public EventHandler(CommunicatorEvents events) {
            this.events = events;
        }

        @Override
        public void connected() {
            this.events.onConnected();
            Communicator.this.processTransactionQueue();
        }

        @Override
        public void receivedMessage(Object input) {
            Message call;
            Message message = Communicator.this.parse(input);
            if (message != null) {
                Object payload = message.getPayload();
                if (payload instanceof Document) {
                    logger.trace("Receive a message: {}", (Object)SugarUtil.docToString((Document)payload));
                } else {
                    logger.trace("Receive a message: {}", (Object)message);
                }
            }
            if (message instanceof CallResultMessage) {
                this.events.onCallResult(message.getId(), message.getAction(), message.getPayload());
            } else if (message instanceof CallErrorMessage) {
                Communicator.this.failedFlag = true;
                call = (CallErrorMessage)message;
                this.events.onError(call.getId(), ((CallErrorMessage)call).getErrorCode(), ((CallErrorMessage)call).getErrorDescription(), ((CallErrorMessage)call).getRawPayload());
            } else if (message instanceof CallMessage) {
                call = (CallMessage)message;
                this.events.onCall(call.getId(), call.getAction(), call.getPayload());
            }
        }

        @Override
        public void disconnected() {
            this.events.onDisconnected();
        }
    }
}

