/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.IFeatureRepository;
import eu.chargetime.ocpp.feature.Feature;
import eu.chargetime.ocpp.feature.ProfileFeature;
import eu.chargetime.ocpp.feature.profile.Profile;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.utilities.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class FeatureRepository
implements IFeatureRepository {
    private final Map<String, Feature> actionMap = new HashMap<String, Feature>();
    private final Map<Class<?>, Feature> classMap = new HashMap();

    public void addFeatureProfile(Profile profile) {
        for (ProfileFeature feature : profile.getFeatureList()) {
            this.addFeature(feature);
        }
    }

    public void addFeature(Feature feature) {
        this.actionMap.put(feature.getAction(), feature);
        this.classMap.put(feature.getRequestType(), feature);
        this.classMap.put(feature.getConfirmationType(), feature);
    }

    @Override
    public Optional<Feature> findFeature(Object needle) {
        if (needle instanceof String) {
            return Optional.ofNullable(this.actionMap.get(needle));
        }
        if (needle instanceof Request || needle instanceof Confirmation) {
            return Optional.ofNullable(this.classMap.get(needle.getClass()));
        }
        return Optional.empty();
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeatureRepository").add("actionMap", this.actionMap).add("classMap", this.classMap).toString();
    }
}

