/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.utilities.MoreObjects;
import eu.chargetime.ocpp.utilities.Stopwatch;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Queue {
    private static final Logger logger = LoggerFactory.getLogger(Queue.class);
    public static final int REQUEST_QUEUE_INITIAL_CAPACITY = 1000;
    private Map<String, Request> requestQueue = new ConcurrentHashMap<String, Request>(1000);

    public String store(Request request) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String ticket = UUID.randomUUID().toString();
        this.requestQueue.put(ticket, request);
        logger.debug("Queue size: {}, store time: {}", (Object)this.requestQueue.size(), (Object)stopwatch.stop());
        return ticket;
    }

    public Optional<Request> restoreRequest(String ticket) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Request request = this.requestQueue.get(ticket);
            this.requestQueue.remove(ticket);
            logger.debug("Queue size: {}, store time: {}", (Object)this.requestQueue.size(), (Object)stopwatch.stop());
            return Optional.ofNullable(request);
        }
        catch (Exception ex) {
            logger.warn("restoreRequest({}) failed", (Object)ticket, (Object)ex);
            return Optional.empty();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("requestQueue", this.requestQueue).toString();
    }
}

