/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.AuthenticationException;
import eu.chargetime.ocpp.CallErrorException;
import eu.chargetime.ocpp.IFeatureRepository;
import eu.chargetime.ocpp.IPromiseRepository;
import eu.chargetime.ocpp.ISession;
import eu.chargetime.ocpp.Listener;
import eu.chargetime.ocpp.ListenerEvents;
import eu.chargetime.ocpp.NotConnectedException;
import eu.chargetime.ocpp.OccurenceConstraintException;
import eu.chargetime.ocpp.ServerEvents;
import eu.chargetime.ocpp.SessionEvents;
import eu.chargetime.ocpp.UnsupportedFeatureException;
import eu.chargetime.ocpp.feature.Feature;
import eu.chargetime.ocpp.model.Confirmation;
import eu.chargetime.ocpp.model.Request;
import eu.chargetime.ocpp.model.SessionInformation;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    public static final int INITIAL_SESSIONS_NUMBER = 1000;
    private Map<UUID, ISession> sessions;
    private Listener listener;
    private final IFeatureRepository featureRepository;
    private final IPromiseRepository promiseRepository;

    public Server(Listener listener, IFeatureRepository featureRepository, IPromiseRepository promiseRepository) {
        this.listener = listener;
        this.featureRepository = featureRepository;
        this.promiseRepository = promiseRepository;
        this.sessions = new ConcurrentHashMap<UUID, ISession>(1000);
    }

    public void open(String hostname, int port, final ServerEvents serverEvents) {
        this.listener.open(hostname, port, new ListenerEvents(){

            @Override
            public void authenticateSession(SessionInformation information, String username, byte[] password) throws AuthenticationException {
                serverEvents.authenticateSession(information, username, password);
            }

            @Override
            public void newSession(final ISession session, SessionInformation information) {
                session.accept(new SessionEvents(){

                    @Override
                    public void handleConfirmation(String uniqueId, Confirmation confirmation) {
                        Optional<CompletableFuture<Confirmation>> promiseOptional = Server.this.promiseRepository.getPromise(uniqueId);
                        if (promiseOptional.isPresent()) {
                            promiseOptional.get().complete(confirmation);
                            Server.this.promiseRepository.removePromise(uniqueId);
                        } else {
                            logger.debug("Promise not found for confirmation {}", (Object)confirmation);
                        }
                    }

                    @Override
                    public Confirmation handleRequest(Request request) throws UnsupportedFeatureException {
                        Optional<Feature> featureOptional = Server.this.featureRepository.findFeature(request);
                        if (featureOptional.isPresent()) {
                            Optional sessionIdOptional = Server.this.getSessionID(session);
                            if (sessionIdOptional.isPresent()) {
                                return featureOptional.get().handleRequest((UUID)sessionIdOptional.get(), request);
                            }
                            logger.error("Unable to handle request ({}), the active session was not found.", (Object)request);
                            throw new IllegalStateException("Active session not found");
                        }
                        throw new UnsupportedFeatureException();
                    }

                    @Override
                    public void handleError(String uniqueId, String errorCode, String errorDescription, Object payload) {
                        Optional<CompletableFuture<Confirmation>> promiseOptional = Server.this.promiseRepository.getPromise(uniqueId);
                        if (promiseOptional.isPresent()) {
                            promiseOptional.get().completeExceptionally(new CallErrorException(errorCode, errorDescription, payload));
                            Server.this.promiseRepository.removePromise(uniqueId);
                        } else {
                            logger.debug("Promise not found for error {}", (Object)errorDescription);
                        }
                    }

                    @Override
                    public void handleConnectionClosed() {
                        Optional sessionIdOptional = Server.this.getSessionID(session);
                        if (sessionIdOptional.isPresent()) {
                            serverEvents.lostSession((UUID)sessionIdOptional.get());
                            Server.this.sessions.remove(sessionIdOptional.get());
                        } else {
                            logger.warn("Active session not found");
                        }
                    }

                    @Override
                    public void handleConnectionOpened() {
                    }
                });
                Server.this.sessions.put(session.getSessionId(), session);
                Optional sessionIdOptional = Server.this.getSessionID(session);
                if (!sessionIdOptional.isPresent()) {
                    throw new IllegalStateException("Failed to create a session");
                }
                serverEvents.newSession((UUID)sessionIdOptional.get(), information);
                logger.debug("Session created: {}", (Object)session.getSessionId());
            }
        });
    }

    private Optional<UUID> getSessionID(ISession session) {
        if (!this.sessions.containsValue(session)) {
            return Optional.empty();
        }
        return Optional.of(session.getSessionId());
    }

    public void close() {
        this.listener.close();
    }

    public CompletableFuture<Confirmation> send(UUID sessionIndex, Request request) throws UnsupportedFeatureException, OccurenceConstraintException, NotConnectedException {
        Optional<Feature> featureOptional = this.featureRepository.findFeature(request);
        if (!featureOptional.isPresent()) {
            throw new UnsupportedFeatureException();
        }
        if (!request.validate()) {
            throw new OccurenceConstraintException();
        }
        ISession session = this.sessions.get(sessionIndex);
        if (session == null) {
            logger.warn("Session not found by index: {}", (Object)sessionIndex);
            throw new NotConnectedException();
        }
        String id = session.storeRequest(request);
        CompletableFuture<Confirmation> promise = this.promiseRepository.createPromise(id);
        session.sendRequest(featureOptional.get().getAction(), request, id);
        return promise;
    }

    public boolean isSessionOpen(UUID sessionIndex) {
        return this.sessions.containsKey(sessionIndex);
    }

    public void closeSession(UUID sessionIndex) {
        ISession session = this.sessions.get(sessionIndex);
        if (session != null) {
            session.close();
        }
    }
}

