/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.bindings.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Copyable
implements Cloneable {
    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("use copy() method to get a deep copy of this object");
    }

    public Copyable copy() {
        try {
            return (Copyable)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    public static <E extends Copyable> E copy(E copyable) {
        if (copyable == null) {
            return null;
        }
        return (E)copyable.copy();
    }

    public static <E extends Copyable> List<E> copy(final List<E> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(((Copyable)list.get(0)).copy());
        }
        return new ArrayList<E>(list.size()){
            {
                super(x0);
                for (Copyable c : list) {
                    this.add(c.copy());
                }
            }
        };
    }

    public static <E> List<E> shallowCopy(List<E> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return new ArrayList<E>(list);
    }
}

