/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.bindings.cmd.ws;

import eu.clarin.weblicht.bindings.cmd.AbstractComponent;
import eu.clarin.weblicht.bindings.cmd.Descriptions;
import eu.clarin.weblicht.bindings.cmd.StringBinding;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"persons", "roles", "addresses", "emails", "departments", "organisations", "telephoneNumbers", "faxNumbers", "urls", "descriptions"})
public class Contact
extends AbstractComponent {
    @XmlElement(name="Person")
    private List<StringBinding> persons;
    @XmlElement(name="Role")
    private List<StringBinding> roles;
    @XmlElement(name="Address")
    private List<StringBinding> addresses;
    @XmlElement(name="Email")
    private List<StringBinding> emails;
    @XmlElement(name="Department")
    private List<StringBinding> departments;
    @XmlElement(name="Organisation")
    private List<StringBinding> organisations;
    @XmlElement(name="TelephoneNumber")
    private List<StringBinding> telephoneNumbers;
    @XmlElement(name="FaxNumber")
    private List<StringBinding> faxNumbers;
    @XmlElement(name="Url")
    @XmlSchemaType(name="anyURI")
    private List<URI> urls;
    @XmlElement(name="Descriptions")
    private Descriptions descriptions;

    Contact() {
    }

    public List<StringBinding> getPersons() {
        return this.persons;
    }

    public List<StringBinding> getRoles() {
        return this.roles;
    }

    public List<StringBinding> getAddresses() {
        return this.addresses;
    }

    public List<StringBinding> getEmails() {
        return this.emails;
    }

    public StringBinding getEmail() {
        if (this.emails != null && !this.emails.isEmpty()) {
            return this.emails.get(0);
        }
        return null;
    }

    public void setEmail(StringBinding email) {
        this.emails = Collections.singletonList(email);
    }

    public List<StringBinding> getDepartments() {
        return this.departments;
    }

    public List<StringBinding> getOrganisations() {
        return this.organisations;
    }

    public StringBinding getOrganisation() {
        if (this.organisations != null && !this.organisations.isEmpty()) {
            return this.organisations.get(0);
        }
        return null;
    }

    public void setOrganisation(StringBinding organisation) {
        this.organisations = Collections.singletonList(organisation);
    }

    public List<StringBinding> getTelephoneNumbers() {
        return this.telephoneNumbers;
    }

    public List<StringBinding> getFaxNumbers() {
        return this.faxNumbers;
    }

    public List<URI> getUrls() {
        return this.urls;
    }

    public Descriptions getDescriptions() {
        return this.descriptions;
    }

    public String toString() {
        if (this.persons != null && this.persons.size() == 1) {
            return this.persons.get(0).getValue();
        }
        if (this.emails != null && this.emails.size() == 1) {
            return this.emails.get(0).getValue();
        }
        if (this.organisations != null && this.organisations.size() == 1) {
            return this.organisations.get(0).getValue();
        }
        if (this.urls != null && this.urls.size() == 1) {
            return this.urls.get(0).toString();
        }
        return null;
    }

    @Override
    public Contact copy() {
        Contact contact = (Contact)super.copy();
        contact.persons = Contact.shallowCopy(this.persons);
        contact.roles = Contact.shallowCopy(this.roles);
        contact.addresses = Contact.shallowCopy(this.addresses);
        contact.emails = Contact.shallowCopy(this.emails);
        contact.departments = Contact.shallowCopy(this.departments);
        contact.organisations = Contact.shallowCopy(this.organisations);
        contact.telephoneNumbers = Contact.shallowCopy(this.telephoneNumbers);
        contact.faxNumbers = Contact.shallowCopy(this.faxNumbers);
        contact.urls = Contact.shallowCopy(this.urls);
        contact.descriptions = Contact.copy(this.descriptions);
        return contact;
    }
}

