/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.bindings.cmd.ws;

import eu.clarin.weblicht.bindings.cmd.AbstractComponent;
import eu.clarin.weblicht.bindings.cmd.Description;
import eu.clarin.weblicht.bindings.cmd.StringBinding;
import eu.clarin.weblicht.bindings.cmd.ws.ApplicationType;
import eu.clarin.weblicht.bindings.cmd.ws.Contact;
import eu.clarin.weblicht.bindings.cmd.ws.Creation;
import eu.clarin.weblicht.bindings.cmd.ws.Operations;
import eu.clarin.weblicht.bindings.cmd.ws.ServiceDescriptionLocation;
import eu.clarin.weblicht.bindings.cmd.ws.SimpleApplicationType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Service
extends AbstractComponent {
    @XmlTransient
    private static final String SHORT = "short";
    private static final StringBinding RESTFULL = new StringBinding("RESTfull");
    private static final StringBinding DEVELOPMENT = new StringBinding("development");
    private static final ApplicationType WEB_SERVICE = new ApplicationType(SimpleApplicationType.WEB_SERVICE);
    @XmlElement(name="Name", required=true)
    private StringBinding name;
    @XmlElement(name="Description", required=true)
    private List<Description> descriptions;
    @XmlTransient
    private int descriptionIndex = -1;
    @XmlTransient
    private int shortDescriptionIndex = -1;
    @XmlElement(name="ApplicationType")
    private ApplicationType applicationType = WEB_SERVICE;
    @XmlElement(name="TypeOfWebservice")
    private StringBinding typeOfWebservice;
    @XmlElement(required=true)
    @XmlSchemaType(name="anyURI")
    private URI url;
    @XmlElement(name="LifeCycleStatus", required=true)
    private StringBinding lifeCycleStatus;
    @XmlElement(name="PublicationDate", required=true)
    private Calendar publicationDate;
    @XmlElement(name="LastUpdate", required=true)
    private Calendar lastUpdate;
    @XmlElement(name="ServiceDescriptionLocation", required=true)
    private ServiceDescriptionLocation serviceDescriptionLocation;
    @XmlElement(name="Contact", required=true)
    private Contact contact;
    @XmlElement(name="Creation", required=true)
    private Creation creation;
    @XmlElement(name="Operations", required=true)
    private Operations operations;

    private Service() {
    }

    Service(Object proxyId) {
        this.typeOfWebservice = RESTFULL;
        this.lifeCycleStatus = DEVELOPMENT;
        this.publicationDate = new GregorianCalendar();
        this.serviceDescriptionLocation = new ServiceDescriptionLocation(Collections.singletonList(proxyId));
    }

    public StringBinding getName() {
        return this.name;
    }

    public void setName(StringBinding name) {
        this.name = name;
    }

    public List<Description> getDescriptions() {
        return this.descriptions;
    }

    public Description getDescription() {
        if (this.descriptionIndex == -1) {
            this.initDescriptions();
        }
        return this.descriptions.get(this.descriptionIndex);
    }

    public void setDescription(String description) {
        if (this.descriptionIndex == -1) {
            this.initDescriptions();
        }
        this.descriptions.set(this.descriptionIndex, new Description(description));
    }

    public Description getShortDescription() {
        if (this.shortDescriptionIndex == -1) {
            this.initDescriptions();
        }
        return this.descriptions.get(this.shortDescriptionIndex);
    }

    public void setShortDescription(String shortDescription) {
        if (this.shortDescriptionIndex == -1) {
            this.initDescriptions();
        }
        this.descriptions.set(this.shortDescriptionIndex, new Description(SHORT, shortDescription));
    }

    private void initDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<Description>(2);
        } else {
            for (int i = 0; i < this.descriptions.size(); ++i) {
                String type = this.descriptions.get(i).getType();
                if (type == null) {
                    this.descriptionIndex = i;
                    continue;
                }
                if (!type.equals(SHORT)) continue;
                this.shortDescriptionIndex = i;
            }
        }
        if (this.descriptionIndex == -1) {
            this.descriptionIndex = this.descriptions.size();
            this.descriptions.add(new Description());
        }
        if (this.shortDescriptionIndex == -1) {
            this.shortDescriptionIndex = this.descriptions.size();
            this.descriptions.add(new Description());
        }
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public StringBinding getTypeOfWebservice() {
        return this.typeOfWebservice;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public StringBinding getLifeCycleStatus() {
        return this.lifeCycleStatus;
    }

    public void setLifeCycleStatus(StringBinding lifeCycleStatus) {
        this.lifeCycleStatus = lifeCycleStatus;
    }

    public Calendar getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate() {
        this.publicationDate = new GregorianCalendar();
    }

    public Calendar getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate() {
        this.lastUpdate = new GregorianCalendar();
    }

    public ServiceDescriptionLocation getServiceDescriptionLocation() {
        return this.serviceDescriptionLocation;
    }

    public void setServiceDescriptionLocation(Object proxyId) {
        this.serviceDescriptionLocation = new ServiceDescriptionLocation(Collections.singletonList(proxyId));
    }

    public Contact getContact() {
        if (this.contact == null) {
            this.contact = new Contact();
        }
        return this.contact;
    }

    public Creation getCreation() {
        if (this.creation == null) {
            this.creation = new Creation();
        }
        return this.creation;
    }

    public Operations getOperations() {
        if (this.operations == null) {
            this.operations = new Operations();
        }
        return this.operations;
    }

    public String toString() {
        return "Service{name=" + this.name + ", description=" + this.descriptions + ", uri=" + this.url + ", status=" + this.lifeCycleStatus + ", published=" + DatatypeConverter.printDateTime((Calendar)this.publicationDate) + ", updated=" + DatatypeConverter.printDateTime((Calendar)this.lastUpdate) + ", contact=" + this.contact + " " + this.operations + '}';
    }

    @Override
    public Service copy() {
        Service service = (Service)super.copy();
        service.descriptions = Service.shallowCopy(this.descriptions);
        service.serviceDescriptionLocation = Service.copy(this.serviceDescriptionLocation);
        service.contact = Service.copy(this.contact);
        service.creation = Service.copy(this.creation);
        service.operations = Service.copy(this.operations);
        return service;
    }
}

