/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.bindings.cmd.ws;

import eu.clarin.weblicht.bindings.cmd.AbstractCMD;
import eu.clarin.weblicht.bindings.cmd.Header;
import eu.clarin.weblicht.bindings.cmd.ResourceProxy;
import eu.clarin.weblicht.bindings.cmd.ResourceType;
import eu.clarin.weblicht.bindings.cmd.Resources;
import eu.clarin.weblicht.bindings.cmd.SimpleResourceType;
import eu.clarin.weblicht.bindings.cmd.ws.Components;
import eu.clarin.weblicht.bindings.cmd.ws.Service;
import java.net.URI;
import java.util.Collections;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="CMD")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceCMD
extends AbstractCMD {
    private static final String CMD_VERSION = "1.1";
    private static final String WADL_MIMETYPE = "application/vnd.sun.wadl+xml";
    private static final String PROXY_ID = "s001";
    @XmlElement(name="Components", required=true)
    private Components components;

    private ServiceCMD() {
    }

    ServiceCMD(URI wadlLocation) {
        this.cmdVersion = CMD_VERSION;
        this.header = new Header(null);
        ResourceProxy wadlResource = new ResourceProxy(new ResourceType(SimpleResourceType.RESOURCE, WADL_MIMETYPE), wadlLocation, PROXY_ID);
        this.resources = new Resources(Collections.singletonList(wadlResource));
        this.components = new Components(wadlResource);
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }

    public Components getComponents() {
        return this.components;
    }

    public Service extractService() {
        return this.components != null && this.components.getWebLichtWebService() != null ? this.components.getWebLichtWebService().getService() : null;
    }

    public void setServiceDescriptionLocationId(String id) {
        ResourceProxy resourceProxy = this.resources.getFirstResourceProxy();
        resourceProxy.setId(id);
        this.components.getWebLichtWebService().getService().setServiceDescriptionLocation(resourceProxy);
    }

    @Override
    public ServiceCMD copy() {
        ServiceCMD service = (ServiceCMD)super.copy();
        ResourceProxy wadlResource = service.resources.getFirstResourceProxy();
        service.components = ServiceCMD.copy(this.components);
        this.components.getWebLichtWebService().getService().getServiceDescriptionLocation().setRef(wadlResource);
        return service;
    }
}

