/*
 * Decompiled with CFR 0.152.
 */
package eu.clarin.weblicht.bindings.oai;

import eu.clarin.weblicht.bindings.oai.ListRecords;
import eu.clarin.weblicht.bindings.oai.Record;
import eu.clarin.weblicht.bindings.oai.Request;
import java.net.URI;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="OAI-PMH")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"responseDate", "request", "error", "listRecords"})
public class OAIPMH {
    @XmlElement
    private Calendar responseDate;
    @XmlElement
    private Request request;
    @XmlElement
    private String error;
    @XmlElement(name="ListRecords")
    private ListRecords listRecords;

    private OAIPMH() {
    }

    public OAIPMH(List<Record> records, URI url) {
        this.responseDate = new GregorianCalendar();
        this.request = new Request("ListRecords", "cmdi", url);
        this.listRecords = new ListRecords(records);
    }

    public OAIPMH(List<Record> records, URI url, String resumptionToken) {
        this.responseDate = new GregorianCalendar();
        this.request = new Request("ListRecords", "cmdi", url);
        this.listRecords = new ListRecords(records, resumptionToken);
    }

    public ListRecords getListRecords() {
        return this.listRecords;
    }

    public String getError() {
        return this.error;
    }

    public Request getRequest() {
        return this.request;
    }

    public Calendar getResponseDate() {
        return this.responseDate;
    }

    public String toString() {
        return "OAI-PMH{responseDate=" + this.responseDate + ", request=" + this.request + ", listRecords=" + this.listRecords + '}';
    }
}

